/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.utils.UUIDGen;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.util.CharsetUtil;

public abstract class CBUtil {
    private CBUtil() {
    }

    private static String readString(ChannelBuffer cb, int length) {
        try {
            String str = cb.toString(cb.readerIndex(), length, CharsetUtil.UTF_8);
            cb.readerIndex(cb.readerIndex() + length);
            return str;
        }
        catch (IllegalStateException e) {
            if (e.getCause() instanceof CharacterCodingException) {
                throw new ProtocolException("Cannot decode string as UTF8");
            }
            throw e;
        }
    }

    public static String readString(ChannelBuffer cb) {
        try {
            int length = cb.readUnsignedShort();
            return CBUtil.readString(cb, length);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ProtocolException("Not enough bytes to read an UTF8 serialized string preceded by it's 2 bytes length");
        }
    }

    public static void writeString(String str, ChannelBuffer cb) {
        byte[] bytes = str.getBytes(CharsetUtil.UTF_8);
        cb.writeShort(bytes.length);
        cb.writeBytes(bytes);
    }

    public static int sizeOfString(String str) {
        return 2 + TypeSizes.encodedUTF8Length(str);
    }

    public static String readLongString(ChannelBuffer cb) {
        try {
            int length = cb.readInt();
            return CBUtil.readString(cb, length);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ProtocolException("Not enough bytes to read an UTF8 serialized string preceded by it's 4 bytes length");
        }
    }

    public static void writeLongString(String str, ChannelBuffer cb) {
        byte[] bytes = str.getBytes(CharsetUtil.UTF_8);
        cb.writeInt(bytes.length);
        cb.writeBytes(bytes);
    }

    public static int sizeOfLongString(String str) {
        return 4 + str.getBytes(CharsetUtil.UTF_8).length;
    }

    public static byte[] readBytes(ChannelBuffer cb) {
        try {
            int length = cb.readUnsignedShort();
            byte[] bytes = new byte[length];
            cb.readBytes(bytes);
            return bytes;
        }
        catch (IndexOutOfBoundsException e) {
            throw new ProtocolException("Not enough bytes to read a byte array preceded by it's 2 bytes length");
        }
    }

    public static void writeBytes(byte[] bytes, ChannelBuffer cb) {
        cb.writeShort(bytes.length);
        cb.writeBytes(bytes);
    }

    public static int sizeOfBytes(byte[] bytes) {
        return 2 + bytes.length;
    }

    public static ConsistencyLevel readConsistencyLevel(ChannelBuffer cb) {
        return ConsistencyLevel.fromCode(cb.readUnsignedShort());
    }

    public static void writeConsistencyLevel(ConsistencyLevel consistency, ChannelBuffer cb) {
        cb.writeShort(consistency.code);
    }

    public static int sizeOfConsistencyLevel(ConsistencyLevel consistency) {
        return 2;
    }

    public static <T extends Enum<T>> T readEnumValue(Class<T> enumType, ChannelBuffer cb) {
        String value = CBUtil.readString(cb);
        try {
            return Enum.valueOf(enumType, value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new ProtocolException(String.format("Invalid value '%s' for %s", value, enumType.getSimpleName()));
        }
    }

    public static <T extends Enum<T>> void writeEnumValue(T enumValue, ChannelBuffer cb) {
        CBUtil.writeString(enumValue.toString(), cb);
    }

    public static <T extends Enum<T>> int sizeOfEnumValue(T enumValue) {
        return CBUtil.sizeOfString(enumValue.toString());
    }

    public static UUID readUUID(ChannelBuffer cb) {
        byte[] bytes = new byte[16];
        cb.readBytes(bytes);
        return UUIDGen.getUUID(ByteBuffer.wrap(bytes));
    }

    public static void writeUUID(UUID uuid, ChannelBuffer cb) {
        cb.writeBytes(UUIDGen.decompose(uuid));
    }

    public static int sizeOfUUID(UUID uuid) {
        return 16;
    }

    public static List<String> readStringList(ChannelBuffer cb) {
        int length = cb.readUnsignedShort();
        ArrayList<String> l = new ArrayList<String>(length);
        for (int i = 0; i < length; ++i) {
            l.add(CBUtil.readString(cb));
        }
        return l;
    }

    public static void writeStringList(List<String> l, ChannelBuffer cb) {
        cb.writeShort(l.size());
        for (String str : l) {
            CBUtil.writeString(str, cb);
        }
    }

    public static int sizeOfStringList(List<String> l) {
        int size = 2;
        for (String str : l) {
            size += CBUtil.sizeOfString(str);
        }
        return size;
    }

    public static Map<String, String> readStringMap(ChannelBuffer cb) {
        int length = cb.readUnsignedShort();
        HashMap<String, String> m = new HashMap<String, String>(length);
        for (int i = 0; i < length; ++i) {
            String k = CBUtil.readString(cb).toUpperCase();
            String v = CBUtil.readString(cb);
            m.put(k, v);
        }
        return m;
    }

    public static void writeStringMap(Map<String, String> m, ChannelBuffer cb) {
        cb.writeShort(m.size());
        for (Map.Entry<String, String> entry : m.entrySet()) {
            CBUtil.writeString(entry.getKey(), cb);
            CBUtil.writeString(entry.getValue(), cb);
        }
    }

    public static int sizeOfStringMap(Map<String, String> m) {
        int size = 2;
        for (Map.Entry<String, String> entry : m.entrySet()) {
            size += CBUtil.sizeOfString(entry.getKey());
            size += CBUtil.sizeOfString(entry.getValue());
        }
        return size;
    }

    public static Map<String, List<String>> readStringToStringListMap(ChannelBuffer cb) {
        int length = cb.readUnsignedShort();
        HashMap<String, List<String>> m = new HashMap<String, List<String>>(length);
        for (int i = 0; i < length; ++i) {
            String k = CBUtil.readString(cb).toUpperCase();
            List<String> v = CBUtil.readStringList(cb);
            m.put(k, v);
        }
        return m;
    }

    public static void writeStringToStringListMap(Map<String, List<String>> m, ChannelBuffer cb) {
        cb.writeShort(m.size());
        for (Map.Entry<String, List<String>> entry : m.entrySet()) {
            CBUtil.writeString(entry.getKey(), cb);
            CBUtil.writeStringList(entry.getValue(), cb);
        }
    }

    public static int sizeOfStringToStringListMap(Map<String, List<String>> m) {
        int size = 2;
        for (Map.Entry<String, List<String>> entry : m.entrySet()) {
            size += CBUtil.sizeOfString(entry.getKey());
            size += CBUtil.sizeOfStringList(entry.getValue());
        }
        return size;
    }

    public static ByteBuffer readValue(ChannelBuffer cb) {
        int length = cb.readInt();
        return length < 0 ? null : cb.readSlice(length).toByteBuffer();
    }

    public static void writeValue(byte[] bytes, ChannelBuffer cb) {
        if (bytes == null) {
            cb.writeInt(-1);
            return;
        }
        cb.writeInt(bytes.length);
        cb.writeBytes(bytes);
    }

    public static void writeValue(ByteBuffer bytes, ChannelBuffer cb) {
        if (bytes == null) {
            cb.writeInt(-1);
            return;
        }
        cb.writeInt(bytes.remaining());
        cb.writeBytes(bytes.duplicate());
    }

    public static int sizeOfValue(byte[] bytes) {
        return 4 + (bytes == null ? 0 : bytes.length);
    }

    public static int sizeOfValue(ByteBuffer bytes) {
        return 4 + (bytes == null ? 0 : bytes.remaining());
    }

    public static List<ByteBuffer> readValueList(ChannelBuffer cb) {
        int size = cb.readUnsignedShort();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<ByteBuffer> l = new ArrayList<ByteBuffer>(size);
        for (int i = 0; i < size; ++i) {
            l.add(CBUtil.readValue(cb));
        }
        return l;
    }

    public static void writeValueList(List<ByteBuffer> values, ChannelBuffer cb) {
        cb.writeShort(values.size());
        for (ByteBuffer value : values) {
            CBUtil.writeValue(value, cb);
        }
    }

    public static int sizeOfValueList(List<ByteBuffer> values) {
        int size = 2;
        for (ByteBuffer value : values) {
            size += CBUtil.sizeOfValue(value);
        }
        return size;
    }

    public static InetSocketAddress readInet(ChannelBuffer cb) {
        byte addrSize = cb.readByte();
        byte[] address = new byte[addrSize];
        cb.readBytes(address);
        int port = cb.readInt();
        try {
            return new InetSocketAddress(InetAddress.getByAddress(address), port);
        }
        catch (UnknownHostException e) {
            throw new ProtocolException(String.format("Invalid IP address (%d.%d.%d.%d) while deserializing inet address", address[0], address[1], address[2], address[3]));
        }
    }

    public static void writeInet(InetSocketAddress inet, ChannelBuffer cb) {
        byte[] address = inet.getAddress().getAddress();
        cb.writeByte(address.length);
        cb.writeBytes(address);
        cb.writeInt(inet.getPort());
    }

    public static int sizeOfInet(InetSocketAddress inet) {
        byte[] address = inet.getAddress().getAddress();
        return 1 + address.length + 4;
    }

    public static byte[] readRawBytes(ChannelBuffer cb) {
        if (cb.hasArray() && cb.readableBytes() == cb.array().length) {
            cb.readerIndex(cb.writerIndex());
            return cb.array();
        }
        byte[] bytes = new byte[cb.readableBytes()];
        cb.readBytes(bytes);
        return bytes;
    }
}

