/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.net.CompactEndpointSerializationHelper;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessagingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xerial.snappy.SnappyInputStream;

public class IncomingTcpConnection
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(IncomingTcpConnection.class);
    private final int version;
    private final boolean compressed;
    private final Socket socket;
    public InetAddress from;

    public IncomingTcpConnection(int version, boolean compressed, Socket socket) {
        assert (socket != null);
        this.version = version;
        this.compressed = compressed;
        this.socket = socket;
        if (DatabaseDescriptor.getInternodeRecvBufferSize() != null) {
            try {
                this.socket.setReceiveBufferSize(DatabaseDescriptor.getInternodeRecvBufferSize());
            }
            catch (SocketException se) {
                logger.warn("Failed to set receive buffer size on internode socket.", (Throwable)se);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.version < 6) {
                this.handleLegacyVersion();
            } else {
                this.handleModernVersion();
            }
        }
        catch (EOFException e) {
            logger.trace("eof reading from socket; closing", (Throwable)e);
        }
        catch (IOException e) {
            logger.debug("IOException reading from socket; closing", (Throwable)e);
        }
        finally {
            this.close();
        }
    }

    private void handleModernVersion() throws IOException {
        DataOutputStream out = new DataOutputStream(this.socket.getOutputStream());
        out.writeInt(7);
        out.flush();
        DataInputStream in = new DataInputStream(this.socket.getInputStream());
        int maxVersion = in.readInt();
        this.from = CompactEndpointSerializationHelper.deserialize(in);
        if (this.compressed) {
            logger.debug("Upgrading incoming connection to be compressed");
            in = new DataInputStream((InputStream)new SnappyInputStream(this.socket.getInputStream()));
        } else {
            in = new DataInputStream(new BufferedInputStream(this.socket.getInputStream(), 4096));
        }
        logger.debug("Max version for {} is {}", (Object)this.from, (Object)maxVersion);
        if (this.version > 7) {
            Gossiper.instance.addSavedEndpoint(this.from);
            logger.info("Received messages from newer protocol version {}. Ignoring", (Object)this.version);
            return;
        }
        MessagingService.instance().setVersion(this.from, Math.min(7, maxVersion));
        logger.debug("set version for {} to {}", (Object)this.from, (Object)Math.min(7, maxVersion));
        while (true) {
            MessagingService.validateMagic(in.readInt());
            this.receiveMessage(in, this.version);
        }
    }

    private void handleLegacyVersion() {
        throw new UnsupportedOperationException("Unable to read obsolete message version " + this.version + "; the earliest version supported is 1.2.0");
    }

    private InetAddress receiveMessage(DataInputStream input, int version) throws IOException {
        MessageIn message;
        int id = version < 7 ? Integer.parseInt(input.readUTF()) : input.readInt();
        long timestamp = System.currentTimeMillis();
        int partial = input.readInt();
        if (DatabaseDescriptor.hasCrossNodeTimeout()) {
            timestamp = timestamp & 0xFFFFFFFF00000000L | ((long)partial & 0xFFFFFFFFL) << 2 >> 2;
        }
        if ((message = MessageIn.read(input, version, id)) == null) {
            return null;
        }
        if (version <= 7) {
            MessagingService.instance().receive(message, id, timestamp);
        } else {
            logger.debug("Received connection from newer protocol version {}. Ignoring message", (Object)version);
        }
        return message.from;
    }

    private void close() {
        block3: {
            if (this.from != null) {
                MessagingService.instance().resetVersion(this.from);
            }
            try {
                this.socket.close();
            }
            catch (IOException e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("error closing socket", (Throwable)e);
            }
        }
    }
}

