/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.Lists;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.thrift.IndexOperator;

public interface Restriction {
    public boolean isOnToken();

    public boolean isSlice();

    public boolean isEQ();

    public boolean isIN();

    public List<ByteBuffer> values(List<ByteBuffer> var1) throws InvalidRequestException;

    public static class Slice
    implements Restriction {
        private final Term[] bounds = new Term[2];
        private final boolean[] boundInclusive = new boolean[2];
        private final boolean onToken;

        public Slice(boolean onToken) {
            this.onToken = onToken;
        }

        @Override
        public boolean isSlice() {
            return true;
        }

        @Override
        public boolean isEQ() {
            return false;
        }

        @Override
        public boolean isIN() {
            return false;
        }

        @Override
        public List<ByteBuffer> values(List<ByteBuffer> variables) throws InvalidRequestException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOnToken() {
            return this.onToken;
        }

        public boolean hasBound(Bound b) {
            return this.bounds[b.idx] != null;
        }

        public ByteBuffer bound(Bound b, List<ByteBuffer> variables) throws InvalidRequestException {
            return this.bounds[b.idx].bindAndGet(variables);
        }

        public boolean isInclusive(Bound b) {
            return this.bounds[b.idx] == null || this.boundInclusive[b.idx];
        }

        public Relation.Type getRelation(Bound eocBound, Bound inclusiveBound) {
            switch (eocBound) {
                case START: {
                    return this.boundInclusive[inclusiveBound.idx] ? Relation.Type.GTE : Relation.Type.GT;
                }
                case END: {
                    return this.boundInclusive[inclusiveBound.idx] ? Relation.Type.LTE : Relation.Type.LT;
                }
            }
            throw new AssertionError();
        }

        public IndexOperator getIndexOperator(Bound b) {
            switch (b) {
                case START: {
                    return this.boundInclusive[b.idx] ? IndexOperator.GTE : IndexOperator.GT;
                }
                case END: {
                    return this.boundInclusive[b.idx] ? IndexOperator.LTE : IndexOperator.LT;
                }
            }
            throw new AssertionError();
        }

        public void setBound(ColumnIdentifier name, Relation.Type type, Term t) throws InvalidRequestException {
            boolean inclusive;
            Bound b;
            switch (type) {
                case GT: {
                    b = Bound.START;
                    inclusive = false;
                    break;
                }
                case GTE: {
                    b = Bound.START;
                    inclusive = true;
                    break;
                }
                case LT: {
                    b = Bound.END;
                    inclusive = false;
                    break;
                }
                case LTE: {
                    b = Bound.END;
                    inclusive = true;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (this.bounds[b.idx] != null) {
                throw new InvalidRequestException(String.format("Invalid restrictions found on %s", name));
            }
            this.bounds[b.idx] = t;
            this.boundInclusive[b.idx] = inclusive;
        }

        public String toString() {
            return String.format("SLICE(%s %s, %s %s)%s", this.boundInclusive[0] ? ">=" : ">", this.bounds[0], this.boundInclusive[1] ? "<=" : "<", this.bounds[1], this.onToken ? "*" : "");
        }
    }

    public static abstract class IN
    implements Restriction {
        public static IN create(List<Term> values) {
            return new WithValues(values);
        }

        public static IN create(Term value) throws InvalidRequestException {
            assert (value instanceof Lists.Marker);
            return new WithMarker((Lists.Marker)value);
        }

        @Override
        public boolean isSlice() {
            return false;
        }

        @Override
        public boolean isEQ() {
            return false;
        }

        @Override
        public boolean isIN() {
            return true;
        }

        public abstract boolean canHaveOnlyOneValue();

        @Override
        public boolean isOnToken() {
            return false;
        }

        private static class WithMarker
        extends IN {
            private final Lists.Marker marker;

            private WithMarker(Lists.Marker marker) {
                this.marker = marker;
            }

            @Override
            public List<ByteBuffer> values(List<ByteBuffer> variables) throws InvalidRequestException {
                Term.Terminal lval = this.marker.bind((List)variables);
                if (lval == null) {
                    throw new InvalidRequestException("Invalid null value for IN restriction");
                }
                return ((Lists.Value)lval).elements;
            }

            @Override
            public boolean canHaveOnlyOneValue() {
                return false;
            }

            public String toString() {
                return "IN ?";
            }
        }

        private static class WithValues
        extends IN {
            private final List<Term> values;

            private WithValues(List<Term> values) {
                this.values = values;
            }

            @Override
            public List<ByteBuffer> values(List<ByteBuffer> variables) throws InvalidRequestException {
                ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(this.values.size());
                for (Term value : this.values) {
                    buffers.add(value.bindAndGet(variables));
                }
                return buffers;
            }

            @Override
            public boolean canHaveOnlyOneValue() {
                return this.values.size() == 1;
            }

            public String toString() {
                return String.format("IN(%s)", this.values);
            }
        }
    }

    public static class EQ
    implements Restriction {
        private final Term value;
        private final boolean onToken;

        public EQ(Term value, boolean onToken) {
            this.value = value;
            this.onToken = onToken;
        }

        @Override
        public List<ByteBuffer> values(List<ByteBuffer> variables) throws InvalidRequestException {
            return Collections.singletonList(this.value.bindAndGet(variables));
        }

        @Override
        public boolean isSlice() {
            return false;
        }

        @Override
        public boolean isEQ() {
            return true;
        }

        @Override
        public boolean isIN() {
            return false;
        }

        @Override
        public boolean isOnToken() {
            return this.onToken;
        }

        public String toString() {
            return String.format("EQ(%s)%s", this.value, this.onToken ? "*" : "");
        }
    }
}

