/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Lists;
import org.apache.cassandra.cql3.Maps;
import org.apache.cassandra.cql3.Sets;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.exceptions.InvalidRequestException;

public abstract class Operation {
    public final ColumnIdentifier columnName;
    protected final Term t;

    protected Operation(ColumnIdentifier columnName, Term t) {
        this.columnName = columnName;
        this.t = t;
    }

    public boolean requiresRead() {
        return false;
    }

    public void collectMarkerSpecification(VariableSpecifications boundNames) {
        if (this.t != null) {
            this.t.collectMarkerSpecification(boundNames);
        }
    }

    public abstract void execute(ByteBuffer var1, ColumnFamily var2, ColumnNameBuilder var3, UpdateParameters var4) throws InvalidRequestException;

    public static class ElementDeletion
    implements RawDeletion {
        private final ColumnIdentifier id;
        private final Term.Raw element;

        public ElementDeletion(ColumnIdentifier id, Term.Raw element) {
            this.id = id;
            this.element = element;
        }

        @Override
        public ColumnIdentifier affectedColumn() {
            return this.id;
        }

        @Override
        public Operation prepare(ColumnSpecification receiver) throws InvalidRequestException {
            if (!(receiver.type instanceof CollectionType)) {
                throw new InvalidRequestException(String.format("Invalid deletion operation for non collection column %s", receiver));
            }
            switch (((CollectionType)receiver.type).kind) {
                case LIST: {
                    Term idx = this.element.prepare(Lists.indexSpecOf(receiver));
                    return new Lists.DiscarderByIndex(this.id, idx);
                }
                case SET: {
                    Term elt = this.element.prepare(Sets.valueSpecOf(receiver));
                    return new Lists.Discarder(this.id, elt);
                }
                case MAP: {
                    Term key = this.element.prepare(Maps.keySpecOf(receiver));
                    return new Maps.DiscarderByKey(this.id, key);
                }
            }
            throw new AssertionError();
        }
    }

    public static class ColumnDeletion
    implements RawDeletion {
        private final ColumnIdentifier id;

        public ColumnDeletion(ColumnIdentifier id) {
            this.id = id;
        }

        @Override
        public ColumnIdentifier affectedColumn() {
            return this.id;
        }

        @Override
        public Operation prepare(ColumnSpecification receiver) throws InvalidRequestException {
            return new Constants.Deleter(this.id, receiver.type instanceof CollectionType);
        }
    }

    public static class Prepend
    implements RawUpdate {
        private final Term.Raw value;

        public Prepend(Term.Raw value) {
            this.value = value;
        }

        @Override
        public Operation prepare(CFDefinition.Name receiver) throws InvalidRequestException {
            Term v = this.value.prepare(receiver);
            if (!(receiver.type instanceof ListType)) {
                throw new InvalidRequestException(String.format("Invalid operation (%s) for non list column %s", this.toString(receiver), receiver));
            }
            return new Lists.Prepender(receiver.name, v);
        }

        protected String toString(ColumnSpecification column) {
            return String.format("%s = %s - %s", column, this.value, column);
        }

        @Override
        public boolean isCompatibleWith(RawUpdate other) {
            return !(other instanceof SetValue);
        }
    }

    public static class Substraction
    implements RawUpdate {
        private final Term.Raw value;

        public Substraction(Term.Raw value) {
            this.value = value;
        }

        @Override
        public Operation prepare(CFDefinition.Name receiver) throws InvalidRequestException {
            Term v = this.value.prepare(receiver);
            if (!(receiver.type instanceof CollectionType)) {
                if (!(receiver.type instanceof CounterColumnType)) {
                    throw new InvalidRequestException(String.format("Invalid operation (%s) for non counter column %s", this.toString(receiver), receiver));
                }
                return new Constants.Substracter(receiver.kind == CFDefinition.Name.Kind.VALUE_ALIAS ? null : receiver.name, v);
            }
            switch (((CollectionType)receiver.type).kind) {
                case LIST: {
                    return new Lists.Discarder(receiver.name, v);
                }
                case SET: {
                    return new Sets.Discarder(receiver.name, v);
                }
                case MAP: {
                    throw new InvalidRequestException(String.format("Invalid operation (%s) for map column %s", this.toString(receiver), receiver));
                }
            }
            throw new AssertionError();
        }

        protected String toString(ColumnSpecification column) {
            return String.format("%s = %s - %s", column, column, this.value);
        }

        @Override
        public boolean isCompatibleWith(RawUpdate other) {
            return !(other instanceof SetValue);
        }
    }

    public static class Addition
    implements RawUpdate {
        private final Term.Raw value;

        public Addition(Term.Raw value) {
            this.value = value;
        }

        @Override
        public Operation prepare(CFDefinition.Name receiver) throws InvalidRequestException {
            Term v = this.value.prepare(receiver);
            if (!(receiver.type instanceof CollectionType)) {
                if (!(receiver.type instanceof CounterColumnType)) {
                    throw new InvalidRequestException(String.format("Invalid operation (%s) for non counter column %s", this.toString(receiver), receiver));
                }
                return new Constants.Adder(receiver.kind == CFDefinition.Name.Kind.VALUE_ALIAS ? null : receiver.name, v);
            }
            switch (((CollectionType)receiver.type).kind) {
                case LIST: {
                    return new Lists.Appender(receiver.name, v);
                }
                case SET: {
                    return new Sets.Adder(receiver.name, v);
                }
                case MAP: {
                    return new Maps.Putter(receiver.name, v);
                }
            }
            throw new AssertionError();
        }

        protected String toString(ColumnSpecification column) {
            return String.format("%s = %s + %s", column, column, this.value);
        }

        @Override
        public boolean isCompatibleWith(RawUpdate other) {
            return !(other instanceof SetValue);
        }
    }

    public static class SetElement
    implements RawUpdate {
        private final Term.Raw selector;
        private final Term.Raw value;

        public SetElement(Term.Raw selector, Term.Raw value) {
            this.selector = selector;
            this.value = value;
        }

        @Override
        public Operation prepare(CFDefinition.Name receiver) throws InvalidRequestException {
            if (!(receiver.type instanceof CollectionType)) {
                throw new InvalidRequestException(String.format("Invalid operation (%s) for non collection column %s", this.toString(receiver), receiver));
            }
            switch (((CollectionType)receiver.type).kind) {
                case LIST: {
                    Term idx = this.selector.prepare(Lists.indexSpecOf(receiver));
                    Term lval = this.value.prepare(Lists.valueSpecOf(receiver));
                    return new Lists.SetterByIndex(receiver.name, idx, lval);
                }
                case SET: {
                    throw new InvalidRequestException(String.format("Invalid operation (%s) for set column %s", this.toString(receiver), receiver));
                }
                case MAP: {
                    Term key = this.selector.prepare(Maps.keySpecOf(receiver));
                    Term mval = this.value.prepare(Maps.valueSpecOf(receiver));
                    return new Maps.SetterByKey(receiver.name, key, mval);
                }
            }
            throw new AssertionError();
        }

        protected String toString(ColumnSpecification column) {
            return String.format("%s[%s] = %s", column, this.selector, this.value);
        }

        @Override
        public boolean isCompatibleWith(RawUpdate other) {
            return !(other instanceof SetValue);
        }
    }

    public static class SetValue
    implements RawUpdate {
        private final Term.Raw value;

        public SetValue(Term.Raw value) {
            this.value = value;
        }

        @Override
        public Operation prepare(CFDefinition.Name receiver) throws InvalidRequestException {
            Term v = this.value.prepare(receiver);
            if (receiver.type instanceof CounterColumnType) {
                throw new InvalidRequestException(String.format("Cannot set the value of counter column %s (counters can only be incremented/decremented, not set)", receiver));
            }
            if (!(receiver.type instanceof CollectionType)) {
                return new Constants.Setter(receiver.kind == CFDefinition.Name.Kind.VALUE_ALIAS ? null : receiver.name, v);
            }
            switch (((CollectionType)receiver.type).kind) {
                case LIST: {
                    return new Lists.Setter(receiver.name, v);
                }
                case SET: {
                    return new Sets.Setter(receiver.name, v);
                }
                case MAP: {
                    return new Maps.Setter(receiver.name, v);
                }
            }
            throw new AssertionError();
        }

        protected String toString(ColumnSpecification column) {
            return String.format("%s = %s", column, this.value);
        }

        @Override
        public boolean isCompatibleWith(RawUpdate other) {
            return false;
        }
    }

    public static interface RawDeletion {
        public ColumnIdentifier affectedColumn();

        public Operation prepare(ColumnSpecification var1) throws InvalidRequestException;
    }

    public static interface RawUpdate {
        public Operation prepare(CFDefinition.Name var1) throws InvalidRequestException;

        public boolean isCompatibleWith(RawUpdate var1);
    }
}

