/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import java.net.InetAddress;
import java.util.Map;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.utils.UUIDGen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HintedHandoffMetrics {
    private static final Logger logger = LoggerFactory.getLogger(HintedHandoffMetrics.class);
    public static final String GROUP_NAME = "org.apache.cassandra.metrics";
    public static final String TYPE_NAME = "HintedHandOffManager";
    private final LoadingCache<InetAddress, DifferencingCounter> notStored = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<InetAddress, DifferencingCounter>(){

        public DifferencingCounter load(InetAddress address) {
            return new DifferencingCounter(address);
        }
    });
    private final LoadingCache<InetAddress, Counter> createdHintCounts = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<InetAddress, Counter>(){

        public Counter load(InetAddress address) {
            return Metrics.newCounter((MetricName)new MetricName(HintedHandoffMetrics.GROUP_NAME, HintedHandoffMetrics.TYPE_NAME, "Hints_created-" + address.getHostAddress()));
        }
    });

    public void incrCreatedHints(InetAddress address) {
        ((Counter)this.createdHintCounts.getUnchecked((Object)address)).inc();
    }

    public void incrPastWindow(InetAddress address) {
        ((DifferencingCounter)this.notStored.getUnchecked((Object)address)).mark();
    }

    public void log() {
        for (Map.Entry entry : this.notStored.asMap().entrySet()) {
            long diffrence = ((DifferencingCounter)entry.getValue()).diffrence();
            if (diffrence == 0L) continue;
            logger.warn("{} has {} dropped hints, because node is down past configured hint window.", entry.getKey(), (Object)diffrence);
            SystemKeyspace.updateHintsDropped((InetAddress)entry.getKey(), UUIDGen.getTimeUUID(), (int)diffrence);
        }
    }

    public class DifferencingCounter {
        private final Counter meter;
        private long reported = 0L;

        public DifferencingCounter(InetAddress address) {
            this.meter = Metrics.newCounter((MetricName)new MetricName(HintedHandoffMetrics.GROUP_NAME, HintedHandoffMetrics.TYPE_NAME, "Hints_not_stored-" + address.getHostAddress()));
        }

        public long diffrence() {
            long current = this.meter.count();
            long diffrence = current - this.reported;
            this.reported = current;
            return diffrence;
        }

        public long count() {
            return this.meter.count();
        }

        public void mark() {
            this.meter.inc();
        }
    }
}

