/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.filter.ExtendedFilter;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.IndexOperator;

public abstract class SecondaryIndexSearcher {
    protected final SecondaryIndexManager indexManager;
    protected final Set<ByteBuffer> columns;
    protected final ColumnFamilyStore baseCfs;

    public SecondaryIndexSearcher(SecondaryIndexManager indexManager, Set<ByteBuffer> columns) {
        this.indexManager = indexManager;
        this.columns = columns;
        this.baseCfs = indexManager.baseCfs;
    }

    public abstract List<Row> search(ExtendedFilter var1);

    public boolean isIndexing(List<IndexExpression> clause) {
        return this.highestSelectivityPredicate(clause) != null;
    }

    protected IndexExpression highestSelectivityPredicate(List<IndexExpression> clause) {
        IndexExpression best = null;
        int bestMeanCount = Integer.MAX_VALUE;
        for (IndexExpression expression : clause) {
            int columns;
            SecondaryIndex index;
            if (!this.columns.contains(expression.column_name) || (index = this.indexManager.getIndexForColumn(expression.column_name)) == null || expression.op != IndexOperator.EQ || (columns = index.getIndexCfs().getMeanColumns()) >= bestMeanCount) continue;
            best = expression;
            bestMeanCount = columns;
        }
        return best;
    }
}

