/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.base.Predicate;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.ColumnGroupMap;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.RawSelector;
import org.apache.cassandra.cql3.statements.Selection;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.RangeSliceCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.ExcludingBounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.IncludingExcludingBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.pager.Pageable;
import org.apache.cassandra.service.pager.QueryPager;
import org.apache.cassandra.service.pager.QueryPagers;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.IndexOperator;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;

public class SelectStatement
implements CQLStatement {
    private static final int DEFAULT_COUNT_PAGE_SIZE = 10000;
    private final int boundTerms;
    public final CFDefinition cfDef;
    public final Parameters parameters;
    private final Selection selection;
    private final Term limit;
    private final Restriction[] keyRestrictions;
    private final Restriction[] columnRestrictions;
    private final Map<CFDefinition.Name, Restriction> metadataRestrictions = new HashMap<CFDefinition.Name, Restriction>();
    private final Set<CFDefinition.Name> restrictedNames = new HashSet<CFDefinition.Name>();
    private Restriction sliceRestriction;
    private boolean isReversed;
    private boolean onToken;
    private boolean isKeyRange;
    private boolean keyIsInRelation;
    private boolean usesSecondaryIndexing;
    private Map<CFDefinition.Name, Integer> orderingIndexes;
    private static final Parameters defaultParameters = new Parameters(Collections.emptyMap(), false, null, false);

    public SelectStatement(CFDefinition cfDef, int boundTerms, Parameters parameters, Selection selection, Term limit) {
        this.cfDef = cfDef;
        this.boundTerms = boundTerms;
        this.selection = selection;
        this.keyRestrictions = new Restriction[cfDef.keys.size()];
        this.columnRestrictions = new Restriction[cfDef.columns.size()];
        this.parameters = parameters;
        this.limit = limit;
    }

    static SelectStatement forSelection(CFDefinition cfDef, Selection selection) {
        return new SelectStatement(cfDef, 0, defaultParameters, selection, null);
    }

    public ResultSet.Metadata getResultMetadata() {
        return this.selection.getResultMetadata();
    }

    @Override
    public int getBoundsTerms() {
        return this.boundTerms;
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException, UnauthorizedException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.SELECT);
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
    }

    @Override
    public ResultMessage.Rows execute(QueryState state, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        List<ReadCommand> commands;
        ConsistencyLevel cl = options.getConsistency();
        List<ByteBuffer> variables = options.getValues();
        if (cl == null) {
            throw new InvalidRequestException("Invalid empty consistency level");
        }
        cl.validateForRead(this.keyspace());
        int limit = this.getLimit(variables);
        long now = System.currentTimeMillis();
        Pageable command = this.isKeyRange || this.usesSecondaryIndexing ? this.getRangeCommand(variables, limit, now) : ((commands = this.getSliceCommands(variables, limit, now)) == null ? null : new Pageable.ReadCommands(commands));
        int pageSize = options.getPageSize();
        if (this.parameters.isCount && pageSize <= 0) {
            pageSize = 10000;
        }
        if (pageSize <= 0 || command == null || !QueryPagers.mayNeedPaging(command, pageSize)) {
            return this.execute(command, cl, variables, limit, now);
        }
        QueryPager pager = QueryPagers.pager(command, cl, options.getPagingState());
        if (this.parameters.isCount) {
            return this.pageCountQuery(pager, variables, pageSize, now);
        }
        List<Row> page = pager.fetchPage(pageSize);
        ResultMessage.Rows msg = this.processResults(page, variables, limit, now);
        if (!pager.isExhausted()) {
            msg.result.metadata.setHasMorePages(pager.state());
        }
        return msg;
    }

    private ResultMessage.Rows execute(Pageable command, ConsistencyLevel cl, List<ByteBuffer> variables, int limit, long now) throws RequestValidationException, RequestExecutionException {
        List<Row> rows = command == null ? Collections.emptyList() : (command instanceof Pageable.ReadCommands ? StorageProxy.read(((Pageable.ReadCommands)command).commands, cl) : StorageProxy.getRangeSlice((RangeSliceCommand)command, cl));
        return this.processResults(rows, variables, limit, now);
    }

    private ResultMessage.Rows pageCountQuery(QueryPager pager, List<ByteBuffer> variables, int pageSize, long now) throws RequestValidationException, RequestExecutionException {
        int count = 0;
        while (!pager.isExhausted()) {
            int maxLimit = pager.maxRemaining();
            ResultSet rset = this.process(pager.fetchPage(pageSize), variables, maxLimit, now);
            count += rset.rows.size();
        }
        ResultSet result = ResultSet.makeCountResult(this.keyspace(), this.columnFamily(), count, this.parameters.countAlias);
        return new ResultMessage.Rows(result);
    }

    public ResultMessage.Rows processResults(List<Row> rows, List<ByteBuffer> variables, int limit, long now) throws RequestValidationException {
        ResultSet rset = this.process(rows, variables, limit, now);
        rset = this.parameters.isCount ? rset.makeCountResult(this.parameters.countAlias) : rset;
        return new ResultMessage.Rows(rset);
    }

    static List<Row> readLocally(String keyspaceName, List<ReadCommand> cmds) {
        Keyspace keyspace = Keyspace.open(keyspaceName);
        ArrayList<Row> rows = new ArrayList<Row>(cmds.size());
        for (ReadCommand cmd : cmds) {
            rows.add(cmd.getRow(keyspace));
        }
        return rows;
    }

    @Override
    public ResultMessage.Rows executeInternal(QueryState state) throws RequestExecutionException, RequestValidationException {
        List<ReadCommand> commands;
        RangeSliceCommand command;
        List<ByteBuffer> variables = Collections.emptyList();
        int limit = this.getLimit(variables);
        long now = System.currentTimeMillis();
        List<Object> rows = this.isKeyRange || this.usesSecondaryIndexing ? ((command = this.getRangeCommand(variables, limit, now)) == null ? Collections.emptyList() : command.executeLocally()) : ((commands = this.getSliceCommands(variables, limit, now)) == null ? Collections.emptyList() : SelectStatement.readLocally(this.keyspace(), commands));
        return this.processResults(rows, variables, limit, now);
    }

    public ResultSet process(List<Row> rows) throws InvalidRequestException {
        assert (!this.parameters.isCount);
        return this.process(rows, Collections.emptyList(), this.getLimit(Collections.emptyList()), System.currentTimeMillis());
    }

    public String keyspace() {
        return this.cfDef.cfm.ksName;
    }

    public String columnFamily() {
        return this.cfDef.cfm.cfName;
    }

    private List<ReadCommand> getSliceCommands(List<ByteBuffer> variables, int limit, long now) throws RequestValidationException {
        Collection<ByteBuffer> keys = this.getKeys(variables);
        if (keys.isEmpty()) {
            return null;
        }
        ArrayList<ReadCommand> commands = new ArrayList<ReadCommand>(keys.size());
        IDiskAtomFilter filter = this.makeFilter(variables, limit);
        if (filter == null) {
            return null;
        }
        for (ByteBuffer key : keys) {
            QueryProcessor.validateKey(key);
            commands.add(ReadCommand.create(this.keyspace(), key, this.columnFamily(), now, filter.cloneShallow()));
        }
        return commands;
    }

    private RangeSliceCommand getRangeCommand(List<ByteBuffer> variables, int limit, long now) throws RequestValidationException {
        IDiskAtomFilter filter = this.makeFilter(variables, limit);
        if (filter == null) {
            return null;
        }
        List<IndexExpression> expressions = this.getIndexExpressions(variables);
        AbstractBounds<RowPosition> keyBounds = this.getKeyBounds(variables);
        return keyBounds == null ? null : new RangeSliceCommand(this.keyspace(), this.columnFamily(), now, filter, keyBounds, expressions, limit, true, false);
    }

    private AbstractBounds<RowPosition> getKeyBounds(List<ByteBuffer> variables) throws InvalidRequestException {
        RowPosition finishKey;
        IPartitioner p = StorageService.getPartitioner();
        if (this.onToken) {
            Token startToken = this.getTokenBound(Bound.START, variables, p);
            Token endToken = this.getTokenBound(Bound.END, variables, p);
            boolean includeStart = this.includeKeyBound(Bound.START);
            boolean includeEnd = this.includeKeyBound(Bound.END);
            int cmp = startToken.compareTo(endToken);
            if (!(startToken.isMinimum() || endToken.isMinimum() || cmp <= 0 && (cmp != 0 || includeStart && includeEnd))) {
                return null;
            }
            Token.KeyBound start = includeStart ? startToken.minKeyBound() : startToken.maxKeyBound();
            Token.KeyBound end = includeEnd ? endToken.maxKeyBound() : endToken.minKeyBound();
            return new Range<RowPosition>(start, end);
        }
        ByteBuffer startKeyBytes = this.getKeyBound(Bound.START, variables);
        ByteBuffer finishKeyBytes = this.getKeyBound(Bound.END, variables);
        RowPosition startKey = RowPosition.forKey(startKeyBytes, p);
        if (startKey.compareTo(finishKey = RowPosition.forKey(finishKeyBytes, p)) > 0 && !finishKey.isMinimum(p)) {
            return null;
        }
        if (this.includeKeyBound(Bound.START)) {
            return this.includeKeyBound(Bound.END) ? new Bounds<RowPosition>(startKey, finishKey) : new IncludingExcludingBounds<RowPosition>(startKey, finishKey);
        }
        return this.includeKeyBound(Bound.END) ? new Range<RowPosition>(startKey, finishKey) : new ExcludingBounds<RowPosition>(startKey, finishKey);
    }

    private IDiskAtomFilter makeFilter(List<ByteBuffer> variables, int limit) throws InvalidRequestException {
        if (this.isColumnRange()) {
            ColumnSlice[] slices;
            int toGroup = this.cfDef.isCompact ? -1 : this.cfDef.columns.size();
            List<ByteBuffer> startBounds = this.getRequestedBound(Bound.START, variables);
            List<ByteBuffer> endBounds = this.getRequestedBound(Bound.END, variables);
            assert (startBounds.size() == endBounds.size());
            if (startBounds.size() == 1) {
                ColumnSlice slice = new ColumnSlice(startBounds.get(0), endBounds.get(0));
                if (slice.isAlwaysEmpty(this.cfDef.cfm.comparator, this.isReversed)) {
                    return null;
                }
                slices = new ColumnSlice[]{slice};
            } else {
                ArrayList<ColumnSlice> l = new ArrayList<ColumnSlice>(startBounds.size());
                for (int i = 0; i < startBounds.size(); ++i) {
                    ColumnSlice slice = new ColumnSlice(startBounds.get(i), endBounds.get(i));
                    if (slice.isAlwaysEmpty(this.cfDef.cfm.comparator, this.isReversed)) continue;
                    l.add(slice);
                }
                if (l.isEmpty()) {
                    return null;
                }
                slices = l.toArray(new ColumnSlice[l.size()]);
            }
            return new SliceQueryFilter(slices, this.isReversed, limit, toGroup);
        }
        SortedSet<ByteBuffer> columnNames = this.getRequestedColumns(variables);
        if (columnNames == null) {
            return null;
        }
        QueryProcessor.validateColumnNames(columnNames);
        return new NamesQueryFilter(columnNames, true);
    }

    private int getLimit(List<ByteBuffer> variables) throws InvalidRequestException {
        int l = Integer.MAX_VALUE;
        if (this.limit != null) {
            ByteBuffer b = this.limit.bindAndGet(variables);
            if (b == null) {
                throw new InvalidRequestException("Invalid null value of limit");
            }
            try {
                Int32Type.instance.validate(b);
                l = (Integer)Int32Type.instance.compose(b);
            }
            catch (MarshalException e) {
                throw new InvalidRequestException("Invalid limit value");
            }
        }
        if (l <= 0) {
            throw new InvalidRequestException("LIMIT must be strictly positive");
        }
        if (this.sliceRestriction != null && !this.sliceRestriction.isInclusive(Bound.START) && l != Integer.MAX_VALUE) {
            ++l;
        }
        return l;
    }

    private Collection<ByteBuffer> getKeys(List<ByteBuffer> variables) throws InvalidRequestException {
        ArrayList<ByteBuffer> keys = new ArrayList<ByteBuffer>();
        ColumnNameBuilder builder = this.cfDef.getKeyNameBuilder();
        for (CFDefinition.Name name : this.cfDef.keys.values()) {
            Restriction r = this.keyRestrictions[name.position];
            assert (r != null);
            if (builder.remainingCount() == 1) {
                for (Term t : r.eqValues) {
                    ByteBuffer val = t.bindAndGet(variables);
                    if (val == null) {
                        throw new InvalidRequestException(String.format("Invalid null value for partition key part %s", name));
                    }
                    keys.add(builder.copy().add(val).build());
                }
                continue;
            }
            if (r.isINRestriction()) {
                throw new InvalidRequestException("IN is only supported on the last column of the partition key");
            }
            ByteBuffer val = r.eqValues.get(0).bindAndGet(variables);
            if (val == null) {
                throw new InvalidRequestException(String.format("Invalid null value for partition key part %s", name));
            }
            builder.add(val);
        }
        return keys;
    }

    private ByteBuffer getKeyBound(Bound b, List<ByteBuffer> variables) throws InvalidRequestException {
        for (int i = 0; i < this.keyRestrictions.length; ++i) {
            if (this.keyRestrictions[i] != null) continue;
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        return this.buildBound(b, this.cfDef.keys.values(), this.keyRestrictions, false, this.cfDef.getKeyNameBuilder(), variables).get(0);
    }

    private Token getTokenBound(Bound b, List<ByteBuffer> variables, IPartitioner<?> p) throws InvalidRequestException {
        Term t;
        assert (this.onToken);
        Restriction keyRestriction = this.keyRestrictions[0];
        Term term = t = keyRestriction.isEquality() ? keyRestriction.eqValues.get(0) : keyRestriction.bound(b);
        if (t == null) {
            return p.getMinimumToken();
        }
        ByteBuffer value = t.bindAndGet(variables);
        if (value == null) {
            throw new InvalidRequestException("Invalid null token value");
        }
        return p.getTokenFactory().fromByteArray(value);
    }

    private boolean includeKeyBound(Bound b) {
        for (Restriction r : this.keyRestrictions) {
            if (r == null) {
                return true;
            }
            if (r.isEquality()) continue;
            return r.isInclusive(b);
        }
        return true;
    }

    private boolean isColumnRange() {
        if (!this.cfDef.isCompact) {
            return this.cfDef.isComposite;
        }
        for (Restriction r : this.columnRestrictions) {
            if (r != null && r.isEquality()) continue;
            return true;
        }
        return false;
    }

    private SortedSet<ByteBuffer> getRequestedColumns(List<ByteBuffer> variables) throws InvalidRequestException {
        assert (!this.isColumnRange());
        ColumnNameBuilder builder = this.cfDef.getColumnNameBuilder();
        Iterator<ColumnIdentifier> idIter = this.cfDef.columns.keySet().iterator();
        for (Restriction r : this.columnRestrictions) {
            ColumnIdentifier id = idIter.next();
            assert (r != null && r.isEquality());
            if (r.isINRestriction()) {
                if (r.eqValues.isEmpty()) {
                    return null;
                }
                TreeSet<ByteBuffer> columns = new TreeSet<ByteBuffer>(this.cfDef.cfm.comparator);
                Iterator<Term> iter = r.eqValues.iterator();
                while (iter.hasNext()) {
                    Term v = iter.next();
                    ColumnNameBuilder b = iter.hasNext() ? builder.copy() : builder;
                    ByteBuffer val = v.bindAndGet(variables);
                    if (val == null) {
                        throw new InvalidRequestException(String.format("Invalid null value for clustering key part %s", id));
                    }
                    b.add(val);
                    if (this.cfDef.isCompact) {
                        columns.add(b.build());
                        continue;
                    }
                    columns.addAll(this.addSelectedColumns(b));
                }
                return columns;
            }
            ByteBuffer val = r.eqValues.get(0).bindAndGet(variables);
            if (val == null) {
                throw new InvalidRequestException(String.format("Invalid null value for clustering key part %s", id));
            }
            builder.add(val);
        }
        return this.addSelectedColumns(builder);
    }

    private SortedSet<ByteBuffer> addSelectedColumns(ColumnNameBuilder builder) {
        if (this.cfDef.isCompact) {
            return FBUtilities.singleton(builder.build());
        }
        assert (!this.selectACollection());
        TreeSet<ByteBuffer> columns = new TreeSet<ByteBuffer>(this.cfDef.cfm.comparator);
        if (this.cfDef.isComposite && !this.cfDef.cfm.isSuper()) {
            columns.add(builder.copy().add(ByteBufferUtil.EMPTY_BYTE_BUFFER).build());
            for (ColumnIdentifier id : this.selection.regularColumnsToFetch()) {
                columns.add(builder.copy().add(id.key).build());
            }
        } else {
            Iterator<ColumnIdentifier> iter = this.cfDef.metadata.keySet().iterator();
            while (iter.hasNext()) {
                ColumnIdentifier name = iter.next();
                ColumnNameBuilder b = iter.hasNext() ? builder.copy() : builder;
                ByteBuffer cname = b.add(name.key).build();
                columns.add(cname);
            }
        }
        return columns;
    }

    private boolean selectACollection() {
        if (!this.cfDef.hasCollections) {
            return false;
        }
        for (CFDefinition.Name name : this.selection.getColumnsList()) {
            if (!(name.type instanceof CollectionType)) continue;
            return true;
        }
        return false;
    }

    private List<ByteBuffer> buildBound(Bound bound, Collection<CFDefinition.Name> names, Restriction[] restrictions, boolean isReversed, ColumnNameBuilder builder, List<ByteBuffer> variables) throws InvalidRequestException {
        Bound eocBound = isReversed ? Bound.reverse(bound) : bound;
        for (CFDefinition.Name name : names) {
            Bound b = isReversed == SelectStatement.isReversedType(name) ? bound : Bound.reverse(bound);
            Restriction r = restrictions[name.position];
            if (r == null || !r.isEquality() && r.bound(b) == null) {
                return Collections.singletonList(builder.componentCount() > 0 && eocBound == Bound.END ? builder.buildAsEndOfRange() : builder.build());
            }
            if (r.isEquality()) {
                if (r.isINRestriction()) {
                    assert (name.position == names.size() - 1);
                    TreeSet<ByteBuffer> s = new TreeSet<ByteBuffer>(isReversed ? this.cfDef.cfm.comparator.reverseComparator : this.cfDef.cfm.comparator);
                    for (Term t : r.eqValues) {
                        ByteBuffer val = t.bindAndGet(variables);
                        if (val == null) {
                            throw new InvalidRequestException(String.format("Invalid null clustering key part %s", name));
                        }
                        ColumnNameBuilder copy = builder.copy().add(val);
                        s.add(bound == Bound.END && copy.remainingCount() > 0 ? copy.buildAsEndOfRange() : copy.build());
                    }
                    return new ArrayList<ByteBuffer>(s);
                }
                ByteBuffer val = r.eqValues.get(0).bindAndGet(variables);
                if (val == null) {
                    throw new InvalidRequestException(String.format("Invalid null clustering key part %s", name));
                }
                builder.add(val);
                continue;
            }
            Term t = r.bound(b);
            assert (t != null);
            ByteBuffer val = t.bindAndGet(variables);
            if (val == null) {
                throw new InvalidRequestException(String.format("Invalid null clustering key part %s", name));
            }
            return Collections.singletonList(builder.add(val, r.getRelation(eocBound, b)).build());
        }
        return Collections.singletonList(bound == Bound.END && builder.remainingCount() > 0 ? builder.buildAsEndOfRange() : builder.build());
    }

    private List<ByteBuffer> getRequestedBound(Bound b, List<ByteBuffer> variables) throws InvalidRequestException {
        assert (this.isColumnRange());
        return this.buildBound(b, this.cfDef.columns.values(), this.columnRestrictions, this.isReversed, this.cfDef.getColumnNameBuilder(), variables);
    }

    private List<IndexExpression> getIndexExpressions(List<ByteBuffer> variables) throws InvalidRequestException {
        if (!this.usesSecondaryIndexing || this.restrictedNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IndexExpression> expressions = new ArrayList<IndexExpression>();
        for (CFDefinition.Name name : this.restrictedNames) {
            Restriction restriction;
            switch (name.kind) {
                case KEY_ALIAS: {
                    restriction = this.keyRestrictions[name.position];
                    break;
                }
                case COLUMN_ALIAS: {
                    restriction = this.columnRestrictions[name.position];
                    break;
                }
                case COLUMN_METADATA: {
                    restriction = this.metadataRestrictions.get(name);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (restriction.isEquality()) {
                assert (restriction.eqValues.size() == 1);
                ByteBuffer value = restriction.eqValues.get(0).bindAndGet(variables);
                if (value == null) {
                    throw new InvalidRequestException(String.format("Unsupported null value for indexed column %s", name));
                }
                if (value.remaining() > 65535) {
                    throw new InvalidRequestException("Index expression values may not be larger than 64K");
                }
                expressions.add(new IndexExpression(name.name.key, IndexOperator.EQ, value));
                continue;
            }
            for (Bound b : Bound.values()) {
                if (restriction.bound(b) == null) continue;
                ByteBuffer value = restriction.bound(b).bindAndGet(variables);
                if (value == null) {
                    throw new InvalidRequestException(String.format("Unsupported null value for indexed column %s", name));
                }
                if (value.remaining() > 65535) {
                    throw new InvalidRequestException("Index expression values may not be larger than 64K");
                }
                expressions.add(new IndexExpression(name.name.key, restriction.getIndexOperator(b), value));
            }
        }
        return expressions;
    }

    private Iterable<Column> columnsInOrder(final ColumnFamily cf, List<ByteBuffer> variables) throws InvalidRequestException {
        if (this.columnRestrictions.length == 0) {
            return cf.getSortedColumns();
        }
        Restriction last = this.columnRestrictions[this.columnRestrictions.length - 1];
        if (last == null || !last.isEquality()) {
            return cf.getSortedColumns();
        }
        ColumnNameBuilder builder = this.cfDef.getColumnNameBuilder();
        for (int i = 0; i < this.columnRestrictions.length - 1; ++i) {
            builder.add(this.columnRestrictions[i].eqValues.get(0).bindAndGet(variables));
        }
        final ArrayList<ByteBuffer> requested = new ArrayList<ByteBuffer>(last.eqValues.size());
        Iterator<Term> iter = last.eqValues.iterator();
        while (iter.hasNext()) {
            Term t = iter.next();
            ColumnNameBuilder b = iter.hasNext() ? builder.copy() : builder;
            requested.add(b.add(t.bindAndGet(variables)).build());
        }
        return new Iterable<Column>(){

            @Override
            public Iterator<Column> iterator() {
                return new AbstractIterator<Column>(){
                    Iterator<ByteBuffer> iter;
                    {
                        this.iter = requested.iterator();
                    }

                    public Column computeNext() {
                        if (!this.iter.hasNext()) {
                            return (Column)this.endOfData();
                        }
                        Column column = cf.getColumn(this.iter.next());
                        return column == null ? this.computeNext() : column;
                    }
                };
            }
        };
    }

    private ResultSet process(List<Row> rows, List<ByteBuffer> variables, int limit, long now) throws InvalidRequestException {
        Selection.ResultSetBuilder result = this.selection.resultSetBuilder(now);
        for (Row row : rows) {
            if (row.cf == null) continue;
            this.processColumnFamily(row.key.key, row.cf, variables, limit, now, result);
        }
        ResultSet cqlRows = result.build();
        this.orderResults(cqlRows);
        if (this.isReversed) {
            cqlRows.reverse();
        }
        cqlRows.trim(limit);
        return cqlRows;
    }

    void processColumnFamily(ByteBuffer key, ColumnFamily cf, List<ByteBuffer> variables, int limit, long now, Selection.ResultSetBuilder result) throws InvalidRequestException {
        ByteBuffer[] byteBufferArray;
        if (this.cfDef.hasCompositeKey) {
            byteBufferArray = ((CompositeType)this.cfDef.cfm.getKeyValidator()).split(key);
        } else {
            ByteBuffer[] byteBufferArray2 = new ByteBuffer[1];
            byteBufferArray = byteBufferArray2;
            byteBufferArray2[0] = key;
        }
        ByteBuffer[] keyComponents = byteBufferArray;
        if (this.cfDef.isCompact) {
            for (Column c : this.columnsInOrder(cf, variables)) {
                if (c.isMarkedForDelete(now)) continue;
                ByteBuffer[] components = null;
                if (this.cfDef.isComposite) {
                    components = ((CompositeType)this.cfDef.cfm.comparator).split(c.name());
                } else if (this.sliceRestriction != null && (!this.sliceRestriction.isInclusive(Bound.START) && c.name().equals(this.sliceRestriction.bound(Bound.START).bindAndGet(variables)) || !this.sliceRestriction.isInclusive(Bound.END) && c.name().equals(this.sliceRestriction.bound(Bound.END).bindAndGet(variables)))) continue;
                result.newRow();
                block7: for (CFDefinition.Name name : this.selection.getColumnsList()) {
                    switch (name.kind) {
                        case KEY_ALIAS: {
                            result.add(keyComponents[name.position]);
                            continue block7;
                        }
                        case COLUMN_ALIAS: {
                            ByteBuffer val = this.cfDef.isComposite ? (name.position < components.length ? components[name.position] : null) : c.name();
                            result.add(val);
                            continue block7;
                        }
                        case VALUE_ALIAS: {
                            result.add(c);
                            continue block7;
                        }
                        case COLUMN_METADATA: {
                            throw new AssertionError();
                        }
                    }
                    throw new AssertionError();
                }
            }
        } else if (this.cfDef.isComposite) {
            CompositeType composite = (CompositeType)this.cfDef.cfm.comparator;
            ColumnGroupMap.Builder builder = new ColumnGroupMap.Builder(composite, this.cfDef.hasCollections, now);
            for (Column c : cf) {
                if (c.isMarkedForDelete(now)) continue;
                builder.add(c);
            }
            for (ColumnGroupMap group : builder.groups()) {
                this.handleGroup(this.selection, result, keyComponents, group);
            }
        } else {
            if (cf.hasOnlyTombstones(now)) {
                return;
            }
            result.newRow();
            for (CFDefinition.Name name : this.selection.getColumnsList()) {
                if (name.kind == CFDefinition.Name.Kind.KEY_ALIAS) {
                    result.add(keyComponents[name.position]);
                    continue;
                }
                result.add(cf.getColumn(name.name.key));
            }
        }
    }

    private void orderResults(ResultSet cqlRows) {
        if (cqlRows.size() == 0 || this.parameters.orderings.isEmpty() || this.isKeyRange || !this.keyIsInRelation) {
            return;
        }
        assert (this.orderingIndexes != null);
        if (this.parameters.orderings.size() == 1) {
            CFDefinition.Name ordering = this.cfDef.get((ColumnIdentifier)this.parameters.orderings.keySet().iterator().next());
            Collections.sort(cqlRows.rows, new SingleColumnComparator(this.orderingIndexes.get(ordering), ordering.type));
            return;
        }
        ArrayList<AbstractType> types = new ArrayList<AbstractType>(this.parameters.orderings.size());
        int[] positions = new int[this.parameters.orderings.size()];
        int idx = 0;
        for (ColumnIdentifier identifier : this.parameters.orderings.keySet()) {
            CFDefinition.Name orderingColumn = this.cfDef.get(identifier);
            types.add(orderingColumn.type);
            positions[idx++] = this.orderingIndexes.get(orderingColumn);
        }
        Collections.sort(cqlRows.rows, new CompositeComparator(types, positions));
    }

    private void handleGroup(Selection selection, Selection.ResultSetBuilder result, ByteBuffer[] keyComponents, ColumnGroupMap columns) throws InvalidRequestException {
        result.newRow();
        for (CFDefinition.Name name : selection.getColumnsList()) {
            switch (name.kind) {
                case KEY_ALIAS: {
                    result.add(keyComponents[name.position]);
                    break;
                }
                case COLUMN_ALIAS: {
                    result.add(columns.getKeyComponent(name.position));
                    break;
                }
                case VALUE_ALIAS: {
                    throw new AssertionError();
                }
                case COLUMN_METADATA: {
                    if (name.type.isCollection()) {
                        List<Pair<ByteBuffer, Column>> collection = columns.getCollection(name.name.key);
                        ByteBuffer value = collection == null ? null : ((CollectionType)name.type).serialize(collection);
                        result.add(value);
                        break;
                    }
                    result.add(columns.getSimple(name.name.key));
                }
            }
        }
    }

    private static boolean isReversedType(CFDefinition.Name name) {
        return name.type instanceof ReversedType;
    }

    private boolean columnFilterIsIdentity() {
        for (Restriction r : this.columnRestrictions) {
            if (r == null) continue;
            return false;
        }
        return true;
    }

    private static class CompositeComparator
    implements Comparator<List<ByteBuffer>> {
        private final List<AbstractType<?>> orderTypes;
        private final int[] positions;

        private CompositeComparator(List<AbstractType<?>> orderTypes, int[] positions) {
            this.orderTypes = orderTypes;
            this.positions = positions;
        }

        @Override
        public int compare(List<ByteBuffer> a, List<ByteBuffer> b) {
            for (int i = 0; i < this.positions.length; ++i) {
                ByteBuffer bValue;
                int columnPos;
                ByteBuffer aValue;
                AbstractType<?> type = this.orderTypes.get(i);
                int comparison = type.compare(aValue = a.get(columnPos = this.positions[i]), bValue = b.get(columnPos));
                if (comparison == 0) continue;
                return comparison;
            }
            return 0;
        }
    }

    private static class SingleColumnComparator
    implements Comparator<List<ByteBuffer>> {
        private final int index;
        private final AbstractType<?> comparator;

        public SingleColumnComparator(int columnIndex, AbstractType<?> orderer) {
            this.index = columnIndex;
            this.comparator = orderer;
        }

        @Override
        public int compare(List<ByteBuffer> a, List<ByteBuffer> b) {
            return this.comparator.compare(a.get(this.index), b.get(this.index));
        }
    }

    public static class Parameters {
        private final Map<ColumnIdentifier, Boolean> orderings;
        private final boolean isCount;
        private final ColumnIdentifier countAlias;
        private final boolean allowFiltering;

        public Parameters(Map<ColumnIdentifier, Boolean> orderings, boolean isCount, ColumnIdentifier countAlias, boolean allowFiltering) {
            this.orderings = orderings;
            this.isCount = isCount;
            this.countAlias = countAlias;
            this.allowFiltering = allowFiltering;
        }
    }

    private static class Restriction {
        List<Term> eqValues;
        private final Term[] bounds;
        private final boolean[] boundInclusive;
        final boolean onToken;

        Restriction(List<Term> values, boolean onToken) {
            this.eqValues = values;
            this.bounds = null;
            this.boundInclusive = null;
            this.onToken = onToken;
        }

        Restriction(List<Term> values) {
            this(values, false);
        }

        Restriction(Term value, boolean onToken) {
            this(Collections.singletonList(value), onToken);
        }

        Restriction(boolean onToken) {
            this.eqValues = null;
            this.bounds = new Term[2];
            this.boundInclusive = new boolean[2];
            this.onToken = onToken;
        }

        boolean isEquality() {
            return this.eqValues != null;
        }

        boolean isINRestriction() {
            return this.isEquality() && (this.eqValues.isEmpty() || this.eqValues.size() > 1);
        }

        public Term bound(Bound b) {
            return this.bounds[b.idx];
        }

        public boolean isInclusive(Bound b) {
            return this.bounds[b.idx] == null || this.boundInclusive[b.idx];
        }

        public Relation.Type getRelation(Bound eocBound, Bound inclusiveBound) {
            switch (eocBound) {
                case START: {
                    return this.boundInclusive[inclusiveBound.idx] ? Relation.Type.GTE : Relation.Type.GT;
                }
                case END: {
                    return this.boundInclusive[inclusiveBound.idx] ? Relation.Type.LTE : Relation.Type.LT;
                }
            }
            throw new AssertionError();
        }

        public IndexOperator getIndexOperator(Bound b) {
            switch (b) {
                case START: {
                    return this.boundInclusive[b.idx] ? IndexOperator.GTE : IndexOperator.GT;
                }
                case END: {
                    return this.boundInclusive[b.idx] ? IndexOperator.LTE : IndexOperator.LT;
                }
            }
            throw new AssertionError();
        }

        public void setBound(ColumnIdentifier name, Relation.Type type, Term t) throws InvalidRequestException {
            boolean inclusive;
            Bound b;
            switch (type) {
                case GT: {
                    b = Bound.START;
                    inclusive = false;
                    break;
                }
                case GTE: {
                    b = Bound.START;
                    inclusive = true;
                    break;
                }
                case LT: {
                    b = Bound.END;
                    inclusive = false;
                    break;
                }
                case LTE: {
                    b = Bound.END;
                    inclusive = true;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (this.bounds == null) {
                throw new InvalidRequestException(String.format("%s cannot be restricted by both an equal and an inequal relation", name));
            }
            if (this.bounds[b.idx] != null) {
                throw new InvalidRequestException(String.format("Invalid restrictions found on %s", name));
            }
            this.bounds[b.idx] = t;
            this.boundInclusive[b.idx] = inclusive;
        }

        public String toString() {
            String s = this.eqValues == null ? String.format("SLICE(%s %s, %s %s)", this.boundInclusive[0] ? ">=" : ">", this.bounds[0], this.boundInclusive[1] ? "<=" : "<", this.bounds[1]) : String.format("EQ(%s)", this.eqValues);
            return this.onToken ? s + "*" : s;
        }
    }

    public static class RawStatement
    extends CFStatement {
        private final Parameters parameters;
        private final List<RawSelector> selectClause;
        private final List<Relation> whereClause;
        private final Term.Raw limit;

        public RawStatement(CFName cfName, Parameters parameters, List<RawSelector> selectClause, List<Relation> whereClause, Term.Raw limit) {
            super(cfName);
            this.parameters = parameters;
            this.selectClause = selectClause;
            this.whereClause = whereClause == null ? Collections.emptyList() : whereClause;
            this.limit = limit;
        }

        @Override
        public ParsedStatement.Prepared prepare() throws InvalidRequestException {
            Restriction restriction;
            CFDefinition.Name cname;
            int i;
            CFMetaData cfm = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
            CFDefinition cfDef = cfm.getCfDef();
            ColumnSpecification[] names = new ColumnSpecification[this.getBoundsTerms()];
            if (this.parameters.isCount && !this.selectClause.isEmpty()) {
                throw new InvalidRequestException("Only COUNT(*) and COUNT(1) operations are currently supported.");
            }
            Selection selection = this.selectClause.isEmpty() ? Selection.wildcard(cfDef) : Selection.fromSelectors(cfDef, this.selectClause);
            Term prepLimit = null;
            if (this.limit != null) {
                prepLimit = this.limit.prepare(this.limitReceiver());
                prepLimit.collectMarkerSpecification(names);
            }
            SelectStatement stmt = new SelectStatement(cfDef, this.getBoundsTerms(), this.parameters, selection, prepLimit);
            boolean hasQueriableIndex = false;
            boolean hasQueriableClusteringColumnIndex = false;
            for (Relation rel : this.whereClause) {
                CFDefinition.Name name = cfDef.get(rel.getEntity());
                if (name == null) {
                    if (this.containsAlias(rel.getEntity())) {
                        throw new InvalidRequestException(String.format("Aliases aren't allowed in where clause ('%s')", rel));
                    }
                    throw new InvalidRequestException(String.format("Undefined name %s in where clause ('%s')", rel.getEntity(), rel));
                }
                ColumnDefinition def = cfDef.cfm.getColumnDefinition(name.name.key);
                stmt.restrictedNames.add(name);
                if (def.isIndexed() && rel.operator() == Relation.Type.EQ) {
                    hasQueriableIndex = true;
                    if (name.kind == CFDefinition.Name.Kind.COLUMN_ALIAS) {
                        hasQueriableClusteringColumnIndex = true;
                    }
                }
                switch (name.kind) {
                    case KEY_ALIAS: {
                        ((SelectStatement)stmt).keyRestrictions[name.position] = this.updateRestriction(name, stmt.keyRestrictions[name.position], rel, names);
                        break;
                    }
                    case COLUMN_ALIAS: {
                        ((SelectStatement)stmt).columnRestrictions[name.position] = this.updateRestriction(name, stmt.columnRestrictions[name.position], rel, names);
                        break;
                    }
                    case VALUE_ALIAS: {
                        throw new InvalidRequestException(String.format("Predicates on the non-primary-key column (%s) of a COMPACT table are not yet supported", name.name));
                    }
                    case COLUMN_METADATA: {
                        stmt.metadataRestrictions.put(name, this.updateRestriction(name, (Restriction)stmt.metadataRestrictions.get(name), rel, names));
                    }
                }
            }
            boolean canRestrictFurtherComponents = true;
            CFDefinition.Name previous = null;
            stmt.keyIsInRelation = false;
            Iterator<CFDefinition.Name> iter = cfDef.keys.values().iterator();
            for (i = 0; i < stmt.keyRestrictions.length; ++i) {
                cname = iter.next();
                restriction = stmt.keyRestrictions[i];
                if (restriction == null) {
                    if (stmt.onToken) {
                        throw new InvalidRequestException("The token() function must be applied to all partition key components or none of them");
                    }
                    if (i > 0 && stmt.keyRestrictions[i - 1] != null) {
                        if (hasQueriableIndex) {
                            stmt.usesSecondaryIndexing = true;
                            stmt.isKeyRange = true;
                            break;
                        }
                        throw new InvalidRequestException(String.format("Partition key part %s must be restricted since preceding part is", cname));
                    }
                    stmt.isKeyRange = true;
                    canRestrictFurtherComponents = false;
                } else {
                    if (!canRestrictFurtherComponents) {
                        if (hasQueriableIndex) {
                            stmt.usesSecondaryIndexing = true;
                            break;
                        }
                        throw new InvalidRequestException(String.format("partition key part %s cannot be restricted (preceding part %s is either not restricted or by a non-EQ relation)", cname, previous));
                    }
                    if (restriction.onToken) {
                        stmt.isKeyRange = true;
                        stmt.onToken = true;
                    } else {
                        if (stmt.onToken) {
                            throw new InvalidRequestException(String.format("The token() function must be applied to all partition key components or none of them", new Object[0]));
                        }
                        if (restriction.isEquality()) {
                            if (restriction.isINRestriction()) {
                                if (i != stmt.keyRestrictions.length - 1) {
                                    throw new InvalidRequestException(String.format("Partition KEY part %s cannot be restricted by IN relation (only the last part of the partition key can)", cname));
                                }
                                stmt.keyIsInRelation = true;
                            }
                        } else {
                            throw new InvalidRequestException("Only EQ and IN relation are supported on the partition key (unless you use the token() function)");
                        }
                    }
                }
                previous = cname;
            }
            if (!stmt.usesSecondaryIndexing) {
                stmt.restrictedNames.removeAll(cfDef.keys.values());
            }
            canRestrictFurtherComponents = true;
            previous = null;
            iter = cfDef.columns.values().iterator();
            for (i = 0; i < stmt.columnRestrictions.length; ++i) {
                cname = iter.next();
                restriction = stmt.columnRestrictions[i];
                if (restriction == null) {
                    canRestrictFurtherComponents = false;
                } else {
                    if (!canRestrictFurtherComponents) {
                        if (hasQueriableIndex) {
                            stmt.usesSecondaryIndexing = true;
                            break;
                        }
                        throw new InvalidRequestException(String.format("PRIMARY KEY part %s cannot be restricted (preceding part %s is either not restricted or by a non-EQ relation)", cname, previous));
                    }
                    if (!restriction.isEquality()) {
                        canRestrictFurtherComponents = false;
                        if (!(cfDef.isComposite || restriction.isInclusive(Bound.START) && restriction.isInclusive(Bound.END))) {
                            stmt.sliceRestriction = restriction;
                        }
                    } else if (restriction.isINRestriction()) {
                        if (i != stmt.columnRestrictions.length - 1) {
                            throw new InvalidRequestException(String.format("PRIMARY KEY part %s cannot be restricted by IN relation", cname));
                        }
                        if (stmt.selectACollection()) {
                            throw new InvalidRequestException(String.format("Cannot restrict PRIMARY KEY part %s by IN relation as a collection is selected by the query", cname));
                        }
                    }
                }
                previous = cname;
            }
            if (stmt.isKeyRange && hasQueriableClusteringColumnIndex) {
                stmt.usesSecondaryIndexing = true;
            }
            if (!stmt.usesSecondaryIndexing) {
                stmt.restrictedNames.removeAll(cfDef.columns.values());
            }
            if (!stmt.metadataRestrictions.isEmpty()) {
                if (!hasQueriableIndex) {
                    throw new InvalidRequestException("No indexed columns present in by-columns clause with Equal operator");
                }
                stmt.usesSecondaryIndexing = true;
            }
            if (stmt.usesSecondaryIndexing && stmt.keyIsInRelation) {
                throw new InvalidRequestException("Select on indexed columns and with IN clause for the PRIMARY KEY are not supported");
            }
            if (!stmt.parameters.orderings.isEmpty()) {
                if (stmt.usesSecondaryIndexing) {
                    throw new InvalidRequestException("ORDER BY with 2ndary indexes is not supported.");
                }
                if (stmt.isKeyRange) {
                    throw new InvalidRequestException("ORDER BY is only supported when the partition key is restricted by an EQ or an IN.");
                }
                if (stmt.keyIsInRelation) {
                    stmt.orderingIndexes = new HashMap();
                    for (ColumnIdentifier column : stmt.parameters.orderings.keySet()) {
                        final CFDefinition.Name name = cfDef.get(column);
                        if (name == null) {
                            if (this.containsAlias(column)) {
                                throw new InvalidRequestException(String.format("Aliases are not allowed in order by clause ('%s')", column));
                            }
                            throw new InvalidRequestException(String.format("Order by on unknown column %s", column));
                        }
                        if (this.selectClause.isEmpty()) {
                            stmt.orderingIndexes.put(name, Iterables.indexOf((Iterable)cfDef, (Predicate)new Predicate<CFDefinition.Name>(){

                                public boolean apply(CFDefinition.Name n) {
                                    return name.equals(n);
                                }
                            }));
                            continue;
                        }
                        boolean hasColumn = false;
                        for (int i2 = 0; i2 < this.selectClause.size(); ++i2) {
                            RawSelector selector = this.selectClause.get(i2);
                            if (!name.name.equals(selector.selectable)) continue;
                            stmt.orderingIndexes.put(name, i2);
                            hasColumn = true;
                            break;
                        }
                        if (hasColumn) continue;
                        throw new InvalidRequestException("ORDER BY could not be used on columns missing in select clause.");
                    }
                }
                Boolean[] reversedMap = new Boolean[cfDef.columns.size()];
                int i3 = 0;
                for (Map.Entry entry : stmt.parameters.orderings.entrySet()) {
                    ColumnIdentifier column = (ColumnIdentifier)entry.getKey();
                    boolean reversed = (Boolean)entry.getValue();
                    CFDefinition.Name name = cfDef.get(column);
                    if (name == null) {
                        if (this.containsAlias(column)) {
                            throw new InvalidRequestException(String.format("Aliases are not allowed in order by clause ('%s')", column));
                        }
                        throw new InvalidRequestException(String.format("Order by on unknown column %s", column));
                    }
                    if (name.kind != CFDefinition.Name.Kind.COLUMN_ALIAS) {
                        throw new InvalidRequestException(String.format("Order by is currently only supported on the clustered columns of the PRIMARY KEY, got %s", column));
                    }
                    if (i3++ != name.position) {
                        throw new InvalidRequestException(String.format("Order by currently only support the ordering of columns following their declared order in the PRIMARY KEY", new Object[0]));
                    }
                    reversedMap[name.position] = reversed != SelectStatement.isReversedType(name);
                }
                Boolean isReversed = null;
                for (Boolean b : reversedMap) {
                    if (b == null) continue;
                    if (isReversed == null) {
                        isReversed = b;
                        continue;
                    }
                    if (isReversed == b) continue;
                    throw new InvalidRequestException(String.format("Unsupported order by relation", new Object[0]));
                }
                assert (isReversed != null);
                stmt.isReversed = isReversed;
            }
            if (!this.parameters.allowFiltering && (stmt.isKeyRange || stmt.usesSecondaryIndexing) && (stmt.restrictedNames.size() > 1 || stmt.restrictedNames.isEmpty() && !stmt.columnFilterIsIdentity())) {
                throw new InvalidRequestException("Cannot execute this query as it might involve data filtering and thus may have unpredictable performance. If you want to execute this query despite the performance unpredictability, use ALLOW FILTERING");
            }
            return new ParsedStatement.Prepared(stmt, Arrays.asList(names));
        }

        private boolean containsAlias(final ColumnIdentifier name) {
            return Iterables.any(this.selectClause, (Predicate)new Predicate<RawSelector>(){

                public boolean apply(RawSelector raw) {
                    return name.equals(raw.alias);
                }
            });
        }

        private ColumnSpecification limitReceiver() {
            return new ColumnSpecification(this.keyspace(), this.columnFamily(), new ColumnIdentifier("[limit]", true), Int32Type.instance);
        }

        Restriction updateRestriction(CFDefinition.Name name, Restriction restriction, Relation newRel, ColumnSpecification[] boundNames) throws InvalidRequestException {
            ColumnSpecification receiver = name;
            if (newRel.onToken) {
                if (name.kind != CFDefinition.Name.Kind.KEY_ALIAS) {
                    throw new InvalidRequestException(String.format("The token() function is only supported on the partition key, found on %s", name));
                }
                receiver = new ColumnSpecification(name.ksName, name.cfName, new ColumnIdentifier("partition key token", true), StorageService.getPartitioner().getTokenValidator());
            }
            switch (newRel.operator()) {
                case EQ: {
                    if (restriction != null) {
                        throw new InvalidRequestException(String.format("%s cannot be restricted by more than one relation if it includes an Equal", name));
                    }
                    Term t = newRel.getValue().prepare(receiver);
                    t.collectMarkerSpecification(boundNames);
                    restriction = new Restriction(t, newRel.onToken);
                    break;
                }
                case IN: {
                    if (restriction != null) {
                        throw new InvalidRequestException(String.format("%s cannot be restricted by more than one relation if it includes a IN", name));
                    }
                    ArrayList<Term> inValues = new ArrayList<Term>(newRel.getInValues().size());
                    for (Term.Raw raw : newRel.getInValues()) {
                        Term t = raw.prepare(receiver);
                        t.collectMarkerSpecification(boundNames);
                        inValues.add(t);
                    }
                    restriction = new Restriction(inValues);
                    break;
                }
                case GT: 
                case GTE: 
                case LT: 
                case LTE: {
                    if (restriction == null) {
                        restriction = new Restriction(newRel.onToken);
                    }
                    Term t = newRel.getValue().prepare(receiver);
                    t.collectMarkerSpecification(boundNames);
                    restriction.setBound(name.name, newRel.operator(), t);
                }
            }
            return restriction;
        }

        public String toString() {
            return String.format("SelectRawStatement[name=%s, selectClause=%s, whereClause=%s, isCount=%s]", this.cfName, this.selectClause, this.whereClause, this.parameters.isCount);
        }
    }

    private static enum Bound {
        START(0),
        END(1);

        public final int idx;

        private Bound(int idx) {
            this.idx = idx;
        }

        public static Bound reverse(Bound b) {
            return b == START ? END : START;
        }
    }
}

