/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.EnumMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.cassandra.auth.IAuthenticator;
import org.apache.cassandra.auth.ISaslAwareAuthenticator;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.security.SSLFactory;
import org.apache.cassandra.service.CassandraDaemon;
import org.apache.cassandra.service.IEndpointLifecycleSubscriber;
import org.apache.cassandra.service.IMigrationListener;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.transport.Connection;
import org.apache.cassandra.transport.Event;
import org.apache.cassandra.transport.Frame;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.RequestThreadPoolExecutor;
import org.apache.cassandra.transport.ServerConnection;
import org.apache.cassandra.transport.messages.EventMessage;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.logging.Slf4JLoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server
implements CassandraDaemon.Server {
    private static final Logger logger;
    public static final int CURRENT_VERSION = 2;
    private final ConnectionTracker connectionTracker = new ConnectionTracker();
    private final Connection.Factory connectionFactory = new Connection.Factory(){

        @Override
        public Connection newConnection(Channel channel, int version) {
            return new ServerConnection(channel, version, Server.this.connectionTracker);
        }
    };
    public final InetSocketAddress socket;
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private ChannelFactory factory;
    private ExecutionHandler executionHandler;

    public Server(InetSocketAddress socket) {
        this.socket = socket;
        EventNotifier notifier = new EventNotifier(this);
        StorageService.instance.register(notifier);
        MigrationManager.instance.register(notifier);
    }

    public Server(String hostname, int port) {
        this(new InetSocketAddress(hostname, port));
    }

    public Server(InetAddress host, int port) {
        this(new InetSocketAddress(host, port));
    }

    public Server(int port) {
        this(new InetSocketAddress(port));
    }

    @Override
    public void start() {
        if (!this.isRunning()) {
            this.run();
            this.isRunning.set(true);
        }
    }

    @Override
    public void stop() {
        if (this.isRunning.compareAndSet(true, false)) {
            this.close();
        }
    }

    @Override
    public boolean isRunning() {
        return this.isRunning.get();
    }

    private void run() {
        IAuthenticator authenticator = DatabaseDescriptor.getAuthenticator();
        if (authenticator.requireAuthentication() && !(authenticator instanceof ISaslAwareAuthenticator)) {
            logger.error("Not starting native transport as the configured IAuthenticator is not capable of SASL authentication");
            this.isRunning.compareAndSet(true, false);
            return;
        }
        this.executionHandler = new ExecutionHandler((Executor)new RequestThreadPoolExecutor());
        this.factory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
        ServerBootstrap bootstrap = new ServerBootstrap(this.factory);
        bootstrap.setOption("child.tcpNoDelay", (Object)true);
        EncryptionOptions.ClientEncryptionOptions clientEnc = DatabaseDescriptor.getClientEncryptionOptions();
        if (clientEnc.enabled) {
            logger.info("Enabling encrypted CQL connections between client and server");
            bootstrap.setPipelineFactory((ChannelPipelineFactory)new SecurePipelineFactory(this, clientEnc));
        } else {
            bootstrap.setPipelineFactory((ChannelPipelineFactory)new PipelineFactory(this));
        }
        logger.info("Starting listening for CQL clients on {}...", (Object)this.socket);
        Channel channel = bootstrap.bind((SocketAddress)this.socket);
        this.connectionTracker.allChannels.add((Object)channel);
    }

    private void close() {
        this.connectionTracker.closeAll();
        this.factory.releaseExternalResources();
        this.factory = null;
        this.executionHandler.releaseExternalResources();
        this.executionHandler = null;
        logger.info("Stop listening for CQL clients");
    }

    static {
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new Slf4JLoggerFactory());
        logger = LoggerFactory.getLogger(Server.class);
    }

    private static class EventNotifier
    implements IEndpointLifecycleSubscriber,
    IMigrationListener {
        private final Server server;
        private static final InetAddress bindAll;

        private EventNotifier(Server server) {
            this.server = server;
        }

        private InetAddress getRpcAddress(InetAddress endpoint) {
            try {
                InetAddress rpcAddress = InetAddress.getByName(StorageService.instance.getRpcaddress(endpoint));
                return rpcAddress.equals(bindAll) ? endpoint : rpcAddress;
            }
            catch (UnknownHostException e) {
                logger.error("Problem retrieving RPC address for {}", (Object)endpoint, (Object)e);
                return endpoint;
            }
        }

        @Override
        public void onJoinCluster(InetAddress endpoint) {
            this.server.connectionTracker.send(Event.TopologyChange.newNode(this.getRpcAddress(endpoint), this.server.socket.getPort()));
        }

        @Override
        public void onLeaveCluster(InetAddress endpoint) {
            this.server.connectionTracker.send(Event.TopologyChange.removedNode(this.getRpcAddress(endpoint), this.server.socket.getPort()));
        }

        @Override
        public void onMove(InetAddress endpoint) {
            this.server.connectionTracker.send(Event.TopologyChange.movedNode(this.getRpcAddress(endpoint), this.server.socket.getPort()));
        }

        @Override
        public void onUp(InetAddress endpoint) {
            this.server.connectionTracker.send(Event.StatusChange.nodeUp(this.getRpcAddress(endpoint), this.server.socket.getPort()));
        }

        @Override
        public void onDown(InetAddress endpoint) {
            this.server.connectionTracker.send(Event.StatusChange.nodeDown(this.getRpcAddress(endpoint), this.server.socket.getPort()));
        }

        @Override
        public void onCreateKeyspace(String ksName) {
            this.server.connectionTracker.send(new Event.SchemaChange(Event.SchemaChange.Change.CREATED, ksName));
        }

        @Override
        public void onCreateColumnFamily(String ksName, String cfName) {
            this.server.connectionTracker.send(new Event.SchemaChange(Event.SchemaChange.Change.CREATED, ksName, cfName));
        }

        @Override
        public void onUpdateKeyspace(String ksName) {
            this.server.connectionTracker.send(new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, ksName));
        }

        @Override
        public void onUpdateColumnFamily(String ksName, String cfName) {
            this.server.connectionTracker.send(new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, ksName, cfName));
        }

        @Override
        public void onDropKeyspace(String ksName) {
            this.server.connectionTracker.send(new Event.SchemaChange(Event.SchemaChange.Change.DROPPED, ksName));
        }

        @Override
        public void onDropColumnFamily(String ksName, String cfName) {
            this.server.connectionTracker.send(new Event.SchemaChange(Event.SchemaChange.Change.DROPPED, ksName, cfName));
        }

        static {
            try {
                bindAll = InetAddress.getByAddress(new byte[4]);
            }
            catch (UnknownHostException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private static class SecurePipelineFactory
    extends PipelineFactory {
        private final SSLContext sslContext;
        private final EncryptionOptions encryptionOptions;

        public SecurePipelineFactory(Server server, EncryptionOptions encryptionOptions) {
            super(server);
            this.encryptionOptions = encryptionOptions;
            try {
                this.sslContext = SSLFactory.createSSLContext(encryptionOptions, false);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to setup secure pipeline", e);
            }
        }

        @Override
        public ChannelPipeline getPipeline() throws Exception {
            SSLEngine sslEngine = this.sslContext.createSSLEngine();
            sslEngine.setUseClientMode(false);
            sslEngine.setEnabledCipherSuites(this.encryptionOptions.cipher_suites);
            sslEngine.setNeedClientAuth(this.encryptionOptions.require_client_auth);
            SslHandler sslHandler = new SslHandler(sslEngine);
            sslHandler.setIssueHandshake(true);
            ChannelPipeline pipeline = super.getPipeline();
            pipeline.addFirst("ssl", (ChannelHandler)sslHandler);
            return pipeline;
        }
    }

    private static class PipelineFactory
    implements ChannelPipelineFactory {
        private static final Message.ProtocolDecoder messageDecoder = new Message.ProtocolDecoder();
        private static final Message.ProtocolEncoder messageEncoder = new Message.ProtocolEncoder();
        private static final Frame.Decompressor frameDecompressor = new Frame.Decompressor();
        private static final Frame.Compressor frameCompressor = new Frame.Compressor();
        private static final Frame.Encoder frameEncoder = new Frame.Encoder();
        private static final Message.Dispatcher dispatcher = new Message.Dispatcher();
        private final Server server;

        public PipelineFactory(Server server) {
            this.server = server;
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = Channels.pipeline();
            pipeline.addLast("frameDecoder", (ChannelHandler)new Frame.Decoder(this.server.connectionFactory));
            pipeline.addLast("frameEncoder", (ChannelHandler)frameEncoder);
            pipeline.addLast("frameDecompressor", (ChannelHandler)frameDecompressor);
            pipeline.addLast("frameCompressor", (ChannelHandler)frameCompressor);
            pipeline.addLast("messageDecoder", (ChannelHandler)messageDecoder);
            pipeline.addLast("messageEncoder", (ChannelHandler)messageEncoder);
            pipeline.addLast("executor", (ChannelHandler)this.server.executionHandler);
            pipeline.addLast("dispatcher", (ChannelHandler)dispatcher);
            return pipeline;
        }
    }

    public static class ConnectionTracker
    implements Connection.Tracker {
        public final ChannelGroup allChannels = new DefaultChannelGroup();
        private final EnumMap<Event.Type, ChannelGroup> groups = new EnumMap(Event.Type.class);

        public ConnectionTracker() {
            for (Event.Type type : Event.Type.values()) {
                this.groups.put(type, (ChannelGroup)new DefaultChannelGroup(type.toString()));
            }
        }

        @Override
        public void addConnection(Channel ch, Connection connection) {
            this.allChannels.add((Object)ch);
        }

        public void register(Event.Type type, Channel ch) {
            this.groups.get((Object)type).add((Object)ch);
        }

        public void unregister(Channel ch) {
            for (ChannelGroup group : this.groups.values()) {
                group.remove((Object)ch);
            }
        }

        public void send(Event event) {
            this.groups.get((Object)event.type).write((Object)new EventMessage(event));
        }

        @Override
        public void closeAll() {
            this.allChannels.close().awaitUninterruptibly();
        }
    }
}

