/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos;

import java.nio.ByteBuffer;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.service.paxos.PrepareResponse;
import org.apache.cassandra.tracing.Tracing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaxosState {
    private static final Logger logger = LoggerFactory.getLogger(PaxosState.class);
    private static final Object[] locks = new Object[1024];
    private final Commit inProgressCommit;
    private final Commit mostRecentCommit;

    private static Object lockFor(ByteBuffer key) {
        return locks[(Integer.MAX_VALUE & key.hashCode()) % locks.length];
    }

    public PaxosState(ByteBuffer key, CFMetaData metadata) {
        this(Commit.emptyCommit(key, metadata), Commit.emptyCommit(key, metadata));
    }

    public PaxosState(Commit inProgressCommit, Commit mostRecentCommit) {
        assert (inProgressCommit.key == mostRecentCommit.key);
        assert (inProgressCommit.update.metadata() == inProgressCommit.update.metadata());
        this.inProgressCommit = inProgressCommit;
        this.mostRecentCommit = mostRecentCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrepareResponse prepare(Commit toPrepare) {
        Object object = PaxosState.lockFor(toPrepare.key);
        synchronized (object) {
            PaxosState state = SystemKeyspace.loadPaxosState(toPrepare.key, toPrepare.update.metadata());
            if (toPrepare.isAfter(state.inProgressCommit)) {
                Tracing.trace("promising ballot {}", toPrepare.ballot);
                SystemKeyspace.savePaxosPromise(toPrepare);
                return new PrepareResponse(true, state.inProgressCommit, state.mostRecentCommit);
            }
            Tracing.trace("promise rejected; {} is not sufficiently newer than {}", toPrepare, state.inProgressCommit);
            return new PrepareResponse(false, state.inProgressCommit, state.mostRecentCommit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean propose(Commit proposal) {
        Object object = PaxosState.lockFor(proposal.key);
        synchronized (object) {
            PaxosState state = SystemKeyspace.loadPaxosState(proposal.key, proposal.update.metadata());
            if (proposal.hasBallot(state.inProgressCommit.ballot) || proposal.isAfter(state.inProgressCommit)) {
                Tracing.trace("accepting proposal {}", proposal);
                SystemKeyspace.savePaxosProposal(proposal);
                return true;
            }
            logger.debug("accept requested for {} but inProgress is now {}", (Object)proposal, (Object)state.inProgressCommit);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void commit(Commit proposal) {
        Tracing.trace("committing proposal {}", proposal);
        RowMutation rm = proposal.makeMutation();
        Keyspace.open(rm.getKeyspaceName()).apply(rm, true);
        Object object = PaxosState.lockFor(proposal.key);
        synchronized (object) {
            PaxosState state = SystemKeyspace.loadPaxosState(proposal.key, proposal.update.metadata());
            SystemKeyspace.savePaxosCommit(proposal, state.inProgressCommit.ballot);
        }
    }

    static {
        for (int i = 0; i < locks.length; ++i) {
            PaxosState.locks[i] = new Object();
        }
    }
}

