/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.db.AbstractRangeCommand;
import org.apache.cassandra.db.BatchlogManager;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.EmptyColumns;
import org.apache.cassandra.db.HintedHandOffManager;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.RangeSliceReply;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.ReadVerbHandler;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.SliceByNamesReadCommand;
import org.apache.cassandra.db.SliceFromReadCommand;
import org.apache.cassandra.db.Truncation;
import org.apache.cassandra.db.WriteType;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.IsBootstrappingException;
import org.apache.cassandra.exceptions.OverloadedException;
import org.apache.cassandra.exceptions.ReadTimeoutException;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.exceptions.WriteTimeoutException;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.metrics.ClientRequestMetrics;
import org.apache.cassandra.metrics.ReadRepairMetrics;
import org.apache.cassandra.net.CompactEndpointSerializationHelper;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.AbstractReadExecutor;
import org.apache.cassandra.service.AbstractWriteResponseHandler;
import org.apache.cassandra.service.DigestMismatchException;
import org.apache.cassandra.service.RangeSliceResponseResolver;
import org.apache.cassandra.service.ReadCallback;
import org.apache.cassandra.service.RowDataResolver;
import org.apache.cassandra.service.StorageProxyMBean;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.TruncateResponseHandler;
import org.apache.cassandra.service.WriteResponseHandler;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.service.paxos.PrepareCallback;
import org.apache.cassandra.service.paxos.ProposeCallback;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.triggers.TriggerExecutor;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageProxy
implements StorageProxyMBean {
    public static final String MBEAN_NAME = "org.apache.cassandra.db:type=StorageProxy";
    private static final Logger logger = LoggerFactory.getLogger(StorageProxy.class);
    static final boolean OPTIMIZE_LOCAL_REQUESTS = true;
    public static final String UNREACHABLE = "UNREACHABLE";
    private static final WritePerformer standardWritePerformer;
    private static final WritePerformer counterWritePerformer;
    private static final WritePerformer counterWriteOnCoordinatorPerformer;
    public static final StorageProxy instance;
    private static volatile boolean hintedHandoffEnabled;
    private static volatile int maxHintWindow;
    private static volatile int maxHintsInProgress;
    private static final AtomicInteger totalHintsInProgress;
    private static final Map<InetAddress, AtomicInteger> hintsInProgress;
    private static final AtomicLong totalHints;
    private static final ClientRequestMetrics readMetrics;
    private static final ClientRequestMetrics rangeMetrics;
    private static final ClientRequestMetrics writeMetrics;

    private StorageProxy() {
    }

    public static ColumnFamily cas(String keyspaceName, String cfName, ByteBuffer key, ColumnNameBuilder prefix, ColumnFamily expected, ColumnFamily updates, ConsistencyLevel consistencyForPaxos, ConsistencyLevel consistencyForCommit) throws UnavailableException, IsBootstrappingException, ReadTimeoutException, WriteTimeoutException, InvalidRequestException {
        consistencyForPaxos.validateForCas();
        consistencyForCommit.validateForCasCommit(keyspaceName);
        CFMetaData metadata = Schema.instance.getCFMetaData(keyspaceName, cfName);
        long start = System.nanoTime();
        long timeout = TimeUnit.MILLISECONDS.toNanos(DatabaseDescriptor.getCasContentionTimeout());
        while (System.nanoTime() - start < timeout) {
            ReadCommand readCommand;
            Pair<List<InetAddress>, Integer> p = StorageProxy.getPaxosParticipants(keyspaceName, key, consistencyForPaxos);
            List liveEndpoints = (List)p.left;
            int requiredParticipants = (Integer)p.right;
            UUID ballot = StorageProxy.beginAndRepairPaxos(start, key, metadata, liveEndpoints, requiredParticipants, consistencyForPaxos);
            Tracing.trace("Reading existing values for CAS precondition");
            long timestamp = System.currentTimeMillis();
            if (expected == null || expected.isEmpty()) {
                SliceQueryFilter filter = prefix == null ? new SliceQueryFilter(ByteBufferUtil.EMPTY_BYTE_BUFFER, ByteBufferUtil.EMPTY_BYTE_BUFFER, false, 1) : new SliceQueryFilter(prefix.build(), prefix.buildAsEndOfRange(), false, 1, prefix.componentCount());
                readCommand = new SliceFromReadCommand(keyspaceName, key, cfName, timestamp, filter);
            } else {
                assert (!expected.isEmpty());
                readCommand = new SliceByNamesReadCommand(keyspaceName, key, cfName, timestamp, new NamesQueryFilter((SortedSet<ByteBuffer>)ImmutableSortedSet.copyOf(metadata.comparator, expected.getColumnNames())));
            }
            List<Row> rows = StorageProxy.read(Arrays.asList(readCommand), ConsistencyLevel.QUORUM);
            ColumnFamily current = rows.get((int)0).cf;
            if (!StorageProxy.casApplies(expected, current)) {
                Tracing.trace("CAS precondition {} does not match current values {}", expected, current);
                return current == null ? EmptyColumns.factory.create(metadata) : current;
            }
            Commit proposal = Commit.newProposal(key, ballot, updates);
            Tracing.trace("CAS precondition is met; proposing client-requested updates for {}", ballot);
            if (StorageProxy.proposePaxos(proposal, liveEndpoints, requiredParticipants)) {
                if (consistencyForCommit == ConsistencyLevel.ANY) {
                    StorageProxy.sendCommit(proposal, liveEndpoints);
                } else {
                    StorageProxy.commitPaxos(proposal, consistencyForCommit);
                }
                Tracing.trace("CAS successful");
                return null;
            }
            Tracing.trace("Paxos proposal not accepted (pre-empted by a higher ballot)");
            Uninterruptibles.sleepUninterruptibly((long)FBUtilities.threadLocalRandom().nextInt(100), (TimeUnit)TimeUnit.MILLISECONDS);
        }
        throw new WriteTimeoutException(WriteType.CAS, consistencyForPaxos, -1, -1);
    }

    private static boolean hasLiveColumns(ColumnFamily cf, long now) {
        return cf != null && !cf.hasOnlyTombstones(now);
    }

    private static boolean casApplies(ColumnFamily expected, ColumnFamily current) {
        long now = System.currentTimeMillis();
        if (!StorageProxy.hasLiveColumns(expected, now)) {
            return !StorageProxy.hasLiveColumns(current, now);
        }
        if (!StorageProxy.hasLiveColumns(current, now)) {
            return false;
        }
        for (Column e : expected) {
            Column c = current.getColumn(e.name());
            if (!(e.isLive(now) ? c == null || !c.isLive(now) || !c.value().equals(e.value()) : c != null && c.isLive(now))) continue;
            return false;
        }
        return true;
    }

    private static Predicate<InetAddress> sameDCPredicateFor(final String dc) {
        final IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
        return new Predicate<InetAddress>(){

            public boolean apply(InetAddress host) {
                return dc.equals(snitch.getDatacenter(host));
            }
        };
    }

    private static Pair<List<InetAddress>, Integer> getPaxosParticipants(String keyspaceName, ByteBuffer key, ConsistencyLevel consistencyForPaxos) throws UnavailableException {
        Object tk = StorageService.getPartitioner().getToken(key);
        ImmutableList naturalEndpoints = StorageService.instance.getNaturalEndpoints(keyspaceName, (RingPosition)tk);
        ImmutableList pendingEndpoints = StorageService.instance.getTokenMetadata().pendingEndpointsFor((Token)tk, keyspaceName);
        if (consistencyForPaxos == ConsistencyLevel.LOCAL_SERIAL) {
            String localDc = DatabaseDescriptor.getEndpointSnitch().getDatacenter(FBUtilities.getBroadcastAddress());
            Predicate<InetAddress> isLocalDc = StorageProxy.sameDCPredicateFor(localDc);
            naturalEndpoints = ImmutableList.copyOf((Iterable)Iterables.filter(naturalEndpoints, isLocalDc));
            pendingEndpoints = ImmutableList.copyOf((Iterable)Iterables.filter(pendingEndpoints, isLocalDc));
        }
        int requiredParticipants = pendingEndpoints.size() + 1 + naturalEndpoints.size() / 2;
        ImmutableList liveEndpoints = ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)Iterables.concat((Iterable)naturalEndpoints, pendingEndpoints), IAsyncCallback.isAlive));
        if (liveEndpoints.size() < requiredParticipants) {
            throw new UnavailableException(consistencyForPaxos, requiredParticipants, liveEndpoints.size());
        }
        return Pair.create(liveEndpoints, requiredParticipants);
    }

    private static UUID beginAndRepairPaxos(long start, ByteBuffer key, CFMetaData metadata, List<InetAddress> liveEndpoints, int requiredParticipants, ConsistencyLevel consistencyForPaxos) throws WriteTimeoutException {
        long timeout = TimeUnit.MILLISECONDS.toNanos(DatabaseDescriptor.getCasContentionTimeout());
        PrepareCallback summary = null;
        while (start - System.nanoTime() < timeout) {
            long ballotMillis = summary == null ? System.currentTimeMillis() : Math.max(System.currentTimeMillis(), 1L + UUIDGen.unixTimestamp(summary.inProgressCommit.ballot));
            UUID ballot = UUIDGen.getTimeUUID(ballotMillis);
            Tracing.trace("Preparing {}", ballot);
            Commit toPrepare = Commit.newPrepare(key, metadata, ballot);
            summary = StorageProxy.preparePaxos(toPrepare, liveEndpoints, requiredParticipants);
            if (!summary.promised) {
                Tracing.trace("Some replicas have already promised a higher ballot than ours; aborting");
                Uninterruptibles.sleepUninterruptibly((long)FBUtilities.threadLocalRandom().nextInt(100), (TimeUnit)TimeUnit.MILLISECONDS);
                continue;
            }
            Commit inProgress = summary.inProgressCommit;
            Commit mostRecent = summary.mostRecentCommit;
            if (!inProgress.update.isEmpty() && inProgress.isAfter(mostRecent)) {
                Tracing.trace("Finishing incomplete paxos round {}", inProgress);
                if (!StorageProxy.proposePaxos(inProgress, liveEndpoints, requiredParticipants)) continue;
                StorageProxy.commitPaxos(inProgress, ConsistencyLevel.QUORUM);
                continue;
            }
            Iterable<InetAddress> missingMRC = summary.replicasMissingMostRecentCommit();
            if (Iterables.size(missingMRC) > 0) {
                Tracing.trace("Repairing replicas that missed the most recent commit");
                StorageProxy.sendCommit(mostRecent, missingMRC);
                continue;
            }
            return ballot;
        }
        throw new WriteTimeoutException(WriteType.CAS, consistencyForPaxos, -1, -1);
    }

    private static void sendCommit(Commit commit, Iterable<InetAddress> replicas) {
        MessageOut<Commit> message = new MessageOut<Commit>(MessagingService.Verb.PAXOS_COMMIT, commit, Commit.serializer);
        for (InetAddress target : replicas) {
            MessagingService.instance().sendOneWay(message, target);
        }
    }

    private static PrepareCallback preparePaxos(Commit toPrepare, List<InetAddress> endpoints, int requiredParticipants) throws WriteTimeoutException {
        PrepareCallback callback = new PrepareCallback(toPrepare.key, toPrepare.update.metadata(), requiredParticipants);
        MessageOut<Commit> message = new MessageOut<Commit>(MessagingService.Verb.PAXOS_PREPARE, toPrepare, Commit.serializer);
        for (InetAddress target : endpoints) {
            MessagingService.instance().sendRR(message, target, callback);
        }
        callback.await();
        return callback;
    }

    private static boolean proposePaxos(Commit proposal, List<InetAddress> endpoints, int requiredParticipants) throws WriteTimeoutException {
        ProposeCallback callback = new ProposeCallback(requiredParticipants);
        MessageOut<Commit> message = new MessageOut<Commit>(MessagingService.Verb.PAXOS_PROPOSE, proposal, Commit.serializer);
        for (InetAddress target : endpoints) {
            MessagingService.instance().sendRR(message, target, callback);
        }
        callback.await();
        return callback.getSuccessful() >= requiredParticipants;
    }

    private static void commitPaxos(Commit proposal, ConsistencyLevel consistencyLevel) throws WriteTimeoutException {
        Keyspace keyspace = Keyspace.open(proposal.update.metadata().ksName);
        Object tk = StorageService.getPartitioner().getToken(proposal.key);
        List<InetAddress> naturalEndpoints = StorageService.instance.getNaturalEndpoints(keyspace.getName(), (RingPosition)tk);
        Collection<InetAddress> pendingEndpoints = StorageService.instance.getTokenMetadata().pendingEndpointsFor((Token)tk, keyspace.getName());
        AbstractReplicationStrategy rs = keyspace.getReplicationStrategy();
        AbstractWriteResponseHandler responseHandler = rs.getWriteResponseHandler(naturalEndpoints, pendingEndpoints, consistencyLevel, null, WriteType.SIMPLE);
        MessageOut<Commit> message = new MessageOut<Commit>(MessagingService.Verb.PAXOS_COMMIT, proposal, Commit.serializer);
        for (InetAddress destination : Iterables.concat(naturalEndpoints, pendingEndpoints)) {
            if (!FailureDetector.instance.isAlive(destination)) continue;
            MessagingService.instance().sendRR(message, destination, responseHandler);
        }
        responseHandler.get();
    }

    public static void mutate(Collection<? extends IMutation> mutations, ConsistencyLevel consistency_level) throws UnavailableException, OverloadedException, WriteTimeoutException {
        Tracing.trace("Determining replicas for mutation");
        String localDataCenter = DatabaseDescriptor.getEndpointSnitch().getDatacenter(FBUtilities.getBroadcastAddress());
        long startTime = System.nanoTime();
        ArrayList<AbstractWriteResponseHandler> responseHandlers = new ArrayList<AbstractWriteResponseHandler>(mutations.size());
        try {
            for (IMutation iMutation : mutations) {
                if (iMutation instanceof CounterMutation) {
                    responseHandlers.add(StorageProxy.mutateCounter((CounterMutation)iMutation, localDataCenter));
                    continue;
                }
                WriteType wt = mutations.size() <= 1 ? WriteType.SIMPLE : WriteType.UNLOGGED_BATCH;
                responseHandlers.add(StorageProxy.performWrite(iMutation, consistency_level, localDataCenter, standardWritePerformer, null, wt));
            }
            for (AbstractWriteResponseHandler abstractWriteResponseHandler : responseHandlers) {
                abstractWriteResponseHandler.get();
            }
        }
        catch (WriteTimeoutException ex) {
            StorageProxy.writeMetrics.timeouts.mark();
            ClientRequestMetrics.writeTimeouts.inc();
            Tracing.trace("Write timeout; received {} of {} required replies", ex.received, ex.blockFor);
            throw ex;
        }
        catch (UnavailableException e) {
            StorageProxy.writeMetrics.unavailables.mark();
            ClientRequestMetrics.writeUnavailables.inc();
            Tracing.trace("Unavailable");
            throw e;
        }
        catch (OverloadedException e) {
            ClientRequestMetrics.writeUnavailables.inc();
            Tracing.trace("Overloaded");
            throw e;
        }
        finally {
            writeMetrics.addNano(System.nanoTime() - startTime);
        }
    }

    public static void mutateWithTriggers(Collection<? extends IMutation> mutations, ConsistencyLevel consistencyLevel, boolean mutateAtomically) throws WriteTimeoutException, UnavailableException, OverloadedException, InvalidRequestException {
        Collection<RowMutation> tmutations = TriggerExecutor.instance.execute(mutations);
        if (mutateAtomically || tmutations != null) {
            Collection<? extends IMutation> allMutations = mutations;
            if (tmutations != null) {
                allMutations.addAll(tmutations);
            }
            StorageProxy.mutateAtomically(allMutations, consistencyLevel);
        } else {
            StorageProxy.mutate(mutations, consistencyLevel);
        }
    }

    public static void mutateAtomically(Collection<RowMutation> mutations, ConsistencyLevel consistency_level) throws UnavailableException, OverloadedException, WriteTimeoutException {
        Tracing.trace("Determining replicas for atomic batch");
        long startTime = System.nanoTime();
        ArrayList<WriteResponseHandlerWrapper> wrappers = new ArrayList<WriteResponseHandlerWrapper>(mutations.size());
        String localDataCenter = DatabaseDescriptor.getEndpointSnitch().getDatacenter(FBUtilities.getBroadcastAddress());
        try {
            for (RowMutation mutation : mutations) {
                WriteResponseHandlerWrapper wrapper = StorageProxy.wrapResponseHandler(mutation, consistency_level, WriteType.BATCH);
                wrapper.handler.assureSufficientLiveNodes();
                wrappers.add(wrapper);
            }
            Collection<InetAddress> batchlogEndpoints = StorageProxy.getBatchlogEndpoints(localDataCenter);
            UUID batchUUID = UUID.randomUUID();
            StorageProxy.syncWriteToBatchlog(mutations, batchlogEndpoints, batchUUID);
            StorageProxy.syncWriteBatchedMutations(wrappers, localDataCenter, consistency_level);
            StorageProxy.asyncRemoveFromBatchlog(batchlogEndpoints, batchUUID);
        }
        catch (UnavailableException e) {
            StorageProxy.writeMetrics.unavailables.mark();
            ClientRequestMetrics.writeUnavailables.inc();
            Tracing.trace("Unavailable");
            throw e;
        }
        catch (WriteTimeoutException e) {
            StorageProxy.writeMetrics.timeouts.mark();
            ClientRequestMetrics.writeTimeouts.inc();
            Tracing.trace("Write timeout; received {} of {} required replies", e.received, e.blockFor);
            throw e;
        }
        finally {
            writeMetrics.addNano(System.nanoTime() - startTime);
        }
    }

    private static void syncWriteToBatchlog(Collection<RowMutation> mutations, Collection<InetAddress> endpoints, UUID uuid) throws WriteTimeoutException {
        RowMutation rm = BatchlogManager.getBatchlogMutationFor(mutations, uuid);
        WriteResponseHandler handler = new WriteResponseHandler(endpoints, Collections.emptyList(), ConsistencyLevel.ONE, Keyspace.open("system"), null, WriteType.BATCH_LOG);
        StorageProxy.updateBatchlog(rm, endpoints, handler);
        handler.get();
    }

    private static void asyncRemoveFromBatchlog(Collection<InetAddress> endpoints, UUID uuid) {
        EmptyColumns cf = EmptyColumns.factory.create(Schema.instance.getCFMetaData("system", "batchlog"));
        ((ColumnFamily)cf).delete(new DeletionInfo(FBUtilities.timestampMicros(), (int)(System.currentTimeMillis() / 1000L)));
        WriteResponseHandler handler = new WriteResponseHandler(endpoints, Collections.emptyList(), ConsistencyLevel.ANY, Keyspace.open("system"), null, WriteType.SIMPLE);
        RowMutation rm = new RowMutation("system", UUIDType.instance.decompose(uuid), cf);
        StorageProxy.updateBatchlog(rm, endpoints, handler);
    }

    private static void updateBatchlog(RowMutation rm, Collection<InetAddress> endpoints, AbstractWriteResponseHandler handler) {
        if (endpoints.contains(FBUtilities.getBroadcastAddress())) {
            assert (endpoints.size() == 1);
            StorageProxy.insertLocal(rm, handler);
        } else {
            MessageOut<RowMutation> message = rm.createMessage();
            for (InetAddress target : endpoints) {
                MessagingService.instance().sendRR(message, target, handler);
            }
        }
    }

    private static void syncWriteBatchedMutations(List<WriteResponseHandlerWrapper> wrappers, String localDataCenter, ConsistencyLevel consistencyLevel) throws WriteTimeoutException, OverloadedException {
        for (WriteResponseHandlerWrapper wrapper : wrappers) {
            Iterable endpoints = Iterables.concat(wrapper.handler.naturalEndpoints, wrapper.handler.pendingEndpoints);
            StorageProxy.sendToHintedEndpoints(wrapper.mutation, endpoints, wrapper.handler, localDataCenter, consistencyLevel);
        }
        for (WriteResponseHandlerWrapper wrapper : wrappers) {
            wrapper.handler.get();
        }
    }

    public static AbstractWriteResponseHandler performWrite(IMutation mutation, ConsistencyLevel consistency_level, String localDataCenter, WritePerformer performer, Runnable callback, WriteType writeType) throws UnavailableException, OverloadedException {
        String keyspaceName = mutation.getKeyspaceName();
        AbstractReplicationStrategy rs = Keyspace.open(keyspaceName).getReplicationStrategy();
        Object tk = StorageService.getPartitioner().getToken(mutation.key());
        List<InetAddress> naturalEndpoints = StorageService.instance.getNaturalEndpoints(keyspaceName, (RingPosition)tk);
        Collection<InetAddress> pendingEndpoints = StorageService.instance.getTokenMetadata().pendingEndpointsFor((Token)tk, keyspaceName);
        AbstractWriteResponseHandler responseHandler = rs.getWriteResponseHandler(naturalEndpoints, pendingEndpoints, consistency_level, callback, writeType);
        responseHandler.assureSufficientLiveNodes();
        performer.apply(mutation, Iterables.concat(naturalEndpoints, pendingEndpoints), responseHandler, localDataCenter, consistency_level);
        return responseHandler;
    }

    private static WriteResponseHandlerWrapper wrapResponseHandler(RowMutation mutation, ConsistencyLevel consistency_level, WriteType writeType) {
        AbstractReplicationStrategy rs = Keyspace.open(mutation.getKeyspaceName()).getReplicationStrategy();
        String keyspaceName = mutation.getKeyspaceName();
        Object tk = StorageService.getPartitioner().getToken(mutation.key());
        List<InetAddress> naturalEndpoints = StorageService.instance.getNaturalEndpoints(keyspaceName, (RingPosition)tk);
        Collection<InetAddress> pendingEndpoints = StorageService.instance.getTokenMetadata().pendingEndpointsFor((Token)tk, keyspaceName);
        AbstractWriteResponseHandler responseHandler = rs.getWriteResponseHandler(naturalEndpoints, pendingEndpoints, consistency_level, null, writeType);
        return new WriteResponseHandlerWrapper(responseHandler, mutation);
    }

    private static Collection<InetAddress> getBatchlogEndpoints(String localDataCenter) throws UnavailableException {
        TokenMetadata.Topology topology = StorageService.instance.getTokenMetadata().cloneOnlyTokenMap().getTopology();
        Collection localMembers = topology.getDatacenterEndpoints().get((Object)localDataCenter);
        if (localMembers.size() == 1) {
            return localMembers;
        }
        localMembers.remove(FBUtilities.getBroadcastAddress());
        List<InetAddress> candidates = new ArrayList<InetAddress>(localMembers.size());
        for (InetAddress member : localMembers) {
            if (!FailureDetector.instance.isAlive(member)) continue;
            candidates.add(member);
        }
        if (candidates.isEmpty()) {
            throw new UnavailableException(ConsistencyLevel.ONE, 1, 0);
        }
        if (candidates.size() > 2) {
            IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
            snitch.sortByProximity(FBUtilities.getBroadcastAddress(), candidates);
            candidates = candidates.subList(0, 2);
        }
        return candidates;
    }

    public static void sendToHintedEndpoints(RowMutation rm, Iterable<InetAddress> targets, AbstractWriteResponseHandler responseHandler, String localDataCenter, ConsistencyLevel consistency_level) throws OverloadedException {
        HashMap dcGroups = null;
        MessageOut<RowMutation> message = null;
        for (InetAddress destination : targets) {
            if (totalHintsInProgress.get() > maxHintsInProgress && hintsInProgress.get(destination).get() > 0 && StorageProxy.shouldHint(destination)) {
                throw new OverloadedException("Too many in flight hints: " + totalHintsInProgress.get());
            }
            if (FailureDetector.instance.isAlive(destination)) {
                ArrayList<InetAddress> messages;
                String dc;
                if (destination.equals(FBUtilities.getBroadcastAddress())) {
                    StorageProxy.insertLocal(rm, responseHandler);
                    continue;
                }
                if (message == null) {
                    message = rm.createMessage();
                }
                if (localDataCenter.equals(dc = DatabaseDescriptor.getEndpointSnitch().getDatacenter(destination)) || MessagingService.instance().getVersion(destination) < 7) {
                    MessagingService.instance().sendRR(message, destination, responseHandler);
                    continue;
                }
                ArrayList<InetAddress> arrayList = messages = dcGroups != null ? (ArrayList<InetAddress>)dcGroups.get(dc) : null;
                if (messages == null) {
                    messages = new ArrayList<InetAddress>(3);
                    if (dcGroups == null) {
                        dcGroups = new HashMap();
                    }
                    dcGroups.put(dc, messages);
                }
                messages.add(destination);
                continue;
            }
            if (!StorageProxy.shouldHint(destination)) continue;
            StorageProxy.submitHint(rm, destination, responseHandler, consistency_level);
        }
        if (dcGroups != null) {
            if (message == null) {
                message = rm.createMessage();
            }
            for (Collection dcTargets : dcGroups.values()) {
                StorageProxy.sendMessagesToNonlocalDC(message, dcTargets, responseHandler);
            }
        }
    }

    public static Future<Void> submitHint(final RowMutation mutation, InetAddress target, final AbstractWriteResponseHandler responseHandler, final ConsistencyLevel consistencyLevel) {
        assert (!target.equals(FBUtilities.getBroadcastAddress())) : target;
        HintRunnable runnable = new HintRunnable(target){

            @Override
            public void runMayThrow() {
                int ttl = HintedHandOffManager.calculateHintTTL(mutation);
                if (ttl > 0) {
                    logger.debug("Adding hint for {}", (Object)this.target);
                    StorageProxy.writeHintForMutation(mutation, ttl, this.target);
                    if (responseHandler != null && consistencyLevel == ConsistencyLevel.ANY) {
                        responseHandler.response((MessageIn)null);
                    }
                } else {
                    logger.debug("Skipped writing hint for {} (ttl {})", (Object)this.target, (Object)ttl);
                }
            }
        };
        return StorageProxy.submitHint(runnable);
    }

    private static Future<Void> submitHint(HintRunnable runnable) {
        totalHintsInProgress.incrementAndGet();
        hintsInProgress.get(runnable.target).incrementAndGet();
        return StageManager.getStage(Stage.MUTATION).submit(runnable);
    }

    public static void writeHintForMutation(RowMutation mutation, int ttl, InetAddress target) {
        assert (ttl > 0);
        UUID hostId = StorageService.instance.getTokenMetadata().getHostId(target);
        assert (hostId != null) : "Missing host ID for " + target.getHostAddress();
        HintedHandOffManager.instance.hintFor(mutation, ttl, hostId).apply();
        totalHints.incrementAndGet();
    }

    private static void sendMessagesToNonlocalDC(MessageOut message, Collection<InetAddress> targets, AbstractWriteResponseHandler handler) {
        Iterator<InetAddress> iter = targets.iterator();
        InetAddress target = iter.next();
        DataOutputBuffer out = new DataOutputBuffer();
        try {
            out.writeInt(targets.size() - 1);
            while (iter.hasNext()) {
                InetAddress destination = iter.next();
                CompactEndpointSerializationHelper.serialize(destination, out);
                int id = MessagingService.instance().addCallback(handler, message, destination, message.getTimeout());
                out.writeInt(id);
                logger.trace("Adding FWD message to {}@{}", (Object)id, (Object)destination);
            }
            message = message.withParameter("FWD_TO", out.getData());
            int id = MessagingService.instance().sendRR(message, target, handler);
            logger.trace("Sending message to {}@{}", (Object)id, (Object)target);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static void insertLocal(final RowMutation rm, final AbstractWriteResponseHandler responseHandler) {
        DroppableRunnable runnable = new DroppableRunnable(MessagingService.Verb.MUTATION){

            @Override
            public void runMayThrow() {
                rm.apply();
                responseHandler.response((MessageIn)null);
            }
        };
        StageManager.getStage(Stage.MUTATION).execute(runnable);
    }

    public static AbstractWriteResponseHandler mutateCounter(CounterMutation cm, String localDataCenter) throws UnavailableException, OverloadedException {
        InetAddress endpoint = StorageProxy.findSuitableEndpoint(cm.getKeyspaceName(), cm.key(), localDataCenter, cm.consistency());
        if (endpoint.equals(FBUtilities.getBroadcastAddress())) {
            return StorageProxy.applyCounterMutationOnCoordinator(cm, localDataCenter);
        }
        String keyspaceName = cm.getKeyspaceName();
        AbstractReplicationStrategy rs = Keyspace.open(keyspaceName).getReplicationStrategy();
        Object tk = StorageService.getPartitioner().getToken(cm.key());
        List<InetAddress> naturalEndpoints = StorageService.instance.getNaturalEndpoints(keyspaceName, (RingPosition)tk);
        Collection<InetAddress> pendingEndpoints = StorageService.instance.getTokenMetadata().pendingEndpointsFor((Token)tk, keyspaceName);
        rs.getWriteResponseHandler(naturalEndpoints, pendingEndpoints, cm.consistency(), null, WriteType.COUNTER).assureSufficientLiveNodes();
        WriteResponseHandler responseHandler = new WriteResponseHandler(endpoint, WriteType.COUNTER);
        Tracing.trace("Enqueuing counter update to {}", endpoint);
        MessagingService.instance().sendRR(cm.makeMutationMessage(), endpoint, responseHandler);
        return responseHandler;
    }

    private static InetAddress findSuitableEndpoint(String keyspaceName, ByteBuffer key, String localDataCenter, ConsistencyLevel cl) throws UnavailableException {
        Keyspace keyspace = Keyspace.open(keyspaceName);
        IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
        List<InetAddress> endpoints = StorageService.instance.getLiveNaturalEndpoints(keyspace, key);
        if (endpoints.isEmpty()) {
            throw new UnavailableException(cl, cl.blockFor(keyspace), 0);
        }
        ArrayList<InetAddress> localEndpoints = new ArrayList<InetAddress>();
        for (InetAddress endpoint : endpoints) {
            if (!snitch.getDatacenter(endpoint).equals(localDataCenter)) continue;
            localEndpoints.add(endpoint);
        }
        if (localEndpoints.isEmpty()) {
            snitch.sortByProximity(FBUtilities.getBroadcastAddress(), endpoints);
            return endpoints.get(0);
        }
        return (InetAddress)localEndpoints.get(FBUtilities.threadLocalRandom().nextInt(localEndpoints.size()));
    }

    public static AbstractWriteResponseHandler applyCounterMutationOnLeader(CounterMutation cm, String localDataCenter, Runnable callback) throws UnavailableException, OverloadedException {
        return StorageProxy.performWrite(cm, cm.consistency(), localDataCenter, counterWritePerformer, callback, WriteType.COUNTER);
    }

    public static AbstractWriteResponseHandler applyCounterMutationOnCoordinator(CounterMutation cm, String localDataCenter) throws UnavailableException, OverloadedException {
        return StorageProxy.performWrite(cm, cm.consistency(), localDataCenter, counterWriteOnCoordinatorPerformer, null, WriteType.COUNTER);
    }

    private static Runnable counterWriteTask(final IMutation mutation, final Iterable<InetAddress> targets, final AbstractWriteResponseHandler responseHandler, final String localDataCenter, final ConsistencyLevel consistency_level) {
        return new LocalMutationRunnable(){

            @Override
            public void runMayThrow() {
                assert (mutation instanceof CounterMutation);
                final CounterMutation cm = (CounterMutation)mutation;
                cm.apply();
                responseHandler.response((MessageIn)null);
                Sets.SetView remotes = Sets.difference((Set)ImmutableSet.copyOf((Iterable)targets), (Set)ImmutableSet.of((Object)FBUtilities.getBroadcastAddress()));
                if (cm.shouldReplicateOnWrite() && !remotes.isEmpty()) {
                    StageManager.getStage(Stage.REPLICATE_ON_WRITE).execute(new DroppableRunnable(MessagingService.Verb.READ, (Set)remotes){
                        final /* synthetic */ Set val$remotes;
                        {
                            this.val$remotes = set;
                            super(x0);
                        }

                        @Override
                        public void runMayThrow() throws OverloadedException {
                            StorageProxy.sendToHintedEndpoints(cm.makeReplicationMutation(), this.val$remotes, responseHandler, localDataCenter, consistency_level);
                        }
                    });
                }
            }
        };
    }

    private static boolean systemKeyspaceQuery(List<ReadCommand> cmds) {
        for (ReadCommand cmd : cmds) {
            if (cmd.ksName.equals("system")) continue;
            return false;
        }
        return true;
    }

    public static List<Row> read(List<ReadCommand> commands, ConsistencyLevel consistency_level) throws UnavailableException, IsBootstrappingException, ReadTimeoutException, InvalidRequestException {
        List<Row> rows;
        block11: {
            if (StorageService.instance.isBootstrapMode() && !StorageProxy.systemKeyspaceQuery(commands)) {
                StorageProxy.readMetrics.unavailables.mark();
                ClientRequestMetrics.readUnavailables.inc();
                throw new IsBootstrappingException();
            }
            long start = System.nanoTime();
            rows = null;
            try {
                if (consistency_level.isSerialConsistency()) {
                    if (commands.size() > 1) {
                        throw new InvalidRequestException("SERIAL/LOCAL_SERIAL consistency may only be requested for one row at a time");
                    }
                    ReadCommand command = commands.get(0);
                    CFMetaData metadata = Schema.instance.getCFMetaData(command.ksName, command.cfName);
                    Pair<List<InetAddress>, Integer> p = StorageProxy.getPaxosParticipants(command.ksName, command.key, consistency_level);
                    List liveEndpoints = (List)p.left;
                    int requiredParticipants = (Integer)p.right;
                    try {
                        StorageProxy.beginAndRepairPaxos(start, command.key, metadata, liveEndpoints, requiredParticipants, consistency_level);
                    }
                    catch (WriteTimeoutException e) {
                        throw new ReadTimeoutException(consistency_level, -1, -1, false);
                    }
                    rows = StorageProxy.fetchRows(commands, ConsistencyLevel.QUORUM);
                    break block11;
                }
                rows = StorageProxy.fetchRows(commands, consistency_level);
            }
            catch (UnavailableException e) {
                StorageProxy.readMetrics.unavailables.mark();
                ClientRequestMetrics.readUnavailables.inc();
                throw e;
            }
            catch (ReadTimeoutException e) {
                StorageProxy.readMetrics.timeouts.mark();
                ClientRequestMetrics.readTimeouts.inc();
                throw e;
            }
            finally {
                readMetrics.addNano(System.nanoTime() - start);
            }
        }
        return rows;
    }

    private static List<Row> fetchRows(List<ReadCommand> initialCommands, ConsistencyLevel consistency_level) throws UnavailableException, ReadTimeoutException {
        ArrayList<Row> rows = new ArrayList<Row>(initialCommands.size());
        List commandsToRetry = Collections.emptyList();
        do {
            List<ReadCommand> commands = commandsToRetry.isEmpty() ? initialCommands : commandsToRetry;
            AbstractReadExecutor[] readExecutors = new AbstractReadExecutor[commands.size()];
            if (!commandsToRetry.isEmpty()) {
                Tracing.trace("Retrying {} commands", commandsToRetry.size());
            }
            for (int i = 0; i < commands.size(); ++i) {
                ReadCommand command = commands.get(i);
                assert (!command.isDigestQuery());
                AbstractReadExecutor exec = AbstractReadExecutor.getReadExecutor(command, consistency_level);
                exec.executeAsync();
                readExecutors[i] = exec;
            }
            for (AbstractReadExecutor exec : readExecutors) {
                exec.speculate();
            }
            ArrayList<ReadCommand> repairCommands = null;
            ArrayList<ReadCallback<ReadResponse, Row>> repairResponseHandlers = null;
            for (AbstractReadExecutor exec : readExecutors) {
                try {
                    Row row = exec.get();
                    if (row != null) {
                        exec.command.maybeTrim(row);
                        rows.add(row);
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Read: {} ms.", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - exec.handler.start));
                }
                catch (ReadTimeoutException ex) {
                    String gotData;
                    int blockFor = consistency_level.blockFor(Keyspace.open(exec.command.getKeyspace()));
                    int responseCount = exec.handler.getReceivedCount();
                    String string = responseCount > 0 ? (exec.resolver.isDataPresent() ? " (including data)" : " (only digests)") : (gotData = "");
                    if (Tracing.isTracing()) {
                        Tracing.trace("Timed out; received {} of {} responses{}", new Object[]{responseCount, blockFor, gotData});
                    } else if (logger.isDebugEnabled()) {
                        logger.debug("Read timeout; received {} of {} responses{}", new Object[]{responseCount, blockFor, gotData});
                    }
                    throw ex;
                }
                catch (DigestMismatchException ex) {
                    Tracing.trace("Digest mismatch: {}", ex);
                    ReadRepairMetrics.repairedBlocking.mark();
                    RowDataResolver resolver = new RowDataResolver(exec.command.ksName, exec.command.key, exec.command.filter(), exec.command.timestamp);
                    ReadCallback<ReadResponse, Row> repairHandler = exec.handler.withNewResolver(resolver);
                    if (repairCommands == null) {
                        repairCommands = new ArrayList<ReadCommand>();
                        repairResponseHandlers = new ArrayList<ReadCallback<ReadResponse, Row>>();
                    }
                    repairCommands.add(exec.command);
                    repairResponseHandlers.add(repairHandler);
                    MessageOut<ReadCommand> message = exec.command.createMessage();
                    for (InetAddress endpoint : exec.handler.endpoints) {
                        Tracing.trace("Enqueuing full data read to {}", endpoint);
                        MessagingService.instance().sendRR(message, endpoint, repairHandler);
                    }
                }
            }
            if (commandsToRetry != Collections.EMPTY_LIST) {
                commandsToRetry.clear();
            }
            if (repairResponseHandlers == null) continue;
            for (int i = 0; i < repairCommands.size(); ++i) {
                Row row;
                ReadCommand command = (ReadCommand)repairCommands.get(i);
                ReadCallback handler = (ReadCallback)repairResponseHandlers.get(i);
                try {
                    row = (Row)handler.get();
                }
                catch (DigestMismatchException e) {
                    throw new AssertionError((Object)e);
                }
                RowDataResolver resolver = (RowDataResolver)handler.resolver;
                try {
                    FBUtilities.waitOnFutures(resolver.repairResults, DatabaseDescriptor.getWriteRpcTimeout());
                }
                catch (TimeoutException e) {
                    Tracing.trace("Timed out on digest mismatch retries");
                    int blockFor = consistency_level.blockFor(Keyspace.open(command.getKeyspace()));
                    throw new ReadTimeoutException(consistency_level, blockFor, blockFor, true);
                }
                ReadCommand retryCommand = command.maybeGenerateRetryCommand(resolver, row);
                if (retryCommand != null) {
                    Tracing.trace("Issuing retry for read command");
                    if (commandsToRetry == Collections.EMPTY_LIST) {
                        commandsToRetry = new ArrayList();
                    }
                    commandsToRetry.add(retryCommand);
                    continue;
                }
                if (row == null) continue;
                command.maybeTrim(row);
                rows.add(row);
            }
        } while (!commandsToRetry.isEmpty());
        return rows;
    }

    public static List<InetAddress> getLiveSortedEndpoints(Keyspace keyspace, ByteBuffer key) {
        return StorageProxy.getLiveSortedEndpoints(keyspace, StorageService.getPartitioner().decorateKey(key));
    }

    private static List<InetAddress> getLiveSortedEndpoints(Keyspace keyspace, RingPosition pos) {
        List<InetAddress> liveEndpoints = StorageService.instance.getLiveNaturalEndpoints(keyspace, pos);
        DatabaseDescriptor.getEndpointSnitch().sortByProximity(FBUtilities.getBroadcastAddress(), liveEndpoints);
        return liveEndpoints;
    }

    private static List<InetAddress> intersection(List<InetAddress> l1, List<InetAddress> l2) {
        ArrayList<InetAddress> inter = new ArrayList<InetAddress>(l1);
        inter.retainAll(l2);
        return inter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Row> getRangeSlice(AbstractRangeCommand command, ConsistencyLevel consistency_level) throws UnavailableException, ReadTimeoutException {
        ArrayList<Row> rows;
        Tracing.trace("Determining replicas to query");
        long startTime = System.nanoTime();
        Keyspace keyspace = Keyspace.open(command.keyspace);
        try {
            int cql3RowCount = 0;
            rows = new ArrayList<Row>();
            List<AbstractBounds<RowPosition>> ranges = StorageProxy.getRestrictedRanges(command.keyRange);
            int i = 0;
            AbstractBounds<RowPosition> nextRange = null;
            List<InetAddress> nextEndpoints = null;
            List<InetAddress> nextFilteredEndpoints = null;
            while (i < ranges.size()) {
                AbstractBounds<RowPosition> range = nextRange == null ? ranges.get(i) : nextRange;
                List<InetAddress> liveEndpoints = nextEndpoints == null ? StorageProxy.getLiveSortedEndpoints(keyspace, range.right) : nextEndpoints;
                List<InetAddress> filteredEndpoints = nextFilteredEndpoints == null ? consistency_level.filterForQuery(keyspace, liveEndpoints) : nextFilteredEndpoints;
                ++i;
                while (i < ranges.size()) {
                    List<InetAddress> merged;
                    nextRange = ranges.get(i);
                    nextEndpoints = StorageProxy.getLiveSortedEndpoints(keyspace, nextRange.right);
                    nextFilteredEndpoints = consistency_level.filterForQuery(keyspace, nextEndpoints);
                    if (((RowPosition)range.right).isMinimum() || !consistency_level.isSufficientLiveNodes(keyspace, merged = StorageProxy.intersection(liveEndpoints, nextEndpoints))) break;
                    List<InetAddress> filteredMerged = consistency_level.filterForQuery(keyspace, merged);
                    if (!DatabaseDescriptor.getEndpointSnitch().isWorthMergingForRangeQuery(filteredMerged, filteredEndpoints, nextFilteredEndpoints)) break;
                    range = range.withNewRight((RowPosition)nextRange.right);
                    liveEndpoints = merged;
                    filteredEndpoints = filteredMerged;
                    ++i;
                }
                AbstractRangeCommand nodeCmd = command.forSubRange(range);
                RangeSliceResponseResolver resolver = new RangeSliceResponseResolver(nodeCmd.keyspace, command.timestamp);
                ReadCallback<RangeSliceReply, Iterable<Row>> handler = new ReadCallback<RangeSliceReply, Iterable<Row>>(resolver, consistency_level, nodeCmd, filteredEndpoints);
                handler.assureSufficientLiveNodes();
                resolver.setSources(filteredEndpoints);
                if (filteredEndpoints.size() == 1 && filteredEndpoints.get(0).equals(FBUtilities.getBroadcastAddress())) {
                    StageManager.getStage(Stage.READ).execute(new LocalRangeSliceRunnable(nodeCmd, handler));
                } else {
                    MessageOut<? extends AbstractRangeCommand> message = nodeCmd.createMessage();
                    for (InetAddress endpoint : filteredEndpoints) {
                        Tracing.trace("Enqueuing request to {}", endpoint);
                        MessagingService.instance().sendRR(message, endpoint, handler);
                    }
                }
                try {
                    for (Row row : handler.get()) {
                        rows.add(row);
                        if (!nodeCmd.countCQL3Rows()) continue;
                        cql3RowCount += row.getLiveCount(command.predicate, command.timestamp);
                    }
                    FBUtilities.waitOnFutures(resolver.repairResults, DatabaseDescriptor.getWriteRpcTimeout());
                }
                catch (ReadTimeoutException ex) {
                    String gotData;
                    int blockFor = consistency_level.blockFor(keyspace);
                    int responseCount = resolver.responses.size();
                    String string = responseCount > 0 ? (resolver.isDataPresent() ? " (including data)" : " (only digests)") : (gotData = "");
                    if (Tracing.isTracing()) {
                        Tracing.trace("Timed out; received {} of {} responses{} for range {} of {}", new Object[]{responseCount, blockFor, gotData, i, ranges.size()});
                    } else if (logger.isDebugEnabled()) {
                        logger.debug("Range slice timeout; received {} of {} responses{} for range {} of {}", new Object[]{responseCount, blockFor, gotData, i, ranges.size()});
                    }
                    throw ex;
                }
                catch (TimeoutException ex) {
                    int blockFor = consistency_level.blockFor(keyspace);
                    if (Tracing.isTracing()) {
                        Tracing.trace("Timed out while read-repairing after receiving all {} data and digest responses", blockFor);
                    } else {
                        logger.debug("Range slice timeout while read-repairing after receiving all {} data and digest responses", (Object)blockFor);
                    }
                    throw new ReadTimeoutException(consistency_level, blockFor, blockFor, true);
                }
                catch (DigestMismatchException e) {
                    throw new AssertionError((Object)e);
                }
                int count = nodeCmd.countCQL3Rows() ? cql3RowCount : rows.size();
                if (count < nodeCmd.limit()) continue;
                break;
            }
        }
        finally {
            rangeMetrics.addNano(System.nanoTime() - startTime);
        }
        return StorageProxy.trim(command, rows);
    }

    private static List<Row> trim(AbstractRangeCommand command, List<Row> rows) {
        if (command.countCQL3Rows()) {
            return rows;
        }
        return rows.size() > command.limit() ? rows.subList(0, command.limit()) : rows;
    }

    public static Map<String, List<String>> describeSchemaVersions() {
        String myVersion = Schema.instance.getVersion().toString();
        final ConcurrentHashMap versions = new ConcurrentHashMap();
        Set<InetAddress> liveHosts = Gossiper.instance.getLiveMembers();
        final CountDownLatch latch = new CountDownLatch(liveHosts.size());
        IAsyncCallback<UUID> cb = new IAsyncCallback<UUID>(){

            @Override
            public void response(MessageIn<UUID> message) {
                versions.put(message.from, message.payload);
                latch.countDown();
            }

            @Override
            public boolean isLatencyForSnitch() {
                return false;
            }
        };
        MessageOut message = new MessageOut(MessagingService.Verb.SCHEMA_CHECK);
        for (InetAddress endpoint : liveHosts) {
            MessagingService.instance().sendRR(message, endpoint, cb);
        }
        try {
            latch.await(DatabaseDescriptor.getRpcTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new AssertionError((Object)"This latch shouldn't have been interrupted.");
        }
        HashMap<String, List<String>> results = new HashMap<String, List<String>>();
        Iterable allHosts = Iterables.concat(Gossiper.instance.getLiveMembers(), Gossiper.instance.getUnreachableMembers());
        for (InetAddress inetAddress : allHosts) {
            UUID version = (UUID)versions.get(inetAddress);
            String stringVersion = version == null ? UNREACHABLE : version.toString();
            ArrayList<String> hosts = (ArrayList<String>)results.get(stringVersion);
            if (hosts == null) {
                hosts = new ArrayList<String>();
                results.put(stringVersion, hosts);
            }
            hosts.add(inetAddress.getHostAddress());
        }
        if (results.get(UNREACHABLE) != null) {
            logger.debug("Hosts not in agreement. Didn't get a response from everybody: {}", (Object)StringUtils.join((Collection)((Collection)results.get(UNREACHABLE)), (String)","));
        }
        for (Map.Entry entry : results.entrySet()) {
            if (((String)entry.getKey()).equals(UNREACHABLE) || ((String)entry.getKey()).equals(myVersion)) continue;
            for (String host : (List)entry.getValue()) {
                logger.debug("{} disagrees ({})", (Object)host, entry.getKey());
            }
        }
        if (results.size() == 1) {
            logger.debug("Schemas are in agreement.");
        }
        return results;
    }

    static <T extends RingPosition> List<AbstractBounds<T>> getRestrictedRanges(AbstractBounds<T> queryRange) {
        Token upperBoundToken;
        Object upperBound;
        if (queryRange instanceof Bounds && queryRange.left.equals(queryRange.right) && !queryRange.left.isMinimum(StorageService.getPartitioner())) {
            return Collections.singletonList(queryRange);
        }
        TokenMetadata tokenMetadata = StorageService.instance.getTokenMetadata();
        ArrayList<AbstractBounds<T>> ranges = new ArrayList<AbstractBounds<T>>();
        Iterator<Token> ringIter = TokenMetadata.ringIterator(tokenMetadata.sortedTokens(), queryRange.left.getToken(), true);
        AbstractBounds remainder = queryRange;
        while (ringIter.hasNext() && (remainder.left.equals(upperBound = (upperBoundToken = ringIter.next()).upperBound(queryRange.left.getClass())) || remainder.contains(upperBound))) {
            Pair<AbstractBounds<T>, AbstractBounds<T>> splits = remainder.split(upperBound);
            if (splits == null) continue;
            ranges.add((AbstractBounds<T>)splits.left);
            remainder = (AbstractBounds)splits.right;
        }
        ranges.add(remainder);
        return ranges;
    }

    @Override
    public long getReadOperations() {
        return StorageProxy.readMetrics.latency.count();
    }

    @Override
    public long getTotalReadLatencyMicros() {
        return StorageProxy.readMetrics.totalLatency.count();
    }

    @Override
    public double getRecentReadLatencyMicros() {
        return readMetrics.getRecentLatency();
    }

    @Override
    public long[] getTotalReadLatencyHistogramMicros() {
        return StorageProxy.readMetrics.totalLatencyHistogram.getBuckets(false);
    }

    @Override
    public long[] getRecentReadLatencyHistogramMicros() {
        return StorageProxy.readMetrics.recentLatencyHistogram.getBuckets(true);
    }

    @Override
    public long getRangeOperations() {
        return StorageProxy.rangeMetrics.latency.count();
    }

    @Override
    public long getTotalRangeLatencyMicros() {
        return StorageProxy.rangeMetrics.totalLatency.count();
    }

    @Override
    public double getRecentRangeLatencyMicros() {
        return rangeMetrics.getRecentLatency();
    }

    @Override
    public long[] getTotalRangeLatencyHistogramMicros() {
        return StorageProxy.rangeMetrics.totalLatencyHistogram.getBuckets(false);
    }

    @Override
    public long[] getRecentRangeLatencyHistogramMicros() {
        return StorageProxy.rangeMetrics.recentLatencyHistogram.getBuckets(true);
    }

    @Override
    public long getWriteOperations() {
        return StorageProxy.writeMetrics.latency.count();
    }

    @Override
    public long getTotalWriteLatencyMicros() {
        return StorageProxy.writeMetrics.totalLatency.count();
    }

    @Override
    public double getRecentWriteLatencyMicros() {
        return writeMetrics.getRecentLatency();
    }

    @Override
    public long[] getTotalWriteLatencyHistogramMicros() {
        return StorageProxy.writeMetrics.totalLatencyHistogram.getBuckets(false);
    }

    @Override
    public long[] getRecentWriteLatencyHistogramMicros() {
        return StorageProxy.writeMetrics.recentLatencyHistogram.getBuckets(true);
    }

    @Override
    public boolean getHintedHandoffEnabled() {
        return DatabaseDescriptor.hintedHandoffEnabled();
    }

    @Override
    public void setHintedHandoffEnabled(boolean b) {
        DatabaseDescriptor.setHintedHandoffEnabled(b);
    }

    @Override
    public int getMaxHintWindow() {
        return DatabaseDescriptor.getMaxHintWindow();
    }

    @Override
    public void setMaxHintWindow(int ms) {
        DatabaseDescriptor.setMaxHintWindow(ms);
    }

    public static boolean shouldHint(InetAddress ep) {
        boolean hintWindowExpired;
        if (!DatabaseDescriptor.hintedHandoffEnabled()) {
            HintedHandOffManager.instance.metrics.incrPastWindow(ep);
            return false;
        }
        boolean bl = hintWindowExpired = Gossiper.instance.getEndpointDowntime(ep) > (long)DatabaseDescriptor.getMaxHintWindow();
        if (hintWindowExpired) {
            HintedHandOffManager.instance.metrics.incrPastWindow(ep);
            Tracing.trace("Not hinting {} which has been down {}ms", ep, Gossiper.instance.getEndpointDowntime(ep));
        }
        return !hintWindowExpired;
    }

    public static void truncateBlocking(String keyspace, String cfname) throws UnavailableException, TimeoutException, IOException {
        logger.debug("Starting a blocking truncate operation on keyspace {}, CF {}", (Object)keyspace, (Object)cfname);
        if (StorageProxy.isAnyHostDown()) {
            logger.info("Cannot perform truncate, some hosts are down");
            int liveMembers = Gossiper.instance.getLiveMembers().size();
            throw new UnavailableException(ConsistencyLevel.ALL, liveMembers + Gossiper.instance.getUnreachableMembers().size(), liveMembers);
        }
        Set<InetAddress> allEndpoints = Gossiper.instance.getLiveMembers();
        int blockFor = allEndpoints.size();
        TruncateResponseHandler responseHandler = new TruncateResponseHandler(blockFor);
        Tracing.trace("Enqueuing truncate messages to hosts {}", allEndpoints);
        Truncation truncation = new Truncation(keyspace, cfname);
        MessageOut<Truncation> message = truncation.createMessage();
        for (InetAddress endpoint : allEndpoints) {
            MessagingService.instance().sendRR(message, endpoint, responseHandler);
        }
        try {
            responseHandler.get();
        }
        catch (TimeoutException e) {
            Tracing.trace("Timed out");
            throw e;
        }
    }

    private static boolean isAnyHostDown() {
        return !Gossiper.instance.getUnreachableMembers().isEmpty();
    }

    @Override
    public long getTotalHints() {
        return totalHints.get();
    }

    @Override
    public int getMaxHintsInProgress() {
        return maxHintsInProgress;
    }

    @Override
    public void setMaxHintsInProgress(int qs) {
        maxHintsInProgress = qs;
    }

    @Override
    public int getHintsInProgress() {
        return totalHintsInProgress.get();
    }

    public void verifyNoHintsInProgress() {
        if (this.getHintsInProgress() > 0) {
            logger.warn("Some hints were not written before shutdown.  This is not supposed to happen.  You should (a) run repair, and (b) file a bug report");
        }
    }

    @Override
    public Long getRpcTimeout() {
        return DatabaseDescriptor.getRpcTimeout();
    }

    @Override
    public void setRpcTimeout(Long timeoutInMillis) {
        DatabaseDescriptor.setRpcTimeout(timeoutInMillis);
    }

    @Override
    public Long getReadRpcTimeout() {
        return DatabaseDescriptor.getReadRpcTimeout();
    }

    @Override
    public void setReadRpcTimeout(Long timeoutInMillis) {
        DatabaseDescriptor.setReadRpcTimeout(timeoutInMillis);
    }

    @Override
    public Long getWriteRpcTimeout() {
        return DatabaseDescriptor.getWriteRpcTimeout();
    }

    @Override
    public void setWriteRpcTimeout(Long timeoutInMillis) {
        DatabaseDescriptor.setWriteRpcTimeout(timeoutInMillis);
    }

    @Override
    public Long getCasContentionTimeout() {
        return DatabaseDescriptor.getCasContentionTimeout();
    }

    @Override
    public void setCasContentionTimeout(Long timeoutInMillis) {
        DatabaseDescriptor.setCasContentionTimeout(timeoutInMillis);
    }

    @Override
    public Long getRangeRpcTimeout() {
        return DatabaseDescriptor.getRangeRpcTimeout();
    }

    @Override
    public void setRangeRpcTimeout(Long timeoutInMillis) {
        DatabaseDescriptor.setRangeRpcTimeout(timeoutInMillis);
    }

    @Override
    public Long getTruncateRpcTimeout() {
        return DatabaseDescriptor.getTruncateRpcTimeout();
    }

    @Override
    public void setTruncateRpcTimeout(Long timeoutInMillis) {
        DatabaseDescriptor.setTruncateRpcTimeout(timeoutInMillis);
    }

    @Override
    public void reloadTriggerClass() {
        TriggerExecutor.instance.reloadClasses();
    }

    @Override
    public long getReadRepairAttempted() {
        return ReadRepairMetrics.attempted.count();
    }

    @Override
    public long getReadRepairRepairedBlocking() {
        return ReadRepairMetrics.repairedBlocking.count();
    }

    @Override
    public long getReadRepairRepairedBackground() {
        return ReadRepairMetrics.repairedBackground.count();
    }

    static {
        instance = new StorageProxy();
        hintedHandoffEnabled = DatabaseDescriptor.hintedHandoffEnabled();
        maxHintWindow = DatabaseDescriptor.getMaxHintWindow();
        maxHintsInProgress = 1024 * FBUtilities.getAvailableProcessors();
        totalHintsInProgress = new AtomicInteger();
        hintsInProgress = new MapMaker().concurrencyLevel(1).makeComputingMap((Function)new Function<InetAddress, AtomicInteger>(){

            public AtomicInteger apply(InetAddress inetAddress) {
                return new AtomicInteger(0);
            }
        });
        totalHints = new AtomicLong();
        readMetrics = new ClientRequestMetrics("Read");
        rangeMetrics = new ClientRequestMetrics("RangeSlice");
        writeMetrics = new ClientRequestMetrics("Write");
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(new StorageProxy(), new ObjectName(MBEAN_NAME));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        standardWritePerformer = new WritePerformer(){

            @Override
            public void apply(IMutation mutation, Iterable<InetAddress> targets, AbstractWriteResponseHandler responseHandler, String localDataCenter, ConsistencyLevel consistency_level) throws OverloadedException {
                assert (mutation instanceof RowMutation);
                StorageProxy.sendToHintedEndpoints((RowMutation)mutation, targets, responseHandler, localDataCenter, consistency_level);
            }
        };
        counterWritePerformer = new WritePerformer(){

            @Override
            public void apply(IMutation mutation, Iterable<InetAddress> targets, AbstractWriteResponseHandler responseHandler, String localDataCenter, ConsistencyLevel consistency_level) {
                Runnable runnable = StorageProxy.counterWriteTask(mutation, targets, responseHandler, localDataCenter, consistency_level);
                runnable.run();
            }
        };
        counterWriteOnCoordinatorPerformer = new WritePerformer(){

            @Override
            public void apply(IMutation mutation, Iterable<InetAddress> targets, AbstractWriteResponseHandler responseHandler, String localDataCenter, ConsistencyLevel consistency_level) {
                Runnable runnable = StorageProxy.counterWriteTask(mutation, targets, responseHandler, localDataCenter, consistency_level);
                StageManager.getStage(Stage.MUTATION).execute(runnable);
            }
        };
    }

    private static abstract class HintRunnable
    implements Runnable {
        public final InetAddress target;

        protected HintRunnable(InetAddress target) {
            this.target = target;
        }

        @Override
        public void run() {
            try {
                this.runMayThrow();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                totalHintsInProgress.decrementAndGet();
                ((AtomicInteger)hintsInProgress.get(this.target)).decrementAndGet();
            }
        }

        protected abstract void runMayThrow() throws Exception;
    }

    private static abstract class LocalMutationRunnable
    implements Runnable {
        private final long constructionTime = System.nanoTime();

        private LocalMutationRunnable() {
        }

        @Override
        public final void run() {
            if (TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.constructionTime) > DatabaseDescriptor.getTimeout(MessagingService.Verb.MUTATION)) {
                MessagingService.instance().incrementDroppedMessages(MessagingService.Verb.MUTATION);
                HintRunnable runnable = new HintRunnable(FBUtilities.getBroadcastAddress()){

                    @Override
                    protected void runMayThrow() throws Exception {
                        LocalMutationRunnable.this.runMayThrow();
                    }
                };
                StorageProxy.submitHint(runnable);
                return;
            }
            try {
                this.runMayThrow();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected abstract void runMayThrow() throws Exception;
    }

    private static abstract class DroppableRunnable
    implements Runnable {
        private final long constructionTime = System.nanoTime();
        private final MessagingService.Verb verb;

        public DroppableRunnable(MessagingService.Verb verb) {
            this.verb = verb;
        }

        @Override
        public final void run() {
            if (TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.constructionTime) > DatabaseDescriptor.getTimeout(this.verb)) {
                MessagingService.instance().incrementDroppedMessages(this.verb);
                return;
            }
            try {
                this.runMayThrow();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected abstract void runMayThrow() throws Exception;
    }

    public static interface WritePerformer {
        public void apply(IMutation var1, Iterable<InetAddress> var2, AbstractWriteResponseHandler var3, String var4, ConsistencyLevel var5) throws OverloadedException;
    }

    static class LocalRangeSliceRunnable
    extends DroppableRunnable {
        private final AbstractRangeCommand command;
        private final ReadCallback<RangeSliceReply, Iterable<Row>> handler;
        private final long start = System.nanoTime();

        LocalRangeSliceRunnable(AbstractRangeCommand command, ReadCallback<RangeSliceReply, Iterable<Row>> handler) {
            super(MessagingService.Verb.READ);
            this.command = command;
            this.handler = handler;
        }

        @Override
        protected void runMayThrow() {
            RangeSliceReply result = new RangeSliceReply(this.command.executeLocally());
            MessagingService.instance().addLatency(FBUtilities.getBroadcastAddress(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.start));
            this.handler.response(result);
        }
    }

    static class LocalReadRunnable
    extends DroppableRunnable {
        private final ReadCommand command;
        private final ReadCallback<ReadResponse, Row> handler;
        private final long start = System.nanoTime();

        LocalReadRunnable(ReadCommand command, ReadCallback<ReadResponse, Row> handler) {
            super(MessagingService.Verb.READ);
            this.command = command;
            this.handler = handler;
        }

        @Override
        protected void runMayThrow() {
            Keyspace keyspace = Keyspace.open(this.command.ksName);
            Row r = this.command.getRow(keyspace);
            ReadResponse result = ReadVerbHandler.getResponse(this.command, r);
            MessagingService.instance().addLatency(FBUtilities.getBroadcastAddress(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.start));
            this.handler.response(result);
        }
    }

    private static class WriteResponseHandlerWrapper {
        final AbstractWriteResponseHandler handler;
        final RowMutation mutation;

        WriteResponseHandlerWrapper(AbstractWriteResponseHandler handler, RowMutation mutation) {
            this.handler = handler;
            this.mutation = mutation;
        }
    }
}

