/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.messages.SyncComplete;
import org.apache.cassandra.repair.messages.SyncRequest;
import org.apache.cassandra.streaming.StreamEvent;
import org.apache.cassandra.streaming.StreamEventHandler;
import org.apache.cassandra.streaming.StreamPlan;
import org.apache.cassandra.streaming.StreamResultFuture;
import org.apache.cassandra.streaming.StreamState;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingRepairTask
implements Runnable,
StreamEventHandler {
    private static final Logger logger = LoggerFactory.getLogger(StreamingRepairTask.class);
    public final RepairJobDesc desc;
    public final SyncRequest request;

    public StreamingRepairTask(RepairJobDesc desc, SyncRequest request) {
        this.desc = desc;
        this.request = request;
    }

    public boolean isLocalTask() {
        return this.request.initiator.equals(this.request.src);
    }

    @Override
    public void run() {
        if (this.request.src.equals(FBUtilities.getBroadcastAddress())) {
            this.initiateStreaming();
        } else {
            this.forwardToSource();
        }
    }

    private void initiateStreaming() {
        logger.info(String.format("[streaming task #%s] Performing streaming repair of %d ranges with %s", this.desc.sessionId, this.request.ranges.size(), this.request.dst));
        StreamResultFuture op = new StreamPlan("Repair").flushBeforeTransfer(true).requestRanges(this.request.dst, this.desc.keyspace, this.request.ranges, this.desc.columnFamily).transferRanges(this.request.dst, this.desc.keyspace, this.request.ranges, this.desc.columnFamily).execute();
        op.addEventListener(this);
    }

    private void forwardToSource() {
        logger.info(String.format("[repair #%s] Forwarding streaming repair of %d ranges to %s (to be streamed with %s)", this.desc.sessionId, this.request.ranges.size(), this.request.src, this.request.dst));
        MessagingService.instance().sendOneWay(this.request.createMessage(), this.request.src);
    }

    @Override
    public void handleStreamEvent(StreamEvent event) {
    }

    public void onSuccess(StreamState state) {
        logger.info(String.format("[repair #%s] streaming task succeed, returning response to %s", this.desc.sessionId, this.request.initiator));
        MessagingService.instance().sendOneWay(new SyncComplete(this.desc, this.request.src, this.request.dst, true).createMessage(), this.request.initiator);
    }

    public void onFailure(Throwable t) {
        MessagingService.instance().sendOneWay(new SyncComplete(this.desc, this.request.src, this.request.dst, false).createMessage(), this.request.initiator);
    }
}

