/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.net.InetAddress;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.service.StorageProxy;

public class CallbackInfo {
    protected final InetAddress target;
    protected final IAsyncCallback callback;
    protected final MessageOut<?> sentMessage;
    protected final IVersionedSerializer<?> serializer;

    public CallbackInfo(InetAddress target, IAsyncCallback callback, IVersionedSerializer<?> serializer) {
        this(target, callback, null, serializer);
    }

    public CallbackInfo(InetAddress target, IAsyncCallback callback, MessageOut<?> sentMessage, IVersionedSerializer<?> serializer) {
        this.target = target;
        this.callback = callback;
        this.sentMessage = sentMessage;
        this.serializer = serializer;
    }

    public boolean shouldHint() {
        return this.sentMessage != null && StorageProxy.shouldHint(this.target);
    }
}

