/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.gms.GossipDigest;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.net.CompactEndpointSerializationHelper;

class GossipDigestSerializer
implements IVersionedSerializer<GossipDigest> {
    GossipDigestSerializer() {
    }

    @Override
    public void serialize(GossipDigest gDigest, DataOutput out, int version) throws IOException {
        CompactEndpointSerializationHelper.serialize(gDigest.endpoint, out);
        out.writeInt(gDigest.generation);
        out.writeInt(gDigest.maxVersion);
    }

    @Override
    public GossipDigest deserialize(DataInput in, int version) throws IOException {
        InetAddress endpoint = CompactEndpointSerializationHelper.deserialize(in);
        int generation = in.readInt();
        int maxVersion = in.readInt();
        return new GossipDigest(endpoint, generation, maxVersion);
    }

    @Override
    public long serializedSize(GossipDigest gDigest, int version) {
        long size = CompactEndpointSerializationHelper.serializedSize(gDigest.endpoint);
        size += (long)TypeSizes.NATIVE.sizeof(gDigest.generation);
        return size += (long)TypeSizes.NATIVE.sizeof(gDigest.maxVersion);
    }
}

