/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.AbstractCompactionIterable;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.CompactionIterable;
import org.apache.cassandra.db.compaction.CompactionTask;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableMetadata;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.cassandra.utils.OutputHandler;

public class Upgrader {
    private final ColumnFamilyStore cfs;
    private final SSTableReader sstable;
    private final Collection<SSTableReader> toUpgrade;
    private final File directory;
    private final OperationType compactionType = OperationType.UPGRADE_SSTABLES;
    private final CompactionController controller;
    private final AbstractCompactionStrategy strategy;
    private final long estimatedRows;
    private final OutputHandler outputHandler;

    public Upgrader(ColumnFamilyStore cfs, SSTableReader sstable, OutputHandler outputHandler) {
        this.cfs = cfs;
        this.sstable = sstable;
        this.toUpgrade = Collections.singletonList(sstable);
        this.outputHandler = outputHandler;
        this.directory = new File(sstable.getFilename()).getParentFile();
        this.controller = new UpgradeController(cfs);
        this.strategy = cfs.getCompactionStrategy();
        long estimatedTotalKeys = Math.max((long)cfs.metadata.getIndexInterval(), SSTableReader.getApproximateKeyCount(this.toUpgrade, cfs.metadata));
        long estimatedSSTables = Math.max(1L, SSTable.getTotalBytes(this.toUpgrade) / this.strategy.getMaxSSTableSize());
        this.estimatedRows = (long)Math.ceil((double)estimatedTotalKeys / (double)estimatedSSTables);
    }

    private SSTableWriter createCompactionWriter() {
        SSTableMetadata.Collector sstableMetadataCollector = SSTableMetadata.createCollector(this.cfs.getComparator());
        for (SSTableReader sstable : this.toUpgrade) {
            sstableMetadataCollector.addAncestor(sstable.descriptor.generation);
            for (Integer i : sstable.getAncestors()) {
                if (!new File(sstable.descriptor.withGeneration(i).filenameFor(Component.DATA)).exists()) continue;
                sstableMetadataCollector.addAncestor(i);
            }
        }
        return new SSTableWriter(this.cfs.getTempSSTablePath(this.directory), this.estimatedRows, this.cfs.metadata, this.cfs.partitioner, sstableMetadataCollector);
    }

    public void upgrade() {
        this.outputHandler.output("Upgrading " + this.sstable);
        CompactionIterable ci = new CompactionIterable(this.compactionType, this.strategy.getScanners(this.toUpgrade), this.controller);
        Iterator iter = ((AbstractCompactionIterable)ci).iterator();
        ArrayList<SSTableReader> sstables = new ArrayList<SSTableReader>();
        ArrayList<SSTableWriter> writers = new ArrayList<SSTableWriter>();
        try {
            SSTableWriter writer = this.createCompactionWriter();
            writers.add(writer);
            while (iter.hasNext()) {
                AbstractCompactedRow row = (AbstractCompactedRow)iter.next();
                writer.append(row);
            }
            long maxAge = CompactionTask.getMaxDataAge(this.toUpgrade);
            for (SSTableWriter completedWriter : writers) {
                sstables.add(completedWriter.closeAndOpenReader(maxAge));
            }
            this.outputHandler.output("Upgrade of " + this.sstable + " complete.");
        }
        catch (Throwable t) {
            for (SSTableWriter writer : writers) {
                writer.abort();
            }
            for (SSTableReader sstable : sstables) {
                sstable.markObsolete();
                sstable.releaseReference();
            }
            throw Throwables.propagate((Throwable)t);
        }
        finally {
            this.controller.close();
            try {
                iter.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class UpgradeController
    extends CompactionController {
        public UpgradeController(ColumnFamilyStore cfs) {
            super(cfs, Integer.MAX_VALUE);
        }

        @Override
        public boolean shouldPurge(DecoratedKey key, long delTimestamp) {
            return false;
        }
    }
}

