/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.Set;
import org.apache.cassandra.auth.Auth;
import org.apache.cassandra.auth.DataResource;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.cql3.statements.AuthorizationStatement;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;

public abstract class PermissionAlteringStatement
extends AuthorizationStatement {
    protected final Set<Permission> permissions;
    protected DataResource resource;
    protected final String username;

    protected PermissionAlteringStatement(Set<Permission> permissions, IResource resource, String username) {
        this.permissions = permissions;
        this.resource = (DataResource)resource;
        this.username = username;
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        state.ensureNotAnonymous();
        if (!Auth.isExistingUser(this.username)) {
            throw new InvalidRequestException(String.format("User %s doesn't exist", this.username));
        }
        this.resource = PermissionAlteringStatement.maybeCorrectResource(this.resource, state);
        if (!this.resource.exists()) {
            throw new InvalidRequestException(String.format("%s doesn't exist", this.resource));
        }
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException {
        state.ensureHasPermission(Permission.AUTHORIZE, this.resource);
        for (Permission p : this.permissions) {
            state.ensureHasPermission(p, this.resource);
        }
    }
}

