/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Operation;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.ColumnGroupMap;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.cql3.statements.Selection;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.SliceFromReadCommand;
import org.apache.cassandra.db.TreeMapBackedSortedColumns;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;

public abstract class ModificationStatement
implements CQLStatement {
    private static final ColumnIdentifier CAS_RESULT_COLUMN = new ColumnIdentifier("[applied]", false);
    private final int boundTerms;
    public final CFMetaData cfm;
    private final Attributes attrs;
    private final Map<ColumnIdentifier, List<Term>> processedKeys = new HashMap<ColumnIdentifier, List<Term>>();
    private final List<Operation> columnOperations = new ArrayList<Operation>();
    private List<Operation> columnConditions;
    private boolean ifNotExists;

    public ModificationStatement(int boundTerms, CFMetaData cfm, Attributes attrs) {
        this.boundTerms = boundTerms;
        this.cfm = cfm;
        this.attrs = attrs;
    }

    protected abstract boolean requireFullClusteringKey();

    public abstract ColumnFamily updateForKey(ByteBuffer var1, ColumnNameBuilder var2, UpdateParameters var3) throws InvalidRequestException;

    @Override
    public int getBoundsTerms() {
        return this.boundTerms;
    }

    public String keyspace() {
        return this.cfm.ksName;
    }

    public String columnFamily() {
        return this.cfm.cfName;
    }

    public boolean isCounter() {
        return this.cfm.getDefaultValidator().isCommutative();
    }

    public long getTimestamp(long now, List<ByteBuffer> variables) throws InvalidRequestException {
        return this.attrs.getTimestamp(now, variables);
    }

    public boolean isTimestampSet() {
        return this.attrs.isTimestampSet();
    }

    public int getTimeToLive(List<ByteBuffer> variables) throws InvalidRequestException {
        return this.attrs.getTimeToLive(variables);
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException, UnauthorizedException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.MODIFY);
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
    }

    public void addOperation(Operation op) {
        this.columnOperations.add(op);
    }

    public List<Operation> getOperations() {
        return this.columnOperations;
    }

    public void addCondition(Operation op) {
        if (this.columnConditions == null) {
            this.columnConditions = new ArrayList<Operation>();
        }
        this.columnConditions.add(op);
    }

    public void setIfNotExistCondition() {
        this.ifNotExists = true;
    }

    private void addKeyValues(ColumnIdentifier name, List<Term> values) throws InvalidRequestException {
        if (this.processedKeys.put(name, values) != null) {
            throw new InvalidRequestException(String.format("Multiple definitions found for PRIMARY KEY part %s", name));
        }
    }

    public void addKeyValue(ColumnIdentifier name, Term value) throws InvalidRequestException {
        this.addKeyValues(name, Collections.singletonList(value));
    }

    public void processWhereClause(List<Relation> whereClause, ColumnSpecification[] names) throws InvalidRequestException {
        CFDefinition cfDef = this.cfm.getCfDef();
        for (Relation rel : whereClause) {
            CFDefinition.Name name = cfDef.get(rel.getEntity());
            if (name == null) {
                throw new InvalidRequestException(String.format("Unknown key identifier %s", rel.getEntity()));
            }
            switch (name.kind) {
                case KEY_ALIAS: 
                case COLUMN_ALIAS: {
                    List<Term.Raw> rawValues;
                    if (rel.operator() == Relation.Type.EQ) {
                        rawValues = Collections.singletonList(rel.getValue());
                    } else if (name.kind == CFDefinition.Name.Kind.KEY_ALIAS && rel.operator() == Relation.Type.IN) {
                        rawValues = rel.getInValues();
                    } else {
                        throw new InvalidRequestException(String.format("Invalid operator %s for PRIMARY KEY part %s", new Object[]{rel.operator(), name}));
                    }
                    ArrayList<Term> values = new ArrayList<Term>(rawValues.size());
                    for (Term.Raw raw : rawValues) {
                        Term t = raw.prepare(name);
                        t.collectMarkerSpecification(names);
                        values.add(t);
                    }
                    this.addKeyValues(name.name, values);
                    break;
                }
                case VALUE_ALIAS: 
                case COLUMN_METADATA: {
                    throw new InvalidRequestException(String.format("Non PRIMARY KEY %s found in where clause", name));
                }
            }
        }
    }

    private List<ByteBuffer> buildPartitionKeyNames(List<ByteBuffer> variables) throws InvalidRequestException {
        CFDefinition cfDef = this.cfm.getCfDef();
        ColumnNameBuilder keyBuilder = cfDef.getKeyNameBuilder();
        ArrayList<ByteBuffer> keys = new ArrayList<ByteBuffer>();
        for (CFDefinition.Name name : cfDef.keys.values()) {
            List<Term> values = this.processedKeys.get(name.name);
            if (values == null) {
                throw new InvalidRequestException(String.format("Missing mandatory PRIMARY KEY part %s", name));
            }
            if (keyBuilder.remainingCount() == 1) {
                for (Term t : values) {
                    ByteBuffer val = t.bindAndGet(variables);
                    if (val == null) {
                        throw new InvalidRequestException(String.format("Invalid null value for partition key part %s", name));
                    }
                    keys.add(keyBuilder.copy().add(val).build());
                }
                continue;
            }
            if (values.isEmpty() || values.size() > 1) {
                throw new InvalidRequestException("IN is only supported on the last column of the partition key");
            }
            ByteBuffer val = values.get(0).bindAndGet(variables);
            if (val == null) {
                throw new InvalidRequestException(String.format("Invalid null value for partition key part %s", name));
            }
            keyBuilder.add(val);
        }
        return keys;
    }

    private ColumnNameBuilder createClusteringPrefixBuilder(List<ByteBuffer> variables) throws InvalidRequestException {
        CFDefinition cfDef = this.cfm.getCfDef();
        ColumnNameBuilder builder = cfDef.getColumnNameBuilder();
        CFDefinition.Name firstEmptyKey = null;
        for (CFDefinition.Name name : cfDef.columns.values()) {
            List<Term> values = this.processedKeys.get(name.name);
            if (values == null) {
                firstEmptyKey = name;
                if (!this.requireFullClusteringKey() || !cfDef.isComposite || cfDef.isCompact) continue;
                throw new InvalidRequestException(String.format("Missing mandatory PRIMARY KEY part %s", name));
            }
            if (firstEmptyKey != null) {
                throw new InvalidRequestException(String.format("Missing PRIMARY KEY part %s since %s is set", firstEmptyKey.name, name.name));
            }
            assert (values.size() == 1);
            ByteBuffer val = values.get(0).bindAndGet(variables);
            if (val == null) {
                throw new InvalidRequestException(String.format("Invalid null value for clustering key part %s", name));
            }
            builder.add(val);
        }
        return builder;
    }

    protected CFDefinition.Name getFirstEmptyKey() {
        for (CFDefinition.Name name : this.cfm.getCfDef().columns.values()) {
            List<Term> values = this.processedKeys.get(name.name);
            if (values != null && !values.isEmpty()) continue;
            return name;
        }
        return null;
    }

    protected Map<ByteBuffer, ColumnGroupMap> readRequiredRows(List<ByteBuffer> partitionKeys, ColumnNameBuilder clusteringPrefix, boolean local, ConsistencyLevel cl) throws RequestExecutionException, RequestValidationException {
        TreeSet<ByteBuffer> toRead = null;
        for (Operation op : this.columnOperations) {
            if (!op.requiresRead()) continue;
            if (toRead == null) {
                toRead = new TreeSet<ByteBuffer>(UTF8Type.instance);
            }
            toRead.add(op.columnName.key);
        }
        return toRead == null ? null : this.readRows(partitionKeys, clusteringPrefix, toRead, (CompositeType)this.cfm.comparator, local, cl);
    }

    private Map<ByteBuffer, ColumnGroupMap> readRows(List<ByteBuffer> partitionKeys, ColumnNameBuilder clusteringPrefix, Set<ByteBuffer> toRead, CompositeType composite, boolean local, ConsistencyLevel cl) throws RequestExecutionException, RequestValidationException {
        try {
            cl.validateForRead(this.keyspace());
        }
        catch (InvalidRequestException e) {
            throw new InvalidRequestException(String.format("Write operation require a read but consistency %s is not supported on reads", new Object[]{cl}));
        }
        ColumnSlice[] slices = new ColumnSlice[toRead.size()];
        int i = 0;
        for (ByteBuffer name : toRead) {
            ByteBuffer start = clusteringPrefix.copy().add(name).build();
            ByteBuffer finish = clusteringPrefix.copy().add(name).buildAsEndOfRange();
            slices[i++] = new ColumnSlice(start, finish);
        }
        ArrayList<ReadCommand> commands = new ArrayList<ReadCommand>(partitionKeys.size());
        long now = System.currentTimeMillis();
        for (ByteBuffer key : partitionKeys) {
            commands.add(new SliceFromReadCommand(this.keyspace(), key, this.columnFamily(), now, new SliceQueryFilter(slices, false, Integer.MAX_VALUE)));
        }
        List<Row> rows = local ? SelectStatement.readLocally(this.keyspace(), commands) : StorageProxy.read(commands, cl);
        HashMap<ByteBuffer, ColumnGroupMap> map = new HashMap<ByteBuffer, ColumnGroupMap>();
        for (Row row : rows) {
            if (row.cf == null || row.cf.getColumnCount() == 0) continue;
            ColumnGroupMap.Builder groupBuilder = new ColumnGroupMap.Builder(composite, true, now);
            for (Column column : row.cf) {
                groupBuilder.add(column);
            }
            List<ColumnGroupMap> groups = groupBuilder.groups();
            assert (groups.isEmpty() || groups.size() == 1);
            if (groups.isEmpty()) continue;
            map.put(row.key.key, groups.get(0));
        }
        return map;
    }

    public boolean hasConditions() {
        return this.ifNotExists || this.columnConditions != null && !this.columnConditions.isEmpty();
    }

    @Override
    public ResultMessage execute(QueryState queryState, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        if (options.getConsistency() == null) {
            throw new InvalidRequestException("Invalid empty consistency level");
        }
        return this.hasConditions() ? this.executeWithCondition(queryState, options) : this.executeWithoutCondition(queryState, options);
    }

    private ResultMessage executeWithoutCondition(QueryState queryState, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        ConsistencyLevel cl = options.getConsistency();
        if (this.isCounter()) {
            cl.validateCounterForWrite(this.cfm);
        } else {
            cl.validateForWrite(this.cfm.ksName);
        }
        Collection<? extends IMutation> mutations = this.getMutations(options.getValues(), false, cl, queryState.getTimestamp(), false);
        if (!mutations.isEmpty()) {
            StorageProxy.mutateWithTriggers(mutations, cl, false);
        }
        return null;
    }

    public ResultMessage executeWithCondition(QueryState queryState, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        List<ByteBuffer> variables = options.getValues();
        List<ByteBuffer> keys = this.buildPartitionKeyNames(variables);
        if (keys.size() > 1) {
            throw new InvalidRequestException("IN on the partition key is not supported with conditional updates");
        }
        ColumnNameBuilder clusteringPrefix = this.createClusteringPrefixBuilder(variables);
        UpdateParameters params = new UpdateParameters(this.cfm, variables, this.getTimestamp(queryState.getTimestamp(), variables), this.getTimeToLive(variables), null);
        ByteBuffer key = keys.get(0);
        ThriftValidation.validateKey(this.cfm, key);
        ColumnFamily updates = this.updateForKey(key, clusteringPrefix, params);
        ColumnFamily expected = this.buildConditions(key, clusteringPrefix, params);
        ColumnFamily result = StorageProxy.cas(this.keyspace(), this.columnFamily(), key, clusteringPrefix, expected, updates, options.getSerialConsistency(), options.getConsistency());
        return new ResultMessage.Rows(this.buildCasResultSet(key, result));
    }

    private ResultSet buildCasResultSet(ByteBuffer key, ColumnFamily cf) throws InvalidRequestException {
        boolean success = cf == null;
        ColumnSpecification spec = new ColumnSpecification(this.keyspace(), this.columnFamily(), CAS_RESULT_COLUMN, BooleanType.instance);
        ResultSet.Metadata metadata = new ResultSet.Metadata(Collections.singletonList(spec));
        List<List<ByteBuffer>> rows = Collections.singletonList(Collections.singletonList(BooleanType.instance.decompose(success)));
        ResultSet rs = new ResultSet(metadata, rows);
        return success ? rs : ModificationStatement.merge(rs, this.buildCasFailureResultSet(key, cf));
    }

    private static ResultSet merge(ResultSet left, ResultSet right) {
        if (left.size() == 0) {
            return right;
        }
        if (right.size() == 0) {
            return left;
        }
        assert (left.size() == 1 && right.size() == 1);
        int size = left.metadata.names.size() + right.metadata.names.size();
        ArrayList<ColumnSpecification> specs = new ArrayList<ColumnSpecification>(size);
        specs.addAll(left.metadata.names);
        specs.addAll(right.metadata.names);
        ArrayList row = new ArrayList(size);
        row.addAll(left.rows.get(0));
        row.addAll(right.rows.get(0));
        return new ResultSet(new ResultSet.Metadata(specs), Collections.singletonList(row));
    }

    private ResultSet buildCasFailureResultSet(ByteBuffer key, ColumnFamily cf) throws InvalidRequestException {
        Selection selection;
        CFDefinition cfDef = this.cfm.getCfDef();
        if (this.ifNotExists) {
            selection = Selection.wildcard(cfDef);
        } else {
            ArrayList<CFDefinition.Name> names = new ArrayList<CFDefinition.Name>(this.columnConditions.size());
            for (Operation condition : this.columnConditions) {
                names.add(cfDef.get(condition.columnName));
            }
            selection = Selection.forColumns(names);
        }
        long now = System.currentTimeMillis();
        Selection.ResultSetBuilder builder = selection.resultSetBuilder(now);
        SelectStatement.forSelection(cfDef, selection).processColumnFamily(key, cf, Collections.emptyList(), Integer.MAX_VALUE, now, builder);
        return builder.build();
    }

    @Override
    public ResultMessage executeInternal(QueryState queryState) throws RequestValidationException, RequestExecutionException {
        if (this.hasConditions()) {
            throw new UnsupportedOperationException();
        }
        for (IMutation iMutation : this.getMutations(Collections.emptyList(), true, null, queryState.getTimestamp(), false)) {
            iMutation.apply();
        }
        return null;
    }

    public Collection<? extends IMutation> getMutations(List<ByteBuffer> variables, boolean local, ConsistencyLevel cl, long now, boolean isBatch) throws RequestExecutionException, RequestValidationException {
        List<ByteBuffer> keys = this.buildPartitionKeyNames(variables);
        ColumnNameBuilder clusteringPrefix = this.createClusteringPrefixBuilder(variables);
        Map<ByteBuffer, ColumnGroupMap> rows = this.readRequiredRows(keys, clusteringPrefix, local, cl);
        UpdateParameters params = new UpdateParameters(this.cfm, variables, this.getTimestamp(now, variables), this.getTimeToLive(variables), rows);
        ArrayList<IMutation> mutations = new ArrayList<IMutation>();
        for (ByteBuffer key : keys) {
            ThriftValidation.validateKey(this.cfm, key);
            ColumnFamily cf = this.updateForKey(key, clusteringPrefix, params);
            mutations.add(this.makeMutation(key, cf, cl, isBatch));
        }
        return mutations;
    }

    private IMutation makeMutation(ByteBuffer key, ColumnFamily cf, ConsistencyLevel cl, boolean isBatch) {
        RowMutation rm;
        if (isBatch) {
            rm = new RowMutation(this.cfm.ksName, key);
            rm.add(cf);
        } else {
            rm = new RowMutation(this.cfm.ksName, key, cf);
        }
        return this.isCounter() ? new CounterMutation(rm, cl) : rm;
    }

    private ColumnFamily buildConditions(ByteBuffer key, ColumnNameBuilder clusteringPrefix, UpdateParameters params) throws InvalidRequestException {
        if (this.ifNotExists) {
            return null;
        }
        TreeMapBackedSortedColumns cf = TreeMapBackedSortedColumns.factory.create(this.cfm);
        CFDefinition cfDef = this.cfm.getCfDef();
        if (cfDef.isComposite && !cfDef.isCompact && !this.cfm.isSuper()) {
            ByteBuffer name = clusteringPrefix.copy().add(ByteBufferUtil.EMPTY_BYTE_BUFFER).build();
            cf.addColumn(params.makeColumn(name, ByteBufferUtil.EMPTY_BYTE_BUFFER));
        }
        for (Operation condition : this.columnConditions) {
            condition.execute(key, cf, clusteringPrefix.copy(), params);
        }
        assert (!cf.isEmpty());
        return cf;
    }

    public static abstract class Parsed
    extends CFStatement {
        protected final Attributes.Raw attrs;
        private final List<Pair<ColumnIdentifier, Operation.RawUpdate>> conditions;
        private final boolean ifNotExists;

        protected Parsed(CFName name, Attributes.Raw attrs, List<Pair<ColumnIdentifier, Operation.RawUpdate>> conditions, boolean ifNotExists) {
            super(name);
            this.attrs = attrs;
            this.conditions = conditions == null ? Collections.emptyList() : conditions;
            this.ifNotExists = ifNotExists;
        }

        @Override
        public ParsedStatement.Prepared prepare() throws InvalidRequestException {
            ColumnSpecification[] boundNames = new ColumnSpecification[this.getBoundsTerms()];
            ModificationStatement statement = this.prepare(boundNames);
            return new ParsedStatement.Prepared(statement, Arrays.asList(boundNames));
        }

        public ModificationStatement prepare(ColumnSpecification[] boundNames) throws InvalidRequestException {
            CFMetaData metadata = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
            CFDefinition cfDef = metadata.getCfDef();
            Attributes preparedAttributes = this.attrs.prepare(this.keyspace(), this.columnFamily());
            preparedAttributes.collectMarkerSpecification(boundNames);
            ModificationStatement stmt = this.prepareInternal(cfDef, boundNames, preparedAttributes);
            if (this.ifNotExists || this.conditions != null && !this.conditions.isEmpty()) {
                if (stmt.isCounter()) {
                    throw new InvalidRequestException("Conditional updates are not supported on counter tables");
                }
                if (this.attrs.timestamp != null) {
                    throw new InvalidRequestException("Cannot provide custom timestamp for conditional update");
                }
                if (this.ifNotExists) {
                    assert (this.conditions.isEmpty());
                    stmt.setIfNotExistCondition();
                } else {
                    for (Pair<ColumnIdentifier, Operation.RawUpdate> entry : this.conditions) {
                        CFDefinition.Name name = cfDef.get((ColumnIdentifier)entry.left);
                        if (name == null) {
                            throw new InvalidRequestException(String.format("Unknown identifier %s", entry.left));
                        }
                        if (name.type instanceof ListType) {
                            throw new InvalidRequestException(String.format("List operation (%s) are not allowed in conditional updates", name));
                        }
                        Operation condition = ((Operation.RawUpdate)entry.right).prepare(name);
                        assert (!condition.requiresRead());
                        condition.collectMarkerSpecification(boundNames);
                        switch (name.kind) {
                            case KEY_ALIAS: 
                            case COLUMN_ALIAS: {
                                throw new InvalidRequestException(String.format("PRIMARY KEY part %s found in SET part", entry.left));
                            }
                            case VALUE_ALIAS: 
                            case COLUMN_METADATA: {
                                stmt.addCondition(condition);
                            }
                        }
                    }
                }
            }
            return stmt;
        }

        protected abstract ModificationStatement prepareInternal(CFDefinition var1, ColumnSpecification[] var2, Attributes var3) throws InvalidRequestException;
    }
}

