/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.transport.messages.ResultMessage;

public class DropIndexStatement
extends SchemaAlteringStatement {
    public final String indexName;
    public final boolean ifExists;

    public DropIndexStatement(String indexName, boolean ifExists) {
        super(new CFName());
        this.indexName = indexName;
        this.ifExists = ifExists;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        CFMetaData cfm = this.findIndexedCF();
        if (cfm == null) {
            return;
        }
        state.hasColumnFamilyAccess(cfm.ksName, cfm.cfName, Permission.ALTER);
    }

    @Override
    public void validate(ClientState state) {
    }

    @Override
    public ResultMessage.SchemaChange.Change changeType() {
        return ResultMessage.SchemaChange.Change.UPDATED;
    }

    @Override
    public void announceMigration() throws InvalidRequestException, ConfigurationException {
        CFMetaData cfm = this.findIndexedCF();
        if (cfm == null) {
            return;
        }
        CFMetaData updatedCfm = this.updateCFMetadata(cfm);
        MigrationManager.announceColumnFamilyUpdate(updatedCfm, false);
    }

    private CFMetaData updateCFMetadata(CFMetaData cfm) {
        ColumnDefinition column = this.findIndexedColumn(cfm);
        assert (column != null);
        CFMetaData cloned = cfm.clone();
        ColumnDefinition toChange = cloned.getColumnDefinition(column.name);
        assert (toChange.getIndexName() != null && toChange.getIndexName().equals(this.indexName));
        toChange.setIndexName(null);
        toChange.setIndexType(null, null);
        return cloned;
    }

    private CFMetaData findIndexedCF() throws InvalidRequestException {
        KSMetaData ksm = Schema.instance.getKSMetaData(this.keyspace());
        for (CFMetaData cfm : ksm.cfMetaData().values()) {
            if (this.findIndexedColumn(cfm) == null) continue;
            return cfm;
        }
        if (this.ifExists) {
            return null;
        }
        throw new InvalidRequestException("Index '" + this.indexName + "' could not be found in any of the column families of keyspace '" + this.keyspace() + "'");
    }

    private ColumnDefinition findIndexedColumn(CFMetaData cfm) {
        for (ColumnDefinition column : cfm.allColumns()) {
            if (column.getIndexType() == null || column.getIndexName() == null || !column.getIndexName().equals(this.indexName)) continue;
            return column;
        }
        return null;
    }
}

