/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.streaming.StreamResultFuture;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.utils.UUIDGen;

public class StreamPlan {
    private final UUID planId = UUIDGen.getTimeUUID();
    private final String description;
    private final Map<InetAddress, StreamSession> sessions = new HashMap<InetAddress, StreamSession>();
    private boolean flushBeforeTransfer = true;

    public StreamPlan(String description) {
        this.description = description;
    }

    public StreamPlan requestRanges(InetAddress from, String keyspace, Collection<Range<Token>> ranges) {
        return this.requestRanges(from, keyspace, ranges, new String[0]);
    }

    public StreamPlan requestRanges(InetAddress from, String keyspace, Collection<Range<Token>> ranges, String ... columnFamilies) {
        StreamSession session = this.getOrCreateSession(from);
        session.addStreamRequest(keyspace, ranges, Arrays.asList(columnFamilies));
        return this;
    }

    public StreamPlan transferRanges(InetAddress to, String keyspace, Collection<Range<Token>> ranges) {
        return this.transferRanges(to, keyspace, ranges, new String[0]);
    }

    public StreamPlan transferRanges(InetAddress to, String keyspace, Collection<Range<Token>> ranges, String ... columnFamilies) {
        StreamSession session = this.getOrCreateSession(to);
        session.addTransferRanges(keyspace, ranges, Arrays.asList(columnFamilies), this.flushBeforeTransfer);
        return this;
    }

    public StreamPlan transferFiles(InetAddress to, Collection<Range<Token>> ranges, Collection<SSTableReader> sstables) {
        StreamSession session = this.getOrCreateSession(to);
        session.addTransferFiles(ranges, sstables);
        return this;
    }

    public boolean isEmpty() {
        return this.sessions.isEmpty();
    }

    public StreamResultFuture execute() {
        return StreamResultFuture.init(this.planId, this.description, this.sessions.values());
    }

    public StreamPlan flushBeforeTransfer(boolean flushBeforeTransfer) {
        this.flushBeforeTransfer = flushBeforeTransfer;
        return this;
    }

    private StreamSession getOrCreateSession(InetAddress peer) {
        StreamSession session = this.sessions.get(peer);
        if (session == null) {
            session = new StreamSession(peer);
            this.sessions.put(peer, session);
        }
        return session;
    }
}

