/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.service.RangeTransfer;
import org.apache.cassandra.service.RangeTransferThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledRangeTransferExecutorService {
    private static final Logger LOG = LoggerFactory.getLogger(ScheduledRangeTransferExecutorService.class);
    private static final int INTERVAL = 10;
    private ScheduledExecutorService scheduler;

    public void setup() {
        if (DatabaseDescriptor.getNumTokens() == 1) {
            LOG.warn("Cannot start range transfer scheduler: endpoint is not virtual nodes-enabled");
            return;
        }
        this.scheduler = Executors.newSingleThreadScheduledExecutor(new RangeTransferThreadFactory());
        this.scheduler.scheduleWithFixedDelay(new RangeTransfer(), 0L, 10L, TimeUnit.SECONDS);
        LOG.info("Enabling scheduled transfers of token ranges");
    }

    public void tearDown() {
        if (this.scheduler == null) {
            LOG.warn("Unabled to shutdown; Scheduler never enabled");
            return;
        }
        LOG.info("Shutting down range transfer scheduler");
        this.scheduler.shutdownNow();
    }
}

