/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.UUIDGen;

public class UUIDSerializer
implements TypeSerializer<UUID> {
    public static final UUIDSerializer instance = new UUIDSerializer();

    @Override
    public UUID serialize(ByteBuffer bytes) {
        return UUIDGen.getUUID(bytes);
    }

    @Override
    public ByteBuffer deserialize(UUID value) {
        return ByteBuffer.wrap(UUIDGen.decompose(value));
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        if (bytes.remaining() != 16 && bytes.remaining() != 0) {
            throw new MarshalException(String.format("UUID should be 16 or 0 bytes (%d)", bytes.remaining()));
        }
    }

    @Override
    public String getString(ByteBuffer bytes) {
        if (bytes.remaining() == 0) {
            return "";
        }
        if (bytes.remaining() != 16) {
            throw new MarshalException("UUIDs must be exactly 16 bytes");
        }
        UUID uuid = UUIDGen.getUUID(bytes);
        return uuid.toString();
    }

    @Override
    public String toString(UUID value) {
        return value.toString();
    }

    @Override
    public Class<UUID> getType() {
        return UUID.class;
    }
}

