/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class TimestampSerializer
implements TypeSerializer<Date> {
    public static final String[] iso8601Patterns = new String[]{"yyyy-MM-dd HH:mm", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mmZ", "yyyy-MM-dd HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd'T'HH:mmZ", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd", "yyyy-MM-ddZ"};
    static final String DEFAULT_FORMAT = iso8601Patterns[3];
    static final ThreadLocal<SimpleDateFormat> FORMATTER = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat(DEFAULT_FORMAT);
        }
    };
    public static final TimestampSerializer instance = new TimestampSerializer();

    @Override
    public Date serialize(ByteBuffer bytes) {
        return bytes.remaining() > 0 ? new Date(ByteBufferUtil.toLong(bytes)) : null;
    }

    @Override
    public ByteBuffer deserialize(Date value) {
        return value == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : ByteBufferUtil.bytes(value.getTime());
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        if (bytes.remaining() != 8 && bytes.remaining() != 0) {
            throw new MarshalException(String.format("Expected 8 or 0 byte long for date (%d)", bytes.remaining()));
        }
    }

    @Override
    public String getString(ByteBuffer bytes) {
        if (bytes.remaining() == 0) {
            return "";
        }
        if (bytes.remaining() != 8) {
            throw new MarshalException("A date is exactly 8 bytes (stored as a long): " + bytes.remaining());
        }
        return FORMATTER.get().format(new Date(ByteBufferUtil.toLong(bytes)));
    }

    @Override
    public String toString(Date value) {
        return FORMATTER.get().format(value);
    }

    @Override
    public Class<Date> getType() {
        return Date.class;
    }
}

