/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;

public class SetSerializer<T>
extends CollectionSerializer<Set<T>> {
    private static final Map<TypeSerializer<?>, SetSerializer> instances = new HashMap();
    public final TypeSerializer<T> elements;

    public static synchronized <T> SetSerializer<T> getInstance(TypeSerializer<T> elements) {
        SetSerializer<T> t = instances.get(elements);
        if (t == null) {
            t = new SetSerializer<T>(elements);
            instances.put(elements, t);
        }
        return t;
    }

    private SetSerializer(TypeSerializer<T> elements) {
        this.elements = elements;
    }

    @Override
    public Set<T> serialize(ByteBuffer bytes) {
        try {
            ByteBuffer input = bytes.duplicate();
            int n = SetSerializer.getUnsignedShort(input);
            LinkedHashSet<T> l = new LinkedHashSet<T>(n);
            for (int i = 0; i < n; ++i) {
                int s = SetSerializer.getUnsignedShort(input);
                byte[] data = new byte[s];
                input.get(data);
                ByteBuffer databb = ByteBuffer.wrap(data);
                this.elements.validate(databb);
                l.add(this.elements.serialize(databb));
            }
            return l;
        }
        catch (BufferUnderflowException e) {
            throw new MarshalException("Not enough bytes to read a list");
        }
    }

    @Override
    public ByteBuffer deserialize(Set<T> value) {
        ArrayList<ByteBuffer> bbs = new ArrayList<ByteBuffer>(value.size());
        int size = 0;
        for (T elt : value) {
            ByteBuffer bb = this.elements.deserialize(elt);
            bbs.add(bb);
            size += 2 + bb.remaining();
        }
        return SetSerializer.pack(bbs, value.size(), size);
    }

    @Override
    public String toString(Set<T> value) {
        StringBuffer sb = new StringBuffer();
        boolean isFirst = true;
        for (T element : value) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("; ");
            }
            sb.append(this.elements.toString(element));
        }
        return sb.toString();
    }

    @Override
    public Class<Set<T>> getType() {
        return Set.class;
    }
}

