/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.ByteBuffer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class Int32Serializer
implements TypeSerializer<Integer> {
    public static final Int32Serializer instance = new Int32Serializer();

    @Override
    public Integer serialize(ByteBuffer bytes) {
        return ByteBufferUtil.toInt(bytes);
    }

    @Override
    public ByteBuffer deserialize(Integer value) {
        return value == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : ByteBufferUtil.bytes(value);
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        if (bytes.remaining() != 4 && bytes.remaining() != 0) {
            throw new MarshalException(String.format("Expected 4 or 0 byte int (%d)", bytes.remaining()));
        }
    }

    @Override
    public String getString(ByteBuffer bytes) {
        if (bytes.remaining() == 0) {
            return "";
        }
        if (bytes.remaining() != 4) {
            throw new MarshalException("A int is exactly 4 bytes: " + bytes.remaining());
        }
        return String.valueOf(ByteBufferUtil.toInt(bytes));
    }

    @Override
    public String toString(Integer value) {
        return value == null ? "" : String.valueOf(value);
    }

    @Override
    public Class<Integer> getType() {
        return Integer.class;
    }
}

