/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.GossipDigest;
import org.apache.cassandra.gms.GossipDigestAck;
import org.apache.cassandra.gms.GossipDigestSyn;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GossipDigestSynVerbHandler
implements IVerbHandler<GossipDigestSyn> {
    private static final Logger logger = LoggerFactory.getLogger(GossipDigestSynVerbHandler.class);

    @Override
    public void doVerb(MessageIn<GossipDigestSyn> message, int id) {
        InetAddress from = message.from;
        if (logger.isTraceEnabled()) {
            logger.trace("Received a GossipDigestSynMessage from {}", (Object)from);
        }
        if (!Gossiper.instance.isEnabled()) {
            if (logger.isTraceEnabled()) {
                logger.trace("Ignoring GossipDigestSynMessage because gossip is disabled");
            }
            return;
        }
        GossipDigestSyn gDigestMessage = (GossipDigestSyn)message.payload;
        if (!gDigestMessage.clusterId.equals(DatabaseDescriptor.getClusterName())) {
            logger.warn("ClusterName mismatch from " + from + " " + gDigestMessage.clusterId + "!=" + DatabaseDescriptor.getClusterName());
            return;
        }
        if (gDigestMessage.partioner != null && !gDigestMessage.partioner.equals(DatabaseDescriptor.getPartitionerName())) {
            logger.warn("Partitioner mismatch from " + from + " " + gDigestMessage.partioner + "!=" + DatabaseDescriptor.getPartitionerName());
            return;
        }
        List<GossipDigest> gDigestList = gDigestMessage.getGossipDigests();
        if (logger.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (GossipDigest gDigest : gDigestList) {
                sb.append(gDigest);
                sb.append(" ");
            }
            logger.trace("Gossip syn digests are : " + sb.toString());
        }
        this.doSort(gDigestList);
        ArrayList<GossipDigest> deltaGossipDigestList = new ArrayList<GossipDigest>();
        HashMap<InetAddress, EndpointState> deltaEpStateMap = new HashMap<InetAddress, EndpointState>();
        Gossiper.instance.examineGossiper(gDigestList, deltaGossipDigestList, deltaEpStateMap);
        MessageOut<GossipDigestAck> gDigestAckMessage = new MessageOut<GossipDigestAck>(MessagingService.Verb.GOSSIP_DIGEST_ACK, new GossipDigestAck(deltaGossipDigestList, deltaEpStateMap), GossipDigestAck.serializer);
        if (logger.isTraceEnabled()) {
            logger.trace("Sending a GossipDigestAckMessage to {}", (Object)from);
        }
        MessagingService.instance().sendOneWay(gDigestAckMessage, from);
    }

    private void doSort(List<GossipDigest> gDigestList) {
        HashMap<InetAddress, GossipDigest> epToDigestMap = new HashMap<InetAddress, GossipDigest>();
        for (GossipDigest gDigest : gDigestList) {
            epToDigestMap.put(gDigest.getEndpoint(), gDigest);
        }
        ArrayList<GossipDigest> diffDigests = new ArrayList<GossipDigest>(gDigestList.size());
        for (GossipDigest gDigest : gDigestList) {
            InetAddress ep = gDigest.getEndpoint();
            EndpointState epState = Gossiper.instance.getEndpointStateForEndpoint(ep);
            int version = epState != null ? Gossiper.instance.getMaxEndpointStateVersion(epState) : 0;
            int diffVersion = Math.abs(version - gDigest.getMaxVersion());
            diffDigests.add(new GossipDigest(ep, gDigest.getGeneration(), diffVersion));
        }
        gDigestList.clear();
        Collections.sort(diffDigests);
        int size = diffDigests.size();
        for (int i = size - 1; i >= 0; --i) {
            gDigestList.add((GossipDigest)epToDigestMap.get(((GossipDigest)diffDigests.get(i)).getEndpoint()));
        }
    }
}

