/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.utils.ByteBufferUtil;

public class SuperColumns {
    public static Iterator<OnDiskAtom> onDiskIterator(DataInput in, int superColumnCount, ColumnSerializer.Flag flag, int expireBefore) {
        return new SCIterator(in, superColumnCount, flag, expireBefore);
    }

    public static void serializeSuperColumnFamily(ColumnFamily scf, DataOutput out, int version) throws IOException {
        DeletionInfo delInfo = scf.deletionInfo();
        Map<ByteBuffer, List<Column>> scMap = SuperColumns.groupSuperColumns(scf);
        DeletionInfo.serializer().serialize(new DeletionInfo(delInfo.getTopLevelDeletion()), out, version);
        out.writeInt(scMap.size());
        for (Map.Entry<ByteBuffer, List<Column>> entry : scMap.entrySet()) {
            ByteBufferUtil.writeWithShortLength(entry.getKey(), out);
            List<DeletionTime> delTimes = delInfo.rangeCovering(entry.getKey());
            assert (delTimes.size() <= 1);
            DeletionInfo scDelInfo = delTimes.isEmpty() ? DeletionInfo.LIVE : new DeletionInfo(delTimes.get(0));
            DeletionTime.serializer.serialize(scDelInfo.getTopLevelDeletion(), out);
            out.writeInt(entry.getValue().size());
            for (Column subColumn : entry.getValue()) {
                Column.serializer.serialize(subColumn, out);
            }
        }
    }

    private static Map<ByteBuffer, List<Column>> groupSuperColumns(ColumnFamily scf) {
        CompositeType type = (CompositeType)scf.getComparator();
        LinkedHashMap<ByteBuffer, List<Column>> scMap = new LinkedHashMap<ByteBuffer, List<Column>>();
        ByteBuffer scName = null;
        ArrayList<Column> subColumns = null;
        for (Column column : scf) {
            ByteBuffer newScName = SuperColumns.scName(column.name());
            ByteBuffer newSubName = SuperColumns.subName(column.name());
            if (scName == null || type.types.get(0).compare(scName, newScName) != 0) {
                scName = newScName;
                subColumns = new ArrayList<Column>();
                scMap.put(scName, subColumns);
            }
            subColumns.add(column.withUpdatedName(newSubName));
        }
        return scMap;
    }

    public static void deserializerSuperColumnFamily(DataInput in, ColumnFamily cf, ColumnSerializer.Flag flag, int version) throws IOException {
        cf.delete(DeletionInfo.serializer().deserialize(in, version, cf.getComparator()));
        assert (!cf.deletionInfo().rangeIterator().hasNext());
        Iterator<OnDiskAtom> iter = SuperColumns.onDiskIterator(in, in.readInt(), flag, Integer.MIN_VALUE);
        while (iter.hasNext()) {
            cf.addAtom(iter.next());
        }
    }

    public static long serializedSize(ColumnFamily scf, TypeSizes typeSizes, int version) {
        Map<ByteBuffer, List<Column>> scMap = SuperColumns.groupSuperColumns(scf);
        DeletionInfo delInfo = scf.deletionInfo();
        long size = DeletionInfo.serializer().serializedSize(new DeletionInfo(delInfo.getTopLevelDeletion()), version);
        for (Map.Entry<ByteBuffer, List<Column>> entry : scMap.entrySet()) {
            int nameSize = entry.getKey().remaining();
            size += (long)(typeSizes.sizeof((short)nameSize) + nameSize);
            List<DeletionTime> delTimes = delInfo.rangeCovering(entry.getKey());
            assert (delTimes.size() <= 1);
            DeletionInfo scDelInfo = delTimes.isEmpty() ? DeletionInfo.LIVE : new DeletionInfo(delTimes.get(0));
            size += DeletionTime.serializer.serializedSize(scDelInfo.getTopLevelDeletion(), TypeSizes.NATIVE);
            size += (long)typeSizes.sizeof(entry.getValue().size());
            for (Column subColumn : entry.getValue()) {
                size += Column.serializer.serializedSize(subColumn, typeSizes);
            }
        }
        return size;
    }

    public static AbstractType<?> getComparatorFor(CFMetaData metadata, ByteBuffer superColumn) {
        return SuperColumns.getComparatorFor(metadata, superColumn != null);
    }

    public static AbstractType<?> getComparatorFor(CFMetaData metadata, boolean subColumn) {
        return metadata.isSuper() ? ((CompositeType)metadata.comparator).types.get(subColumn ? 1 : 0) : metadata.comparator;
    }

    public static ByteBuffer scName(ByteBuffer columnName) {
        return CompositeType.extractComponent(columnName, 0);
    }

    public static ByteBuffer subName(ByteBuffer columnName) {
        return CompositeType.extractComponent(columnName, 1);
    }

    public static ByteBuffer startOf(ByteBuffer scName) {
        int length = scName.remaining();
        ByteBuffer bb = ByteBuffer.allocate(2 + length + 1);
        bb.put((byte)(length >> 8 & 0xFF));
        bb.put((byte)(length & 0xFF));
        bb.put(scName.duplicate());
        bb.put((byte)0);
        bb.flip();
        return bb;
    }

    public static ByteBuffer endOf(ByteBuffer scName) {
        ByteBuffer bb = SuperColumns.startOf(scName);
        bb.put(bb.remaining() - 1, (byte)1);
        return bb;
    }

    public static SCFilter filterToSC(CompositeType type, IDiskAtomFilter filter) {
        if (filter instanceof NamesQueryFilter) {
            return SuperColumns.namesFilterToSC(type, (NamesQueryFilter)filter);
        }
        return SuperColumns.sliceFilterToSC(type, (SliceQueryFilter)filter);
    }

    public static SCFilter namesFilterToSC(CompositeType type, NamesQueryFilter filter) {
        ByteBuffer scName = null;
        TreeSet<ByteBuffer> newColumns = new TreeSet<ByteBuffer>(filter.columns.comparator());
        for (ByteBuffer name : filter.columns) {
            ByteBuffer newScName = SuperColumns.scName(name);
            if (scName == null) {
                scName = newScName;
            } else if (type.types.get(0).compare(scName, newScName) != 0) {
                throw new RuntimeException("Cannot convert filter to old super column format. Update all nodes to Cassandra 2.0 first.");
            }
            newColumns.add(SuperColumns.subName(name));
        }
        return new SCFilter(scName, new NamesQueryFilter(newColumns));
    }

    public static SCFilter sliceFilterToSC(CompositeType type, SliceQueryFilter filter) {
        boolean reversed = filter.reversed;
        if (filter.slices.length == 1) {
            ByteBuffer start = filter.slices[0].start;
            ByteBuffer finish = filter.slices[0].start;
            if (filter.compositesToGroup == 1) {
                if (start.remaining() == 0) {
                    if (finish.remaining() == 0) {
                        return new SCFilter(null, new SliceQueryFilter(filter.start(), filter.finish(), reversed, filter.count));
                    }
                    if (SuperColumns.subName(finish) == null && (!reversed && !SuperColumns.firstEndOfComponent(finish) || reversed && SuperColumns.firstEndOfComponent(finish))) {
                        return new SCFilter(null, new SliceQueryFilter(ByteBufferUtil.EMPTY_BYTE_BUFFER, SuperColumns.scName(finish), reversed, filter.count));
                    }
                } else if (finish.remaining() == 0) {
                    if (SuperColumns.subName(start) == null && (!reversed && SuperColumns.firstEndOfComponent(start) || reversed && !SuperColumns.firstEndOfComponent(start))) {
                        return new SCFilter(null, new SliceQueryFilter(SuperColumns.scName(start), ByteBufferUtil.EMPTY_BYTE_BUFFER, reversed, filter.count));
                    }
                } else if (SuperColumns.subName(start) == null && SuperColumns.subName(finish) == null && (reversed && !SuperColumns.firstEndOfComponent(start) && SuperColumns.firstEndOfComponent(finish) || !reversed && SuperColumns.firstEndOfComponent(start) && !SuperColumns.firstEndOfComponent(finish))) {
                    return new SCFilter(null, new SliceQueryFilter(SuperColumns.scName(start), SuperColumns.scName(finish), reversed, filter.count));
                }
            } else if (filter.compositesToGroup == 0 && type.types.get(0).compare(SuperColumns.scName(start), SuperColumns.scName(finish)) == 0) {
                return new SCFilter(SuperColumns.scName(start), filter.withUpdatedSlice(SuperColumns.subName(start), SuperColumns.subName(finish)));
            }
        } else if (!reversed) {
            TreeSet<ByteBuffer> columns = new TreeSet<ByteBuffer>(type.types.get(0));
            for (int i = 0; i < filter.slices.length; ++i) {
                ByteBuffer start = filter.slices[i].start;
                ByteBuffer finish = filter.slices[i].finish;
                if (SuperColumns.subName(start) != null || SuperColumns.subName(finish) != null || type.types.get(0).compare(SuperColumns.scName(start), SuperColumns.scName(finish)) != 0 || SuperColumns.firstEndOfComponent(start) || !SuperColumns.firstEndOfComponent(finish)) {
                    throw new RuntimeException("Cannot convert filter to old super column format. Update all nodes to Cassandra 2.0 first.");
                }
                columns.add(SuperColumns.scName(start));
            }
            return new SCFilter(null, new NamesQueryFilter(columns));
        }
        throw new RuntimeException("Cannot convert filter to old super column format. Update all nodes to Cassandra 2.0 first.");
    }

    public static IDiskAtomFilter fromSCFilter(CompositeType type, ByteBuffer scName, IDiskAtomFilter filter) {
        if (filter instanceof NamesQueryFilter) {
            return SuperColumns.fromSCNamesFilter(type, scName, (NamesQueryFilter)filter);
        }
        return SuperColumns.fromSCSliceFilter(type, scName, (SliceQueryFilter)filter);
    }

    public static IDiskAtomFilter fromSCNamesFilter(CompositeType type, ByteBuffer scName, NamesQueryFilter filter) {
        if (scName == null) {
            ColumnSlice[] slices = new ColumnSlice[filter.columns.size()];
            int i = 0;
            for (ByteBuffer bb : filter.columns) {
                CompositeType.Builder builder = type.builder().add(bb);
                slices[i++] = new ColumnSlice(builder.build(), builder.buildAsEndOfRange());
            }
            return new SliceQueryFilter(slices, false, slices.length, 1);
        }
        TreeSet<ByteBuffer> newColumns = new TreeSet<ByteBuffer>(type);
        for (ByteBuffer c : filter.columns) {
            newColumns.add(CompositeType.build(scName, c));
        }
        return filter.withUpdatedColumns(newColumns);
    }

    public static SliceQueryFilter fromSCSliceFilter(CompositeType type, ByteBuffer scName, SliceQueryFilter filter) {
        ByteBuffer start;
        assert (filter.slices.length == 1);
        if (scName == null) {
            ByteBuffer start2;
            ByteBuffer byteBuffer = filter.start().remaining() == 0 ? filter.start() : (start2 = filter.reversed ? type.builder().add(filter.start()).buildAsEndOfRange() : type.builder().add(filter.start()).build());
            ByteBuffer finish = filter.finish().remaining() == 0 ? filter.finish() : (filter.reversed ? type.builder().add(filter.finish()).build() : type.builder().add(filter.finish()).buildAsEndOfRange());
            return new SliceQueryFilter(start2, finish, filter.reversed, filter.count, 1);
        }
        CompositeType.Builder builder = type.builder().add(scName);
        ByteBuffer byteBuffer = filter.start().remaining() == 0 ? (filter.reversed ? builder.buildAsEndOfRange() : builder.build()) : (start = builder.copy().add(filter.start()).build());
        ByteBuffer end = filter.finish().remaining() == 0 ? (filter.reversed ? builder.build() : builder.buildAsEndOfRange()) : builder.add(filter.finish()).build();
        return new SliceQueryFilter(start, end, filter.reversed, filter.count);
    }

    private static boolean firstEndOfComponent(ByteBuffer bb) {
        bb = bb.duplicate();
        int length = (bb.get() & 0xFF) << 8;
        return bb.get((length |= bb.get() & 0xFF) + 2) == 1;
    }

    public static class SCFilter {
        public final ByteBuffer scName;
        public final IDiskAtomFilter updatedFilter;

        public SCFilter(ByteBuffer scName, IDiskAtomFilter updatedFilter) {
            this.scName = scName;
            this.updatedFilter = updatedFilter;
        }
    }

    private static class SCIterator
    implements Iterator<OnDiskAtom> {
        private final DataInput in;
        private final int scCount;
        private final ColumnSerializer.Flag flag;
        private final int expireBefore;
        private int read;
        private ByteBuffer scName;
        private Iterator<Column> subColumnsIterator;

        private SCIterator(DataInput in, int superColumnCount, ColumnSerializer.Flag flag, int expireBefore) {
            this.in = in;
            this.scCount = superColumnCount;
            this.flag = flag;
            this.expireBefore = expireBefore;
        }

        @Override
        public boolean hasNext() {
            return this.subColumnsIterator != null && this.subColumnsIterator.hasNext() || this.read < this.scCount;
        }

        @Override
        public OnDiskAtom next() {
            try {
                if (this.subColumnsIterator != null && this.subColumnsIterator.hasNext()) {
                    Column c = this.subColumnsIterator.next();
                    return c.withUpdatedName(CompositeType.build(this.scName, c.name()));
                }
                ++this.read;
                this.scName = ByteBufferUtil.readWithShortLength(this.in);
                DeletionInfo delInfo = new DeletionInfo(DeletionTime.serializer.deserialize(this.in));
                assert (!delInfo.rangeIterator().hasNext());
                int size = this.in.readInt();
                ArrayList<Column> subColumns = new ArrayList<Column>(size);
                for (int i = 0; i < size; ++i) {
                    subColumns.add(Column.serializer.deserialize(this.in, this.flag, this.expireBefore));
                }
                this.subColumnsIterator = subColumns.iterator();
                DeletionTime dtime = delInfo.getTopLevelDeletion();
                if (!dtime.equals(DeletionTime.LIVE)) {
                    return new RangeTombstone(SuperColumns.startOf(this.scName), SuperColumns.endOf(this.scName), dtime);
                }
                return this.next();
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

