/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Operation;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.statements.ColumnGroupMap;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.UpdateStatement;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.thrift.ThriftValidation;

public class DeleteStatement
extends ModificationStatement {
    private CFDefinition cfDef;
    private final List<Operation.RawDeletion> deletions;
    private final List<Relation> whereClause;
    private final List<Operation> toRemove;
    private final Map<ColumnIdentifier, List<Term>> processedKeys = new HashMap<ColumnIdentifier, List<Term>>();

    public DeleteStatement(CFName name, List<Operation.RawDeletion> deletions, List<Relation> whereClause, Attributes attrs) {
        super(name, attrs);
        this.deletions = deletions;
        this.whereClause = whereClause;
        this.toRemove = new ArrayList<Operation>(deletions.size());
    }

    @Override
    protected void validateConsistency(ConsistencyLevel cl) throws InvalidRequestException {
        if (this.type == ModificationStatement.Type.COUNTER) {
            cl.validateCounterForWrite(this.cfDef.cfm);
        } else {
            cl.validateForWrite(this.cfDef.cfm.ksName);
        }
    }

    public Collection<RowMutation> getMutations(List<ByteBuffer> variables, boolean local, ConsistencyLevel cl, long now) throws RequestExecutionException, RequestValidationException {
        boolean isRange;
        boolean fullKey;
        List<ByteBuffer> keys = UpdateStatement.buildKeyNames(this.cfDef, this.processedKeys, variables);
        ColumnNameBuilder builder = this.cfDef.getColumnNameBuilder();
        CFDefinition.Name firstEmpty = UpdateStatement.buildColumnNames(this.cfDef, this.processedKeys, builder, variables, false);
        boolean bl = fullKey = builder.componentCount() == this.cfDef.columns.size();
        boolean bl2 = this.cfDef.isCompact ? !fullKey : (isRange = !fullKey || this.toRemove.isEmpty());
        if (!this.toRemove.isEmpty() && isRange) {
            throw new InvalidRequestException(String.format("Missing mandatory PRIMARY KEY part %s since %s specified", firstEmpty, this.toRemove.get((int)0).columnName));
        }
        TreeSet<ByteBuffer> toRead = null;
        for (Operation op : this.toRemove) {
            if (!op.requiresRead()) continue;
            if (toRead == null) {
                toRead = new TreeSet<ByteBuffer>(UTF8Type.instance);
            }
            toRead.add(op.columnName.key);
        }
        Map<ByteBuffer, ColumnGroupMap> rows = toRead != null ? this.readRows(keys, builder, toRead, (CompositeType)this.cfDef.cfm.comparator, local, cl) : null;
        ArrayList<RowMutation> rowMutations = new ArrayList<RowMutation>(keys.size());
        UpdateParameters params = new UpdateParameters(variables, this.getTimestamp(now), -1, rows);
        for (ByteBuffer key : keys) {
            rowMutations.add(this.mutationForKey(this.cfDef, key, builder, isRange, params));
        }
        return rowMutations;
    }

    public RowMutation mutationForKey(CFDefinition cfDef, ByteBuffer key, ColumnNameBuilder builder, boolean isRange, UpdateParameters params) throws InvalidRequestException {
        QueryProcessor.validateKey(key);
        RowMutation rm = new RowMutation(cfDef.cfm.ksName, key);
        ColumnFamily cf = rm.addOrGet(cfDef.cfm);
        if (this.toRemove.isEmpty() && builder.componentCount() == 0) {
            cf.delete(new DeletionInfo(params.timestamp, params.localDeletionTime));
        } else if (isRange) {
            assert (this.toRemove.isEmpty());
            ByteBuffer start = builder.build();
            ByteBuffer end = builder.buildAsEndOfRange();
            cf.addAtom(params.makeRangeTombstone(start, end));
        } else if (cfDef.isCompact) {
            ByteBuffer columnName = builder.build();
            cf.addColumn(params.makeTombstone(columnName));
        } else {
            for (Operation op : this.toRemove) {
                op.execute(key, cf, builder.copy(), params);
            }
        }
        return rm;
    }

    @Override
    public ParsedStatement.Prepared prepare(ColumnSpecification[] boundNames) throws InvalidRequestException {
        CFMetaData metadata = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
        this.type = metadata.getDefaultValidator().isCommutative() ? ModificationStatement.Type.COUNTER : ModificationStatement.Type.LOGGED;
        this.cfDef = metadata.getCfDef();
        UpdateStatement.processKeys(this.cfDef, this.whereClause, this.processedKeys, boundNames);
        for (Operation.RawDeletion deletion : this.deletions) {
            CFDefinition.Name name = this.cfDef.get(deletion.affectedColumn());
            if (name == null) {
                throw new InvalidRequestException(String.format("Unknown identifier %s", deletion.affectedColumn()));
            }
            if (name.kind != CFDefinition.Name.Kind.COLUMN_METADATA && name.kind != CFDefinition.Name.Kind.VALUE_ALIAS) {
                throw new InvalidRequestException(String.format("Invalid identifier %s for deletion (should not be a PRIMARY KEY part)", name));
            }
            Operation op = deletion.prepare(name);
            op.collectMarkerSpecification(boundNames);
            this.toRemove.add(op);
        }
        return new ParsedStatement.Prepared(this, Arrays.asList(boundNames));
    }

    @Override
    public ParsedStatement.Prepared prepare() throws InvalidRequestException {
        ColumnSpecification[] boundNames = new ColumnSpecification[this.getBoundsTerms()];
        return this.prepare(boundNames);
    }

    public String toString() {
        return String.format("DeleteStatement(name=%s, columns=%s, keys=%s)", this.cfName, this.deletions, this.whereClause);
    }
}

