/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnIndex;
import org.apache.cassandra.db.CounterColumn;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.IColumnSerializer;
import org.apache.cassandra.io.compress.CompressedSequentialWriter;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.IndexSummaryBuilder;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableMetadata;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.io.util.FileMark;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.SegmentedFile;
import org.apache.cassandra.io.util.SequentialWriter;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FilterFactory;
import org.apache.cassandra.utils.Hex;
import org.apache.cassandra.utils.IFilter;
import org.apache.cassandra.utils.StreamingHistogram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSTableWriter
extends SSTable {
    private static final Logger logger = LoggerFactory.getLogger(SSTableWriter.class);
    private IndexWriter iwriter;
    private SegmentedFile.Builder dbuilder;
    private final SequentialWriter dataFile;
    private DecoratedKey lastWrittenKey;
    private FileMark dataMark;
    private final SSTableMetadata.Collector sstableMetadataCollector;

    public SSTableWriter(String filename, long keyCount) {
        this(filename, keyCount, Schema.instance.getCFMetaData(Descriptor.fromFilename(filename)), StorageService.getPartitioner(), SSTableMetadata.createCollector());
    }

    private static Set<Component> components(CFMetaData metadata) {
        HashSet<Component> components = new HashSet<Component>(Arrays.asList(Component.DATA, Component.PRIMARY_INDEX, Component.STATS, Component.SUMMARY, Component.TOC));
        if (metadata.getBloomFilterFpChance() < 1.0) {
            components.add(Component.FILTER);
        }
        if (metadata.compressionParameters().sstableCompressor != null) {
            components.add(Component.COMPRESSION_INFO);
        } else {
            components.add(Component.DIGEST);
        }
        return components;
    }

    public SSTableWriter(String filename, long keyCount, CFMetaData metadata, IPartitioner<?> partitioner, SSTableMetadata.Collector sstableMetadataCollector) {
        super(Descriptor.fromFilename(filename), SSTableWriter.components(metadata), metadata, partitioner);
        this.iwriter = new IndexWriter(keyCount);
        if (this.compression) {
            this.dbuilder = SegmentedFile.getCompressedBuilder();
            this.dataFile = CompressedSequentialWriter.open(this.getFilename(), this.descriptor.filenameFor(Component.COMPRESSION_INFO), !metadata.populateIoCacheOnFlush(), metadata.compressionParameters(), sstableMetadataCollector);
        } else {
            this.dbuilder = SegmentedFile.getBuilder(DatabaseDescriptor.getDiskAccessMode());
            this.dataFile = SequentialWriter.open(new File(this.getFilename()), !metadata.populateIoCacheOnFlush());
            this.dataFile.setComputeDigest();
        }
        this.sstableMetadataCollector = sstableMetadataCollector;
    }

    public void mark() {
        this.dataMark = this.dataFile.mark();
        this.iwriter.mark();
    }

    public void resetAndTruncate() {
        this.dataFile.resetAndTruncate(this.dataMark);
        this.iwriter.resetAndTruncate();
    }

    private long beforeAppend(DecoratedKey decoratedKey) {
        assert (decoratedKey != null) : "Keys must not be null";
        if (this.lastWrittenKey != null && this.lastWrittenKey.compareTo(decoratedKey) >= 0) {
            throw new RuntimeException("Last written key " + this.lastWrittenKey + " >= current key " + decoratedKey + " writing into " + this.getFilename());
        }
        return this.lastWrittenKey == null ? 0L : this.dataFile.getFilePointer();
    }

    private RowIndexEntry afterAppend(DecoratedKey decoratedKey, long dataPosition, DeletionInfo delInfo, ColumnIndex index) {
        this.last = this.lastWrittenKey = decoratedKey;
        if (this.first == null) {
            this.first = this.lastWrittenKey;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("wrote " + decoratedKey + " at " + dataPosition);
        }
        RowIndexEntry entry = RowIndexEntry.create(dataPosition, delInfo.getTopLevelDeletion(), index);
        this.iwriter.append(decoratedKey, entry);
        this.dbuilder.addPotentialBoundary(dataPosition);
        return entry;
    }

    public RowIndexEntry append(AbstractCompactedRow row) {
        long currentPosition = this.beforeAppend(row.key);
        try {
            ByteBufferUtil.writeWithShortLength(row.key.key, this.dataFile.stream);
            long dataStart = this.dataFile.getFilePointer();
            long dataSize = row.write(this.dataFile.stream);
            assert (dataSize == this.dataFile.getFilePointer() - (dataStart + 8L)) : "incorrect row data size " + dataSize + " written to " + this.dataFile.getPath() + "; correct is " + (this.dataFile.getFilePointer() - (dataStart + 8L));
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.dataFile.getPath());
        }
        this.sstableMetadataCollector.update(this.dataFile.getFilePointer() - currentPosition, row.columnStats());
        return this.afterAppend(row.key, currentPosition, row.deletionInfo(), row.index());
    }

    public void append(DecoratedKey decoratedKey, ColumnFamily cf) {
        long startPosition = this.beforeAppend(decoratedKey);
        try {
            ByteBufferUtil.writeWithShortLength(decoratedKey.key, this.dataFile.stream);
            DataOutputBuffer buffer = new DataOutputBuffer();
            ColumnIndex.Builder builder = new ColumnIndex.Builder(cf, decoratedKey.key, buffer);
            ColumnIndex index = builder.build(cf);
            TypeSizes typeSizes = TypeSizes.NATIVE;
            long delSize = DeletionTime.serializer.serializedSize(cf.deletionInfo().getTopLevelDeletion(), typeSizes);
            this.dataFile.stream.writeLong((long)buffer.getLength() + delSize + (long)typeSizes.sizeof(0));
            DeletionInfo.serializer().serializeForSSTable(cf.deletionInfo(), (DataOutput)this.dataFile.stream);
            this.dataFile.stream.writeInt(builder.writtenAtomCount());
            this.dataFile.stream.write(buffer.getData(), 0, buffer.getLength());
            this.afterAppend(decoratedKey, startPosition, cf.deletionInfo(), index);
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.dataFile.getPath());
        }
        this.sstableMetadataCollector.update(this.dataFile.getFilePointer() - startPosition, cf.getColumnStats());
    }

    public long appendFromStream(DecoratedKey key, CFMetaData metadata, long dataSize, DataInput in) throws IOException {
        long dataStart;
        long currentPosition = this.beforeAppend(key);
        try {
            ByteBufferUtil.writeWithShortLength(key.key, this.dataFile.stream);
            dataStart = this.dataFile.getFilePointer();
            this.dataFile.stream.writeLong(dataSize);
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.dataFile.getPath());
        }
        DeletionInfo deletionInfo = DeletionInfo.serializer().deserializeFromSSTable(in, this.descriptor.version);
        int columnCount = in.readInt();
        try {
            DeletionInfo.serializer().serializeForSSTable(deletionInfo, (DataOutput)this.dataFile.stream);
            this.dataFile.stream.writeInt(columnCount);
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.dataFile.getPath());
        }
        long minTimestamp = Long.MAX_VALUE;
        long maxTimestamp = Long.MIN_VALUE;
        StreamingHistogram tombstones = new StreamingHistogram(100);
        ColumnFamily cf = ColumnFamily.create(metadata, ArrayBackedSortedColumns.factory());
        cf.delete(deletionInfo);
        ColumnIndex.Builder columnIndexer = new ColumnIndex.Builder(cf, key.key, this.dataFile.stream, true);
        OnDiskAtom.Serializer atomSerializer = cf.getOnDiskSerializer();
        for (int i = 0; i < columnCount; ++i) {
            OnDiskAtom atom = atomSerializer.deserializeFromSSTable(in, IColumnSerializer.Flag.PRESERVE_SIZE, Integer.MIN_VALUE, Descriptor.Version.CURRENT);
            if (atom instanceof CounterColumn) {
                atom = ((CounterColumn)atom).markDeltaToBeCleared();
            } else if (atom instanceof SuperColumn) {
                SuperColumn sc = (SuperColumn)atom;
                for (IColumn subColumn : sc.getSubColumns()) {
                    if (!(subColumn instanceof CounterColumn)) continue;
                    IColumn marked = ((CounterColumn)subColumn).markDeltaToBeCleared();
                    sc.replace(subColumn, marked);
                }
            }
            int deletionTime = atom.getLocalDeletionTime();
            if (deletionTime < Integer.MAX_VALUE) {
                tombstones.update(deletionTime);
            }
            minTimestamp = Math.min(minTimestamp, atom.minTimestamp());
            maxTimestamp = Math.max(maxTimestamp, atom.maxTimestamp());
            try {
                columnIndexer.add(atom);
                continue;
            }
            catch (IOException e) {
                throw new FSWriteError((Throwable)e, this.dataFile.getPath());
            }
        }
        assert (dataSize == this.dataFile.getFilePointer() - (dataStart + 8L)) : "incorrect row data size " + dataSize + " written to " + this.dataFile.getPath() + "; correct is " + (this.dataFile.getFilePointer() - (dataStart + 8L));
        this.sstableMetadataCollector.updateMinTimestamp(minTimestamp);
        this.sstableMetadataCollector.updateMaxTimestamp(maxTimestamp);
        this.sstableMetadataCollector.addRowSize(this.dataFile.getFilePointer() - currentPosition);
        this.sstableMetadataCollector.addColumnCount(columnCount);
        this.sstableMetadataCollector.mergeTombstoneHistogram(tombstones);
        this.afterAppend(key, currentPosition, deletionInfo, columnIndexer.build());
        return currentPosition;
    }

    public void abort() {
        assert (this.descriptor.temporary);
        FileUtils.closeQuietly(this.iwriter);
        FileUtils.closeQuietly(this.dataFile);
        Set<Component> components = SSTable.componentsFor(this.descriptor);
        try {
            if (!components.isEmpty()) {
                SSTable.delete(this.descriptor, components);
            }
        }
        catch (FSWriteError e) {
            logger.error(String.format("Failed deleting temp components for %s", this.descriptor), (Throwable)e);
            throw e;
        }
    }

    public SSTableReader closeAndOpenReader() {
        return this.closeAndOpenReader(System.currentTimeMillis());
    }

    public SSTableReader closeAndOpenReader(long maxDataAge) {
        this.iwriter.close();
        this.dataFile.close();
        SSTableMetadata sstableMetadata = this.sstableMetadataCollector.finalizeMetadata(this.partitioner.getClass().getCanonicalName());
        SSTableWriter.writeMetadata(this.descriptor, sstableMetadata);
        this.maybeWriteDigest();
        SSTable.appendTOC(this.descriptor, this.components);
        Descriptor newdesc = SSTableWriter.rename(this.descriptor, this.components);
        SegmentedFile ifile = this.iwriter.builder.complete(newdesc.filenameFor(SSTable.COMPONENT_INDEX));
        SegmentedFile dfile = this.dbuilder.complete(newdesc.filenameFor(SSTable.COMPONENT_DATA));
        SSTableReader sstable = SSTableReader.internalOpen(newdesc, this.components, this.metadata, this.partitioner, ifile, dfile, this.iwriter.summary.build(this.partitioner), this.iwriter.bf, maxDataAge, sstableMetadata);
        sstable.first = SSTableWriter.getMinimalKey(this.first);
        sstable.last = SSTableWriter.getMinimalKey(this.last);
        SSTableReader.saveSummary(sstable, this.iwriter.builder, this.dbuilder);
        this.iwriter = null;
        this.dbuilder = null;
        return sstable;
    }

    private void maybeWriteDigest() {
        byte[] digest = this.dataFile.digest();
        if (digest == null) {
            return;
        }
        SequentialWriter out = SequentialWriter.open(new File(this.descriptor.filenameFor(SSTable.COMPONENT_DIGEST)), true);
        Descriptor newdesc = this.descriptor.asTemporary(false);
        String[] tmp = newdesc.filenameFor(SSTable.COMPONENT_DATA).split(Pattern.quote(File.separator));
        String dataFileName = tmp[tmp.length - 1];
        try {
            out.write(String.format("%s  %s", Hex.bytesToHex(digest), dataFileName).getBytes());
        }
        catch (ClosedChannelException e) {
            throw new AssertionError();
        }
        out.close();
    }

    private static void writeMetadata(Descriptor desc, SSTableMetadata sstableMetadata) {
        SequentialWriter out = SequentialWriter.open(new File(desc.filenameFor(SSTable.COMPONENT_STATS)), true);
        try {
            SSTableMetadata.serializer.serialize(sstableMetadata, out.stream);
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, out.getPath());
        }
        out.close();
    }

    static Descriptor rename(Descriptor tmpdesc, Set<Component> components) {
        Descriptor newdesc = tmpdesc.asTemporary(false);
        SSTableWriter.rename(tmpdesc, newdesc, components);
        return newdesc;
    }

    public static void rename(Descriptor tmpdesc, Descriptor newdesc, Set<Component> components) {
        for (Component component : Sets.difference(components, (Set)Sets.newHashSet((Object[])new Component[]{Component.DATA, Component.SUMMARY}))) {
            FileUtils.renameWithConfirm(tmpdesc.filenameFor(component), newdesc.filenameFor(component));
        }
        FileUtils.renameWithConfirm(tmpdesc.filenameFor(Component.DATA), newdesc.filenameFor(Component.DATA));
        FileUtils.renameWithOutConfirm(tmpdesc.filenameFor(Component.SUMMARY), newdesc.filenameFor(Component.SUMMARY));
    }

    public long getFilePointer() {
        return this.dataFile.getFilePointer();
    }

    public long getOnDiskFilePointer() {
        return this.dataFile.getOnDiskFilePointer();
    }

    class IndexWriter
    implements Closeable {
        private final SequentialWriter indexFile;
        public final SegmentedFile.Builder builder;
        public final IndexSummaryBuilder summary;
        public final IFilter bf;
        private FileMark mark;

        IndexWriter(long keyCount) {
            this.indexFile = SequentialWriter.open(new File(SSTableWriter.this.descriptor.filenameFor(SSTable.COMPONENT_INDEX)), !SSTableWriter.this.metadata.populateIoCacheOnFlush());
            this.builder = SegmentedFile.getBuilder(DatabaseDescriptor.getIndexAccessMode());
            this.summary = new IndexSummaryBuilder(keyCount);
            this.bf = FilterFactory.getFilter(keyCount, SSTableWriter.this.metadata.getBloomFilterFpChance(), true);
        }

        public void append(DecoratedKey key, RowIndexEntry indexEntry) {
            this.bf.add(key.key);
            long indexPosition = this.indexFile.getFilePointer();
            try {
                ByteBufferUtil.writeWithShortLength(key.key, this.indexFile.stream);
                RowIndexEntry.serializer.serialize(indexEntry, this.indexFile.stream);
            }
            catch (IOException e) {
                throw new FSWriteError((Throwable)e, this.indexFile.getPath());
            }
            if (logger.isTraceEnabled()) {
                logger.trace("wrote index entry: " + indexEntry + " at " + indexPosition);
            }
            this.summary.maybeAddEntry(key, indexPosition);
            this.builder.addPotentialBoundary(indexPosition);
        }

        @Override
        public void close() {
            if (SSTableWriter.this.components.contains(Component.FILTER)) {
                String path = SSTableWriter.this.descriptor.filenameFor(SSTable.COMPONENT_FILTER);
                try {
                    FileOutputStream fos = new FileOutputStream(path);
                    DataOutputStream stream = new DataOutputStream(fos);
                    FilterFactory.serialize(this.bf, stream, SSTableWriter.this.descriptor.version.filterType);
                    stream.flush();
                    fos.getFD().sync();
                    stream.close();
                }
                catch (IOException e) {
                    throw new FSWriteError((Throwable)e, path);
                }
            }
            long position = this.indexFile.getFilePointer();
            this.indexFile.close();
            FileUtils.truncate(this.indexFile.getPath(), position);
        }

        public void mark() {
            this.mark = this.indexFile.mark();
        }

        public void resetAndTruncate() {
            this.indexFile.resetAndTruncate(this.mark);
        }

        public String toString() {
            return "IndexWriter(" + SSTableWriter.this.descriptor + ")";
        }
    }
}

