/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOError;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.HeapAllocator;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SSTable {
    static final Logger logger = LoggerFactory.getLogger(SSTable.class);
    public static final String COMPONENT_DATA = Component.Type.DATA.repr;
    public static final String COMPONENT_INDEX = Component.Type.PRIMARY_INDEX.repr;
    public static final String COMPONENT_FILTER = Component.Type.FILTER.repr;
    public static final String COMPONENT_STATS = Component.Type.STATS.repr;
    public static final String COMPONENT_DIGEST = Component.Type.DIGEST.repr;
    public static final String COMPONENT_SUMMARY = Component.Type.SUMMARY.repr;
    public static final String TEMPFILE_MARKER = "tmp";
    public static final int TOMBSTONE_HISTOGRAM_BIN_SIZE = 100;
    public static final Comparator<SSTableReader> maxTimestampComparator = new Comparator<SSTableReader>(){

        @Override
        public int compare(SSTableReader o1, SSTableReader o2) {
            long ts2;
            long ts1 = o1.getMaxTimestamp();
            return ts1 > (ts2 = o2.getMaxTimestamp()) ? -1 : (ts1 == ts2 ? 0 : 1);
        }
    };
    public final Descriptor descriptor;
    protected final Set<Component> components;
    public final CFMetaData metadata;
    public final IPartitioner partitioner;
    public final boolean compression;
    public DecoratedKey first;
    public DecoratedKey last;
    public static final Comparator<SSTableReader> sstableComparator = new Comparator<SSTableReader>(){

        @Override
        public int compare(SSTableReader o1, SSTableReader o2) {
            return o1.first.compareTo(o2.first);
        }
    };
    public static final Ordering<SSTableReader> sstableOrdering = Ordering.from(sstableComparator);

    protected SSTable(Descriptor descriptor, CFMetaData metadata, IPartitioner partitioner) {
        this(descriptor, new HashSet<Component>(), metadata, partitioner);
    }

    protected SSTable(Descriptor descriptor, Set<Component> components, CFMetaData metadata, IPartitioner partitioner) {
        assert (descriptor != null);
        assert (components != null);
        assert (partitioner != null);
        this.descriptor = descriptor;
        HashSet<Component> dataComponents = new HashSet<Component>(components);
        for (Component component : components) {
            assert (component.type != Component.Type.COMPACTED_MARKER);
        }
        this.compression = dataComponents.contains(Component.COMPRESSION_INFO);
        this.components = new CopyOnWriteArraySet<Component>(dataComponents);
        this.metadata = metadata;
        this.partitioner = partitioner;
    }

    public static boolean delete(Descriptor desc, Set<Component> components) {
        if (components.contains(Component.DATA)) {
            FileUtils.deleteWithConfirm(desc.filenameFor(Component.DATA));
        }
        for (Component component : components) {
            if (component.equals(Component.DATA) || component.equals(Component.COMPACTED_MARKER) || component.equals(Component.SUMMARY)) continue;
            FileUtils.deleteWithConfirm(desc.filenameFor(component));
        }
        FileUtils.delete(desc.filenameFor(Component.COMPACTED_MARKER));
        FileUtils.delete(desc.filenameFor(Component.SUMMARY));
        logger.debug("Deleted {}", (Object)desc);
        return true;
    }

    public static DecoratedKey getMinimalKey(DecoratedKey key) {
        return key.key.position() > 0 || key.key.hasRemaining() ? new DecoratedKey(key.token, HeapAllocator.instance.clone(key.key)) : key;
    }

    public String getFilename() {
        return this.descriptor.filenameFor(COMPONENT_DATA);
    }

    public String getIndexFilename() {
        return this.descriptor.filenameFor(COMPONENT_INDEX);
    }

    public String getColumnFamilyName() {
        return this.descriptor.cfname;
    }

    public String getTableName() {
        return this.descriptor.ksname;
    }

    public static Pair<Descriptor, Component> tryComponentFromFilename(File dir, String name) {
        return Component.fromFilename(dir, name);
    }

    static Set<Component> componentsFor(Descriptor desc) {
        try {
            try {
                return SSTable.readTOC(desc);
            }
            catch (FileNotFoundException e) {
                Set<Component> components = SSTable.discoverComponentsFor(desc);
                if (components.isEmpty()) {
                    return components;
                }
                if (!components.contains(Component.TOC)) {
                    components.add(Component.TOC);
                }
                SSTable.appendTOC(desc, components);
                return components;
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    private static Set<Component> discoverComponentsFor(Descriptor desc) {
        Sets.SetView knownTypes = Sets.difference(Component.TYPES, Collections.singleton(Component.Type.CUSTOM));
        HashSet components = Sets.newHashSetWithExpectedSize((int)knownTypes.size());
        for (Component.Type componentType : knownTypes) {
            Component component = new Component(componentType);
            if (!new File(desc.filenameFor(component)).exists()) continue;
            components.add(component);
        }
        return components;
    }

    long estimateRowsFromIndex(RandomAccessReader ifile) throws IOException {
        int keys;
        int SAMPLES_CAP = 10000;
        int BYTES_CAP = (int)Math.min(10000000L, ifile.length());
        for (keys = 0; ifile.getFilePointer() < (long)BYTES_CAP && keys < 10000; ++keys) {
            ByteBufferUtil.skipShortLength(ifile);
            RowIndexEntry.serializer.skip(ifile, this.descriptor.version);
        }
        assert (keys > 0 && ifile.getFilePointer() > 0L && ifile.length() > 0L) : "Unexpected empty index file: " + ifile;
        long estimatedRows = ifile.length() / (ifile.getFilePointer() / (long)keys);
        ifile.seek(0L);
        return estimatedRows;
    }

    public static long getTotalBytes(Iterable<SSTableReader> sstables) {
        long sum = 0L;
        for (SSTableReader sstable : sstables) {
            sum += sstable.onDiskLength();
        }
        return sum;
    }

    public long bytesOnDisk() {
        long bytes = 0L;
        for (Component component : this.components) {
            bytes += new File(this.descriptor.filenameFor(component)).length();
        }
        return bytes;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + "path='" + this.getFilename() + '\'' + ')';
    }

    protected static Set<Component> readTOC(Descriptor descriptor) throws IOException {
        File tocFile = new File(descriptor.filenameFor(Component.TOC));
        List componentNames = Files.readLines((File)tocFile, (Charset)Charset.defaultCharset());
        HashSet components = Sets.newHashSetWithExpectedSize((int)componentNames.size());
        for (String componentName : componentNames) {
            Component component = new Component(Component.Type.fromRepresentation(componentName), componentName);
            if (!new File(descriptor.filenameFor(component)).exists()) {
                logger.error("Missing component: " + descriptor.filenameFor(component));
                continue;
            }
            components.add(component);
        }
        return components;
    }

    protected static void appendTOC(Descriptor descriptor, Collection<Component> components) {
        File tocFile = new File(descriptor.filenameFor(Component.TOC));
        PrintWriter w = null;
        try {
            w = new PrintWriter(new FileWriter(tocFile, true));
            for (Component component : components) {
                w.println(component.name);
            }
        }
        catch (IOException e) {
            try {
                throw new FSWriteError((Throwable)e, tocFile);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(w);
                throw throwable;
            }
        }
        FileUtils.closeQuietly(w);
    }

    public synchronized void addComponents(Collection<Component> newComponents) {
        Collection componentsToAdd = Collections2.filter(newComponents, (Predicate)Predicates.not((Predicate)Predicates.in(this.components)));
        SSTable.appendTOC(this.descriptor, componentsToAdd);
        this.components.addAll(componentsToAdd);
    }
}

