/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.io.DataOutput;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ColumnIndex;
import org.apache.cassandra.db.CounterColumn;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.columniterator.IdentityQueryFilter;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.io.sstable.ColumnStats;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.IMergeIterator;
import org.apache.cassandra.utils.MergeIterator;

public class PrecompactedRow
extends AbstractCompactedRow {
    private final ColumnFamily compactedCf;
    private ColumnIndex columnIndex;

    public PrecompactedRow(DecoratedKey key, ColumnFamily cf) {
        super(key);
        this.compactedCf = cf;
    }

    public static ColumnFamily removeDeletedAndOldShards(DecoratedKey key, CompactionController controller, ColumnFamily cf) {
        ColumnFamily compacted;
        assert (key != null);
        assert (controller != null);
        assert (cf != null);
        Boolean shouldPurge = null;
        if (cf.hasIrrelevantData(controller.gcBefore)) {
            shouldPurge = controller.shouldPurge(key, cf.maxTimestamp());
        }
        if ((compacted = ColumnFamilyStore.removeDeleted(cf, shouldPurge != null && shouldPurge != false ? controller.gcBefore : Integer.MIN_VALUE)) != null && compacted.metadata().getDefaultValidator().isCommutative()) {
            if (shouldPurge == null) {
                shouldPurge = controller.shouldPurge(key, cf.deletionInfo().maxTimestamp());
            }
            if (shouldPurge.booleanValue()) {
                CounterColumn.mergeAndRemoveOldShards(key, compacted, controller.gcBefore, controller.mergeShardBefore);
            }
        }
        return compacted;
    }

    public static ColumnFamily removeDeletedAndOldShards(DecoratedKey key, boolean shouldPurge, CompactionController controller, ColumnFamily cf) {
        ColumnFamily compacted = ColumnFamilyStore.removeDeleted(cf, shouldPurge ? controller.gcBefore : Integer.MIN_VALUE, controller.cfs.indexManager.updaterFor(key));
        if (shouldPurge && compacted != null && compacted.metadata().getDefaultValidator().isCommutative()) {
            CounterColumn.mergeAndRemoveOldShards(key, compacted, controller.gcBefore, controller.mergeShardBefore);
        }
        return compacted;
    }

    public PrecompactedRow(CompactionController controller, List<SSTableIdentityIterator> rows) {
        this(rows.get(0).getKey(), PrecompactedRow.removeDeletedAndOldShards(rows.get(0).getKey(), controller, PrecompactedRow.merge(rows, controller)));
    }

    private static ColumnFamily merge(List<SSTableIdentityIterator> rows, CompactionController controller) {
        assert (!rows.isEmpty());
        ColumnFamily returnCF = ColumnFamily.create(controller.cfs.metadata, ArrayBackedSortedColumns.factory());
        ArrayList<CloseableIterator<IColumn>> data = new ArrayList<CloseableIterator<IColumn>>(rows.size());
        for (SSTableIdentityIterator row : rows) {
            try {
                ColumnFamily cf = row.getColumnFamilyWithColumns(ArrayBackedSortedColumns.factory());
                returnCF.delete(cf);
                data.add(FBUtilities.closeableIterator(cf.iterator()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        PrecompactedRow.merge(returnCF, data, controller.cfs.indexManager.updaterFor(rows.get(0).getKey()));
        return returnCF;
    }

    public static void merge(final ColumnFamily returnCF, List<CloseableIterator<IColumn>> data, final SecondaryIndexManager.Updater indexer) {
        IdentityQueryFilter filter = new IdentityQueryFilter();
        Comparator<IColumn> fcomp = filter.getColumnComparator(returnCF.getComparator());
        MergeIterator.Reducer<IColumn, IColumn> reducer = new MergeIterator.Reducer<IColumn, IColumn>(){
            ColumnFamily container;
            {
                this.container = returnCF.cloneMeShallow();
            }

            @Override
            public void reduce(IColumn column) {
                this.container.addColumn(column);
                if (indexer != SecondaryIndexManager.nullUpdater && !column.isMarkedForDelete() && !this.container.getColumn(column.name()).equals(column)) {
                    indexer.remove(column);
                }
            }

            @Override
            protected IColumn getReduced() {
                IColumn c = this.container.iterator().next();
                this.container.clear();
                return c;
            }
        };
        IMergeIterator<IColumn, IColumn> reduced = MergeIterator.get(data, fcomp, reducer);
        filter.collectReducedColumns(returnCF, reduced, Integer.MIN_VALUE);
    }

    @Override
    public long write(DataOutput out) throws IOException {
        assert (this.compactedCf != null);
        DataOutputBuffer buffer = new DataOutputBuffer();
        ColumnIndex.Builder builder = new ColumnIndex.Builder(this.compactedCf, this.key.key, buffer);
        this.columnIndex = builder.build(this.compactedCf);
        TypeSizes typeSizes = TypeSizes.NATIVE;
        long delSize = DeletionTime.serializer.serializedSize(this.compactedCf.deletionInfo().getTopLevelDeletion(), typeSizes);
        long dataSize = (long)buffer.getLength() + delSize + (long)typeSizes.sizeof(0);
        out.writeLong(dataSize);
        DeletionTime.serializer.serialize(this.compactedCf.deletionInfo().getTopLevelDeletion(), out);
        out.writeInt(builder.writtenAtomCount());
        out.write(buffer.getData(), 0, buffer.getLength());
        return dataSize;
    }

    @Override
    public void update(MessageDigest digest) {
        assert (this.compactedCf != null);
        DataOutputBuffer buffer = new DataOutputBuffer();
        try {
            DeletionTime.serializer.serialize(this.compactedCf.deletionInfo().getTopLevelDeletion(), buffer);
            buffer.writeInt(this.compactedCf.getColumnCount());
            digest.update(buffer.getData(), 0, buffer.getLength());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.compactedCf.updateDigest(digest);
    }

    @Override
    public boolean isEmpty() {
        return this.compactedCf == null;
    }

    @Override
    public ColumnStats columnStats() {
        return this.compactedCf.getColumnStats();
    }

    public ColumnFamily getFullColumnFamily() {
        return this.compactedCf;
    }

    @Override
    public DeletionInfo deletionInfo() {
        return this.compactedCf.deletionInfo();
    }

    @Override
    public ColumnIndex index() {
        return this.columnIndex;
    }

    @Override
    public void close() {
    }
}

