/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.service.DigestMismatchException;
import org.apache.cassandra.service.RowRepairResolver;
import org.apache.cassandra.utils.SimpleCondition;

public class RepairCallback
implements IAsyncCallback {
    public final RowRepairResolver resolver;
    private final List<InetAddress> endpoints;
    private final SimpleCondition condition = new SimpleCondition();
    private final long startTime;
    protected final AtomicInteger received = new AtomicInteger(0);

    public RepairCallback(RowRepairResolver resolver, List<InetAddress> endpoints) {
        this.resolver = resolver;
        this.endpoints = endpoints;
        this.startTime = System.currentTimeMillis();
    }

    public Row get() throws DigestMismatchException, IOException {
        long timeout = DatabaseDescriptor.getWriteRpcTimeout() - (System.currentTimeMillis() - this.startTime);
        try {
            this.condition.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new AssertionError((Object)ex);
        }
        return this.received.get() > 1 ? this.resolver.resolve() : null;
    }

    public void response(MessageIn message) {
        this.resolver.preprocess(message);
        if (this.received.incrementAndGet() == this.endpoints.size()) {
            this.condition.signal();
        }
    }

    @Override
    public boolean isLatencyForSnitch() {
        return true;
    }

    public int getMaxLiveCount() {
        return this.resolver.getMaxLiveCount();
    }
}

