/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.util.concurrent.Futures;
import com.googlecode.concurrentlinkedhashmap.EntryWeigher;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.cache.AutoSavingCache;
import org.apache.cassandra.cache.ConcurrentLinkedHashCache;
import org.apache.cassandra.cache.ICache;
import org.apache.cassandra.cache.IRowCacheEntry;
import org.apache.cassandra.cache.KeyCacheKey;
import org.apache.cassandra.cache.RowCacheKey;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.service.CacheServiceMBean;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.github.jamm.MemoryMeter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheService
implements CacheServiceMBean {
    private static final Logger logger = LoggerFactory.getLogger(CacheService.class);
    public static final String MBEAN_NAME = "org.apache.cassandra.db:type=Caches";
    public static final CacheService instance = new CacheService();
    public final AutoSavingCache<KeyCacheKey, RowIndexEntry> keyCache;
    public final AutoSavingCache<RowCacheKey, IRowCacheEntry> rowCache;

    private CacheService() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(this, new ObjectName(MBEAN_NAME));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.keyCache = this.initKeyCache();
        this.rowCache = this.initRowCache();
    }

    private AutoSavingCache<KeyCacheKey, RowIndexEntry> initKeyCache() {
        ConcurrentLinkedHashCache<Object, Object> kc;
        logger.info("Initializing key cache with capacity of {} MBs.", (Object)DatabaseDescriptor.getKeyCacheSizeInMB());
        long keyCacheInMemoryCapacity = DatabaseDescriptor.getKeyCacheSizeInMB() * 1024L * 1024L;
        if (MemoryMeter.isInitialized()) {
            kc = ConcurrentLinkedHashCache.create(keyCacheInMemoryCapacity);
        } else {
            logger.warn("MemoryMeter uninitialized (jamm not specified as java agent); KeyCache size in JVM Heap will not be calculated accurately. Usually this means cassandra-env.sh disabled jamm because you are using a buggy JRE; upgrade to the Sun JRE instead");
            EntryWeigher<KeyCacheKey, RowIndexEntry> weigher = new EntryWeigher<KeyCacheKey, RowIndexEntry>(){

                public int weightOf(KeyCacheKey key, RowIndexEntry entry) {
                    return key.key.length + entry.serializedSize();
                }
            };
            kc = ConcurrentLinkedHashCache.create(keyCacheInMemoryCapacity, weigher);
        }
        AutoSavingCache<KeyCacheKey, RowIndexEntry> keyCache = new AutoSavingCache<KeyCacheKey, RowIndexEntry>(kc, CacheType.KEY_CACHE, new KeyCacheSerializer());
        int keyCacheKeysToSave = DatabaseDescriptor.getKeyCacheKeysToSave();
        logger.info("Scheduling key cache save to each {} seconds (going to save {} keys).", (Object)DatabaseDescriptor.getKeyCacheSavePeriod(), keyCacheKeysToSave == Integer.MAX_VALUE ? "all" : Integer.valueOf(keyCacheKeysToSave));
        keyCache.scheduleSaving(DatabaseDescriptor.getKeyCacheSavePeriod(), keyCacheKeysToSave);
        return keyCache;
    }

    private AutoSavingCache<RowCacheKey, IRowCacheEntry> initRowCache() {
        logger.info("Initializing row cache with capacity of {} MBs and provider {}", (Object)DatabaseDescriptor.getRowCacheSizeInMB(), (Object)DatabaseDescriptor.getRowCacheProvider().getClass().getName());
        long rowCacheInMemoryCapacity = DatabaseDescriptor.getRowCacheSizeInMB() * 1024L * 1024L;
        ICache<RowCacheKey, IRowCacheEntry> rc = DatabaseDescriptor.getRowCacheProvider().create(rowCacheInMemoryCapacity);
        AutoSavingCache<RowCacheKey, IRowCacheEntry> rowCache = new AutoSavingCache<RowCacheKey, IRowCacheEntry>(rc, CacheType.ROW_CACHE, new RowCacheSerializer());
        int rowCacheKeysToSave = DatabaseDescriptor.getRowCacheKeysToSave();
        logger.info("Scheduling row cache save to each {} seconds (going to save {} keys).", (Object)DatabaseDescriptor.getRowCacheSavePeriod(), rowCacheKeysToSave == Integer.MAX_VALUE ? "all" : Integer.valueOf(rowCacheKeysToSave));
        rowCache.scheduleSaving(DatabaseDescriptor.getRowCacheSavePeriod(), rowCacheKeysToSave);
        return rowCache;
    }

    @Override
    public long getKeyCacheHits() {
        return this.keyCache.getMetrics().hits.count();
    }

    @Override
    public long getRowCacheHits() {
        return this.rowCache.getMetrics().hits.count();
    }

    @Override
    public long getKeyCacheRequests() {
        return this.keyCache.getMetrics().requests.count();
    }

    @Override
    public long getRowCacheRequests() {
        return this.rowCache.getMetrics().requests.count();
    }

    @Override
    public double getKeyCacheRecentHitRate() {
        return this.keyCache.getMetrics().getRecentHitRate();
    }

    @Override
    public double getRowCacheRecentHitRate() {
        return this.rowCache.getMetrics().getRecentHitRate();
    }

    @Override
    public int getRowCacheSavePeriodInSeconds() {
        return DatabaseDescriptor.getRowCacheSavePeriod();
    }

    @Override
    public void setRowCacheSavePeriodInSeconds(int rcspis) {
        if (rcspis < 0) {
            throw new RuntimeException("RowCacheSavePeriodInSeconds must be non-negative.");
        }
        DatabaseDescriptor.setRowCacheSavePeriod(rcspis);
        this.rowCache.scheduleSaving(rcspis, DatabaseDescriptor.getRowCacheKeysToSave());
    }

    @Override
    public int getKeyCacheSavePeriodInSeconds() {
        return DatabaseDescriptor.getKeyCacheSavePeriod();
    }

    @Override
    public void setKeyCacheSavePeriodInSeconds(int kcspis) {
        if (kcspis < 0) {
            throw new RuntimeException("KeyCacheSavePeriodInSeconds must be non-negative.");
        }
        DatabaseDescriptor.setKeyCacheSavePeriod(kcspis);
        this.keyCache.scheduleSaving(kcspis, DatabaseDescriptor.getKeyCacheKeysToSave());
    }

    @Override
    public void invalidateKeyCache() {
        this.keyCache.clear();
    }

    @Override
    public void invalidateRowCache() {
        this.rowCache.clear();
    }

    @Override
    public long getRowCacheCapacityInBytes() {
        return (Long)this.rowCache.getMetrics().capacity.value();
    }

    @Override
    public long getRowCacheCapacityInMB() {
        return this.getRowCacheCapacityInBytes() / 1024L / 1024L;
    }

    @Override
    public void setRowCacheCapacityInMB(long capacity) {
        if (capacity < 0L) {
            throw new RuntimeException("capacity should not be negative.");
        }
        this.rowCache.setCapacity(capacity * 1024L * 1024L);
    }

    @Override
    public long getKeyCacheCapacityInBytes() {
        return (Long)this.keyCache.getMetrics().capacity.value();
    }

    @Override
    public long getKeyCacheCapacityInMB() {
        return this.getKeyCacheCapacityInBytes() / 1024L / 1024L;
    }

    @Override
    public void setKeyCacheCapacityInMB(long capacity) {
        if (capacity < 0L) {
            throw new RuntimeException("capacity should not be negative.");
        }
        long weightedCapacity = capacity * 1024L * 1024L;
        this.keyCache.setCapacity(MemoryMeter.isInitialized() ? weightedCapacity : weightedCapacity / 48L);
    }

    @Override
    public long getRowCacheSize() {
        return (Long)this.rowCache.getMetrics().size.value();
    }

    @Override
    public long getRowCacheEntries() {
        return this.rowCache.size();
    }

    @Override
    public long getKeyCacheSize() {
        return (Long)this.keyCache.getMetrics().size.value();
    }

    @Override
    public long getKeyCacheEntries() {
        return this.keyCache.size();
    }

    @Override
    public void reduceCacheSizes() {
        this.reduceRowCacheSize();
        this.reduceKeyCacheSize();
    }

    public void reduceRowCacheSize() {
        this.rowCache.reduceCacheSize();
    }

    public void reduceKeyCacheSize() {
        this.keyCache.reduceCacheSize();
    }

    @Override
    public void saveCaches() throws ExecutionException, InterruptedException {
        ArrayList futures = new ArrayList(2);
        logger.debug("submitting cache saves");
        futures.add(this.keyCache.submitWrite(DatabaseDescriptor.getKeyCacheKeysToSave()));
        futures.add(this.rowCache.submitWrite(DatabaseDescriptor.getRowCacheKeysToSave()));
        FBUtilities.waitOnFutures(futures);
        logger.debug("cache saves completed");
    }

    public class KeyCacheSerializer
    implements AutoSavingCache.CacheSerializer<KeyCacheKey, RowIndexEntry> {
        @Override
        public void serialize(KeyCacheKey key, DataOutput out) throws IOException {
            RowIndexEntry entry = (RowIndexEntry)CacheService.instance.keyCache.get(key);
            if (entry == null) {
                return;
            }
            ByteBufferUtil.writeWithLength(key.key, out);
            Descriptor desc = key.desc;
            out.writeInt(desc.generation);
            out.writeBoolean(desc.version.hasPromotedIndexes);
            if (!desc.version.hasPromotedIndexes) {
                return;
            }
            RowIndexEntry.serializer.serialize(entry, out);
        }

        @Override
        public Future<Pair<KeyCacheKey, RowIndexEntry>> deserialize(DataInputStream input, ColumnFamilyStore cfs) throws IOException {
            ByteBuffer key = ByteBufferUtil.readWithLength(input);
            int generation = input.readInt();
            SSTableReader reader = this.findDesc(generation, cfs.getSSTables());
            if (reader == null) {
                RowIndexEntry.serializer.skipPromotedIndex(input);
                return null;
            }
            RowIndexEntry entry = input.readBoolean() ? RowIndexEntry.serializer.deserialize(input, reader.descriptor.version) : reader.getPosition(reader.partitioner.decorateKey(key), SSTableReader.Operator.EQ);
            return Futures.immediateFuture(Pair.create(new KeyCacheKey(reader.descriptor, key), entry));
        }

        private SSTableReader findDesc(int generation, Collection<SSTableReader> collection) {
            for (SSTableReader sstable : collection) {
                if (sstable.descriptor.generation != generation) continue;
                return sstable;
            }
            return null;
        }

        @Override
        public void load(Set<ByteBuffer> buffers, ColumnFamilyStore cfs) {
            for (ByteBuffer key : buffers) {
                DecoratedKey dk = cfs.partitioner.decorateKey(key);
                for (SSTableReader sstable : cfs.getSSTables()) {
                    RowIndexEntry entry = sstable.getPosition(dk, SSTableReader.Operator.EQ);
                    if (entry == null) continue;
                    CacheService.this.keyCache.put(new KeyCacheKey(sstable.descriptor, key), entry);
                }
            }
        }
    }

    public class RowCacheSerializer
    implements AutoSavingCache.CacheSerializer<RowCacheKey, IRowCacheEntry> {
        @Override
        public void serialize(RowCacheKey key, DataOutput out) throws IOException {
            ByteBufferUtil.writeWithLength(key.key, out);
        }

        @Override
        public Future<Pair<RowCacheKey, IRowCacheEntry>> deserialize(DataInputStream in, final ColumnFamilyStore cfs) throws IOException {
            final ByteBuffer buffer = ByteBufferUtil.readWithLength(in);
            return StageManager.getStage(Stage.READ).submit(new Callable<Pair<RowCacheKey, IRowCacheEntry>>(){

                @Override
                public Pair<RowCacheKey, IRowCacheEntry> call() throws Exception {
                    DecoratedKey key = cfs.partitioner.decorateKey(buffer);
                    ColumnFamily data = cfs.getTopLevelColumns(QueryFilter.getIdentityFilter(key, new QueryPath(cfs.columnFamily)), Integer.MIN_VALUE, true);
                    return Pair.create(new RowCacheKey(cfs.metadata.cfId, key), data);
                }
            });
        }

        @Override
        public void load(Set<ByteBuffer> buffers, ColumnFamilyStore cfs) {
            for (ByteBuffer key : buffers) {
                DecoratedKey dk = cfs.partitioner.decorateKey(key);
                ColumnFamily data = cfs.getTopLevelColumns(QueryFilter.getIdentityFilter(dk, new QueryPath(cfs.columnFamily)), Integer.MIN_VALUE, true);
                CacheService.this.rowCache.put(new RowCacheKey(cfs.metadata.cfId, dk), data);
            }
        }
    }

    public static enum CacheType {
        KEY_CACHE("KeyCache"),
        ROW_CACHE("RowCache");

        private final String name;

        private CacheType(String typeName) {
            this.name = typeName;
        }

        public String toString() {
            return this.name;
        }
    }
}

