/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.File;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlacklistedDirectories {
    private static final Logger logger = LoggerFactory.getLogger(BlacklistedDirectories.class);
    private static Set<File> unreadableDirectories = new CopyOnWriteArraySet<File>();
    private static Set<File> unwritableDirectories = new CopyOnWriteArraySet<File>();

    public static File maybeMarkUnreadable(File path) {
        File directory = BlacklistedDirectories.getDirectory(path);
        if (unreadableDirectories.add(directory)) {
            logger.warn("Blacklisting {} for reads", (Object)directory);
            return directory;
        }
        return null;
    }

    public static File maybeMarkUnwritable(File path) {
        File directory = BlacklistedDirectories.getDirectory(path);
        if (unwritableDirectories.add(directory)) {
            logger.warn("Blacklisting {} for writes", (Object)directory);
            return directory;
        }
        return null;
    }

    public static boolean isUnreadable(File directory) {
        return unreadableDirectories.contains(directory);
    }

    public static boolean isUnwritable(File directory) {
        return unwritableDirectories.contains(directory);
    }

    private static File getDirectory(File file) {
        if (file.isDirectory()) {
            return file;
        }
        if (file.isFile()) {
            return file.getParentFile();
        }
        if (file.getPath().endsWith(".db")) {
            return file.getParentFile();
        }
        throw new IllegalStateException("Unable to parse directory from path " + file);
    }
}

