/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tracing;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.ExpiringColumn;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.tracing.TraceState;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.cassandra.utils.WrappedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tracing {
    public static final String TRACE_KS = "system_traces";
    public static final String EVENTS_CF = "events";
    public static final String SESSIONS_CF = "sessions";
    public static final String TRACE_HEADER = "TraceSession";
    private static final int TTL = 86400;
    private static Tracing instance = new Tracing();
    public static final Logger logger = LoggerFactory.getLogger(Tracing.class);
    private InetAddress localAddress = FBUtilities.getLocalAddress();
    private final ThreadLocal<TraceState> state = new ThreadLocal();
    private final Map<UUID, TraceState> sessions = new ConcurrentHashMap<UUID, TraceState>();

    public static Tracing instance() {
        return instance;
    }

    public static void addColumn(ColumnFamily cf, ByteBuffer name, InetAddress address) {
        Tracing.addColumn(cf, name, ByteBufferUtil.bytes(address));
    }

    public static void addColumn(ColumnFamily cf, ByteBuffer name, int value) {
        Tracing.addColumn(cf, name, ByteBufferUtil.bytes(value));
    }

    public static void addColumn(ColumnFamily cf, ByteBuffer name, long value) {
        Tracing.addColumn(cf, name, ByteBufferUtil.bytes(value));
    }

    public static void addColumn(ColumnFamily cf, ByteBuffer name, String value) {
        Tracing.addColumn(cf, name, ByteBufferUtil.bytes(value));
    }

    private static void addColumn(ColumnFamily cf, ByteBuffer name, ByteBuffer value) {
        cf.addColumn(new ExpiringColumn(name, value, System.currentTimeMillis(), 86400));
    }

    public void addParameterColumns(ColumnFamily cf, Map<String, String> rawPayload) {
        for (Map.Entry<String, String> entry : rawPayload.entrySet()) {
            cf.addColumn(new ExpiringColumn(Tracing.buildName(cf.metadata(), ByteBufferUtil.bytes("parameters"), ByteBufferUtil.bytes(entry.getKey())), ByteBufferUtil.bytes(entry.getValue()), System.currentTimeMillis(), 86400));
        }
    }

    public static ByteBuffer buildName(CFMetaData meta, ByteBuffer ... args) {
        ColumnNameBuilder builder = meta.getCfDef().getColumnNameBuilder();
        for (ByteBuffer arg : args) {
            builder.add(arg);
        }
        return builder.build();
    }

    public UUID getSessionId() {
        assert (Tracing.isTracing());
        return this.state.get().sessionId;
    }

    public static boolean isTracing() {
        return instance != null && Tracing.instance.state.get() != null;
    }

    public UUID newSession() {
        return this.newSession(TimeUUIDType.instance.compose(ByteBuffer.wrap(UUIDGen.getTimeUUIDBytes())));
    }

    public UUID newSession(UUID sessionId) {
        assert (this.state.get() == null);
        TraceState ts = new TraceState(this.localAddress, sessionId, true);
        this.state.set(ts);
        this.sessions.put(sessionId, ts);
        return sessionId;
    }

    public void stopIfNonLocal(TraceState state) {
        if (!state.isLocallyOwned) {
            this.sessions.remove(state.sessionId);
        }
    }

    public void stopSession() {
        TraceState state = this.state.get();
        if (state == null) {
            logger.debug("request complete");
        } else {
            final int elapsed = state.elapsed();
            final ByteBuffer sessionIdBytes = state.sessionIdBytes;
            StageManager.getStage(Stage.TRACING).execute(new WrappedRunnable(){

                @Override
                public void runMayThrow() throws Exception {
                    CFMetaData cfMeta = CFMetaData.TraceSessionsCf;
                    ColumnFamily cf = ColumnFamily.create(cfMeta);
                    Tracing.addColumn(cf, Tracing.buildName(cfMeta, ByteBufferUtil.bytes("duration")), elapsed);
                    RowMutation mutation = new RowMutation(Tracing.TRACE_KS, sessionIdBytes);
                    mutation.add(cf);
                    StorageProxy.mutate(Arrays.asList(mutation), ConsistencyLevel.ANY);
                }
            });
            this.sessions.remove(state.sessionId);
            this.state.set(null);
        }
    }

    public TraceState get() {
        return this.state.get();
    }

    public TraceState get(UUID sessionId) {
        return this.sessions.get(sessionId);
    }

    public void set(TraceState tls) {
        this.state.set(tls);
    }

    public void begin(final String request, final Map<String, String> parameters) {
        assert (Tracing.isTracing());
        final long started_at = System.currentTimeMillis();
        final ByteBuffer sessionIdBytes = this.state.get().sessionIdBytes;
        StageManager.getStage(Stage.TRACING).execute(new WrappedRunnable(){

            @Override
            public void runMayThrow() throws Exception {
                CFMetaData cfMeta = CFMetaData.TraceSessionsCf;
                ColumnFamily cf = ColumnFamily.create(cfMeta);
                Tracing.addColumn(cf, Tracing.buildName(cfMeta, ByteBufferUtil.bytes("coordinator")), FBUtilities.getBroadcastAddress());
                Tracing.addColumn(cf, Tracing.buildName(cfMeta, ByteBufferUtil.bytes("request")), request);
                Tracing.addColumn(cf, Tracing.buildName(cfMeta, ByteBufferUtil.bytes("started_at")), started_at);
                Tracing.this.addParameterColumns(cf, parameters);
                RowMutation mutation = new RowMutation(Tracing.TRACE_KS, sessionIdBytes);
                mutation.add(cf);
                StorageProxy.mutate(Arrays.asList(mutation), ConsistencyLevel.ANY);
            }
        });
    }

    public void initializeFromMessage(MessageIn<?> message) {
        byte[] sessionBytes = message.parameters.get(TRACE_HEADER);
        if (sessionBytes == null) {
            this.state.set(null);
            return;
        }
        assert (sessionBytes.length == 16);
        UUID sessionId = UUIDGen.getUUID(ByteBuffer.wrap(sessionBytes));
        TraceState ts = this.sessions.get(sessionId);
        if (ts == null) {
            ts = new TraceState(message.from, sessionId, false);
            this.sessions.put(sessionId, ts);
        }
        this.state.set(ts);
    }

    public static void trace(String message) {
        if (Tracing.instance() == null) {
            return;
        }
        TraceState state = Tracing.instance().get();
        if (state == null) {
            return;
        }
        state.trace(message);
    }

    public static void trace(String format, Object arg) {
        if (Tracing.instance() == null) {
            return;
        }
        TraceState state = Tracing.instance().get();
        if (state == null) {
            return;
        }
        state.trace(format, arg);
    }

    public static void trace(String format, Object arg1, Object arg2) {
        if (Tracing.instance() == null) {
            return;
        }
        TraceState state = Tracing.instance().get();
        if (state == null) {
            return;
        }
        state.trace(format, arg1, arg2);
    }

    public static void trace(String format, Object[] args) {
        if (Tracing.instance() == null) {
            return;
        }
        TraceState state = Tracing.instance().get();
        if (state == null) {
            return;
        }
        state.trace(format, args);
    }
}

