/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.collect.Iterables;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.WriteType;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.service.AbstractWriteResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteResponseHandler
extends AbstractWriteResponseHandler {
    protected static final Logger logger = LoggerFactory.getLogger(WriteResponseHandler.class);
    protected final AtomicInteger responses;
    private final int blockFor;

    public WriteResponseHandler(Collection<InetAddress> writeEndpoints, Collection<InetAddress> pendingEndpoints, ConsistencyLevel consistencyLevel, String table, Runnable callback, WriteType writeType) {
        super(writeEndpoints, pendingEndpoints, consistencyLevel, callback, writeType);
        this.blockFor = consistencyLevel.blockFor(table);
        this.responses = new AtomicInteger(this.blockFor);
    }

    public WriteResponseHandler(InetAddress endpoint, WriteType writeType, Runnable callback) {
        super(Arrays.asList(endpoint), Collections.<InetAddress>emptyList(), ConsistencyLevel.ALL, callback, writeType);
        this.blockFor = 1;
        this.responses = new AtomicInteger(1);
    }

    public WriteResponseHandler(InetAddress endpoint, WriteType writeType) {
        super(Arrays.asList(endpoint), Collections.<InetAddress>emptyList(), ConsistencyLevel.ALL, null, writeType);
        this.blockFor = 1;
        this.responses = new AtomicInteger(1);
    }

    @Override
    public void response(MessageIn m) {
        if (this.responses.decrementAndGet() == 0) {
            this.signal();
        }
    }

    @Override
    protected int ackCount() {
        return this.blockFor - this.responses.get();
    }

    @Override
    protected int blockForCL() {
        return this.blockFor;
    }

    @Override
    public void assureSufficientLiveNodes() throws UnavailableException {
        if (this.consistencyLevel == ConsistencyLevel.ANY) {
            return;
        }
        int liveNodes = 0;
        for (InetAddress destination : Iterables.concat((Iterable)this.naturalEndpoints, (Iterable)this.pendingEndpoints)) {
            if (!FailureDetector.instance.isAlive(destination)) continue;
            ++liveNodes;
        }
        if (liveNodes < this.blockFor) {
            throw new UnavailableException(this.consistencyLevel, this.blockFor, liveNodes);
        }
    }

    @Override
    public boolean isLatencyForSnitch() {
        return false;
    }
}

