/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.HintedHandOffManager;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.TreeMapBackedSortedColumns;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.cassandra.io.IColumnSerializer;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.FastByteArrayInputStream;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.CounterColumn;
import org.apache.cassandra.thrift.Deletion;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.commons.lang.StringUtils;

public class RowMutation
implements IMutation {
    public static final RowMutationSerializer serializer = new RowMutationSerializer();
    public static final String FORWARD_TO = "FWD_TO";
    public static final String FORWARD_FROM = "FWD_FRM";
    private final String table;
    private final ByteBuffer key;
    protected Map<UUID, ColumnFamily> modifications = new HashMap<UUID, ColumnFamily>();
    private final Map<Integer, byte[]> preserializedBuffers = new HashMap<Integer, byte[]>();

    public RowMutation(String table, ByteBuffer key) {
        this(table, key, new HashMap<UUID, ColumnFamily>());
    }

    public RowMutation(String table, Row row) {
        this(table, row.key.key);
        this.add(row.cf);
    }

    protected RowMutation(String table, ByteBuffer key, Map<UUID, ColumnFamily> modifications) {
        this.table = table;
        this.key = key;
        this.modifications = modifications;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public Collection<UUID> getColumnFamilyIds() {
        return this.modifications.keySet();
    }

    @Override
    public ByteBuffer key() {
        return this.key;
    }

    public Collection<ColumnFamily> getColumnFamilies() {
        return this.modifications.values();
    }

    public ColumnFamily getColumnFamily(UUID cfId) {
        return this.modifications.get(cfId);
    }

    public static RowMutation hintFor(RowMutation mutation, UUID targetId) throws IOException {
        RowMutation rm = new RowMutation("system", UUIDType.instance.decompose(targetId));
        UUID hintId = UUIDGen.getTimeUUID();
        int ttl = Integer.MAX_VALUE;
        for (ColumnFamily cf : mutation.getColumnFamilies()) {
            ttl = Math.min(ttl, cf.metadata().getGcGraceSeconds());
        }
        QueryPath path = new QueryPath("hints", null, HintedHandOffManager.comparator.decompose(hintId, 6));
        rm.add(path, ByteBuffer.wrap(mutation.getSerializedBuffer(6)), System.currentTimeMillis(), ttl);
        return rm;
    }

    public void add(ColumnFamily columnFamily) {
        assert (columnFamily != null);
        ColumnFamily prev = this.modifications.put(columnFamily.id(), columnFamily);
        if (prev != null) {
            throw new IllegalArgumentException("ColumnFamily " + columnFamily + " already has modifications in this mutation: " + prev);
        }
    }

    public ColumnFamily addOrGet(String cfName) {
        CFMetaData cfm = Schema.instance.getCFMetaData(this.table, cfName);
        ColumnFamily cf = this.modifications.get(cfm.cfId);
        if (cf == null) {
            cf = ColumnFamily.create(cfm);
            this.modifications.put(cfm.cfId, cf);
        }
        return cf;
    }

    public boolean isEmpty() {
        return this.modifications.isEmpty();
    }

    public void add(QueryPath path, ByteBuffer value, long timestamp, int timeToLive) {
        UUID id = Schema.instance.getId(this.table, path.columnFamilyName);
        ColumnFamily columnFamily = this.modifications.get(id);
        if (columnFamily == null) {
            columnFamily = ColumnFamily.create(this.table, path.columnFamilyName);
            this.modifications.put(id, columnFamily);
        }
        columnFamily.addColumn(path, value, timestamp, timeToLive);
    }

    public void addCounter(QueryPath path, long value) {
        UUID id = Schema.instance.getId(this.table, path.columnFamilyName);
        ColumnFamily columnFamily = this.modifications.get(id);
        if (columnFamily == null) {
            columnFamily = ColumnFamily.create(this.table, path.columnFamilyName);
            this.modifications.put(id, columnFamily);
        }
        columnFamily.addCounter(path, value);
    }

    public void add(QueryPath path, ByteBuffer value, long timestamp) {
        this.add(path, value, timestamp, 0);
    }

    public void delete(QueryPath path, long timestamp) {
        UUID id = Schema.instance.getId(this.table, path.columnFamilyName);
        int localDeleteTime = (int)(System.currentTimeMillis() / 1000L);
        ColumnFamily columnFamily = this.modifications.get(id);
        if (columnFamily == null) {
            columnFamily = ColumnFamily.create(this.table, path.columnFamilyName);
            this.modifications.put(id, columnFamily);
        }
        if (path.superColumnName == null && path.columnName == null) {
            columnFamily.delete(new DeletionInfo(timestamp, localDeleteTime));
        } else if (path.columnName == null) {
            SuperColumn sc = new SuperColumn(path.superColumnName, columnFamily.getSubComparator());
            sc.delete(new DeletionInfo(timestamp, localDeleteTime));
            columnFamily.addColumn(sc);
        } else {
            columnFamily.addTombstone(path, localDeleteTime, timestamp);
        }
    }

    @Override
    public void addAll(IMutation m) {
        if (!(m instanceof RowMutation)) {
            throw new IllegalArgumentException();
        }
        RowMutation rm = (RowMutation)m;
        if (!this.table.equals(rm.table) || !this.key.equals(rm.key)) {
            throw new IllegalArgumentException();
        }
        for (Map.Entry<UUID, ColumnFamily> entry : rm.modifications.entrySet()) {
            ColumnFamily cf = this.modifications.put(entry.getKey(), entry.getValue());
            if (cf == null) continue;
            entry.getValue().resolve(cf);
        }
    }

    @Override
    public void apply() {
        KSMetaData ksm = Schema.instance.getTableDefinition(this.getTable());
        Table.open(this.table).apply(this, ksm.durableWrites);
    }

    public void applyUnsafe() {
        Table.open(this.table).apply(this, false);
    }

    public MessageOut<RowMutation> createMessage() {
        return this.createMessage(MessagingService.Verb.MUTATION);
    }

    public MessageOut<RowMutation> createMessage(MessagingService.Verb verb) {
        return new MessageOut<RowMutation>(verb, this, serializer);
    }

    public synchronized byte[] getSerializedBuffer(int version) throws IOException {
        byte[] bytes = this.preserializedBuffers.get(version);
        if (bytes == null) {
            bytes = FBUtilities.serialize(this, serializer, version);
            this.preserializedBuffers.put(version, bytes);
        }
        return bytes;
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean shallow) {
        StringBuilder buff = new StringBuilder("RowMutation(");
        buff.append("keyspace='").append(this.table).append('\'');
        buff.append(", key='").append(ByteBufferUtil.bytesToHex(this.key)).append('\'');
        buff.append(", modifications=[");
        if (shallow) {
            ArrayList<String> cfnames = new ArrayList<String>(this.modifications.size());
            for (UUID cfid : this.modifications.keySet()) {
                CFMetaData cfm = Schema.instance.getCFMetaData(cfid);
                cfnames.add(cfm == null ? "-dropped-" : cfm.cfName);
            }
            buff.append(StringUtils.join(cfnames, (String)", "));
        } else {
            buff.append(StringUtils.join(this.modifications.values(), (String)", "));
        }
        return buff.append("])").toString();
    }

    public void addColumnOrSuperColumn(String cfName, ColumnOrSuperColumn cosc) {
        if (cosc.super_column != null) {
            for (Column column : cosc.super_column.columns) {
                this.add(new QueryPath(cfName, cosc.super_column.name, column.name), column.value, column.timestamp, column.ttl);
            }
        } else if (cosc.column != null) {
            this.add(new QueryPath(cfName, null, cosc.column.name), cosc.column.value, cosc.column.timestamp, cosc.column.ttl);
        } else if (cosc.counter_super_column != null) {
            for (CounterColumn column : cosc.counter_super_column.columns) {
                this.addCounter(new QueryPath(cfName, cosc.counter_super_column.name, column.name), column.value);
            }
        } else {
            this.addCounter(new QueryPath(cfName, null, cosc.counter_column.name), cosc.counter_column.value);
        }
    }

    public void deleteColumnOrSuperColumn(String cfName, Deletion del) {
        if (del.predicate != null && del.predicate.column_names != null) {
            for (ByteBuffer c : del.predicate.column_names) {
                if (del.super_column == null && Schema.instance.getColumnFamilyType(this.table, cfName) == ColumnFamilyType.Super) {
                    this.delete(new QueryPath(cfName, c), del.timestamp);
                    continue;
                }
                this.delete(new QueryPath(cfName, del.super_column, c), del.timestamp);
            }
        } else {
            this.delete(new QueryPath(cfName, del.super_column), del.timestamp);
        }
    }

    public static RowMutation fromBytes(byte[] raw, int version) throws IOException {
        RowMutation rm = serializer.deserialize(new DataInputStream(new FastByteArrayInputStream(raw)), version);
        boolean hasCounters = false;
        for (Map.Entry<UUID, ColumnFamily> entry : rm.modifications.entrySet()) {
            if (!entry.getValue().metadata().getDefaultValidator().isCommutative()) continue;
            hasCounters = true;
            break;
        }
        if (!hasCounters && version == 6) {
            rm.preserializedBuffers.put(version, raw);
        }
        return rm;
    }

    public static class RowMutationSerializer
    implements IVersionedSerializer<RowMutation> {
        @Override
        public void serialize(RowMutation rm, DataOutput dos, int version) throws IOException {
            dos.writeUTF(rm.getTable());
            ByteBufferUtil.writeWithShortLength(rm.key(), dos);
            int size = rm.modifications.size();
            dos.writeInt(size);
            assert (size >= 0);
            for (Map.Entry<UUID, ColumnFamily> entry : rm.modifications.entrySet()) {
                if (version < 6) {
                    ColumnFamily.serializer.serializeCfId(entry.getKey(), dos, version);
                }
                ColumnFamily.serializer.serialize(entry.getValue(), dos, version);
            }
        }

        public RowMutation deserialize(DataInput dis, int version, IColumnSerializer.Flag flag) throws IOException {
            String table = dis.readUTF();
            ByteBuffer key = ByteBufferUtil.readWithShortLength(dis);
            HashMap<UUID, ColumnFamily> modifications = new HashMap<UUID, ColumnFamily>();
            int size = dis.readInt();
            for (int i = 0; i < size; ++i) {
                if (version < 6) {
                    ColumnFamily.serializer.deserializeCfId(dis, version);
                }
                ColumnFamily cf = ColumnFamily.serializer.deserialize(dis, flag, TreeMapBackedSortedColumns.factory(), version);
                assert (cf != null);
                modifications.put(cf.id(), cf);
            }
            return new RowMutation(table, key, modifications);
        }

        @Override
        public RowMutation deserialize(DataInput dis, int version) throws IOException {
            return this.deserialize(dis, version, IColumnSerializer.Flag.FROM_REMOTE);
        }

        @Override
        public long serializedSize(RowMutation rm, int version) {
            TypeSizes sizes = TypeSizes.NATIVE;
            int size = sizes.sizeof(rm.getTable());
            int keySize = rm.key().remaining();
            size += sizes.sizeof((short)keySize) + keySize;
            size += sizes.sizeof(rm.modifications.size());
            for (Map.Entry<UUID, ColumnFamily> entry : rm.modifications.entrySet()) {
                if (version < 6) {
                    size += ColumnFamily.serializer.cfIdSerializedSize(entry.getValue().id(), sizes, version);
                }
                size = (int)((long)size + ColumnFamily.serializer.serializedSize(entry.getValue(), TypeSizes.NATIVE, version));
            }
            return size;
        }
    }
}

