/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.io.ISSTableSerializer;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Interval;

public class RangeTombstone
extends Interval<ByteBuffer, DeletionTime>
implements OnDiskAtom {
    public static final Serializer serializer = new Serializer();

    public RangeTombstone(ByteBuffer start, ByteBuffer stop, long markedForDeleteAt, int localDeletionTime) {
        this(start, stop, new DeletionTime(markedForDeleteAt, localDeletionTime));
    }

    public RangeTombstone(ByteBuffer start, ByteBuffer stop, DeletionTime delTime) {
        super(start, stop, delTime);
    }

    @Override
    public ByteBuffer name() {
        return (ByteBuffer)this.min;
    }

    @Override
    public int getLocalDeletionTime() {
        return ((DeletionTime)this.data).localDeletionTime;
    }

    @Override
    public long maxTimestamp() {
        return ((DeletionTime)this.data).markedForDeleteAt;
    }

    @Override
    public int serializedSize(TypeSizes typeSizes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long serializedSizeForSSTable() {
        TypeSizes typeSizes = TypeSizes.NATIVE;
        return (long)(typeSizes.sizeof((short)((ByteBuffer)this.min).remaining()) + ((ByteBuffer)this.min).remaining() + 1 + typeSizes.sizeof((short)((ByteBuffer)this.max).remaining()) + ((ByteBuffer)this.max).remaining()) + DeletionTime.serializer.serializedSize((DeletionTime)this.data, typeSizes);
    }

    @Override
    public void validateFields(CFMetaData metadata) throws MarshalException {
        AbstractType<?> nameValidator = metadata.cfType == ColumnFamilyType.Super ? metadata.subcolumnComparator : metadata.comparator;
        nameValidator.validate((ByteBuffer)this.min);
        nameValidator.validate((ByteBuffer)this.max);
    }

    @Override
    public void updateDigest(MessageDigest digest) {
        digest.update(((ByteBuffer)this.min).duplicate());
        digest.update(((ByteBuffer)this.max).duplicate());
        DataOutputBuffer buffer = new DataOutputBuffer();
        try {
            buffer.writeLong(((DeletionTime)this.data).markedForDeleteAt);
            buffer.writeInt(((DeletionTime)this.data).localDeletionTime);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        digest.update(buffer.getData(), 0, buffer.getLength());
    }

    public boolean supersedes(RangeTombstone rt, Comparator<ByteBuffer> comparator) {
        if (((DeletionTime)rt.data).markedForDeleteAt > ((DeletionTime)this.data).markedForDeleteAt) {
            return false;
        }
        return comparator.compare((ByteBuffer)this.min, (ByteBuffer)rt.min) <= 0 && comparator.compare((ByteBuffer)this.max, (ByteBuffer)rt.max) >= 0;
    }

    public static class Serializer
    implements ISSTableSerializer<RangeTombstone> {
        @Override
        public void serializeForSSTable(RangeTombstone t, DataOutput dos) throws IOException {
            ByteBufferUtil.writeWithShortLength((ByteBuffer)t.min, dos);
            dos.writeByte(16);
            ByteBufferUtil.writeWithShortLength((ByteBuffer)t.max, dos);
            DeletionTime.serializer.serialize((DeletionTime)t.data, dos);
        }

        @Override
        public RangeTombstone deserializeFromSSTable(DataInput dis, Descriptor.Version version) throws IOException {
            ByteBuffer min = ByteBufferUtil.readWithShortLength(dis);
            if (min.remaining() <= 0) {
                throw ColumnSerializer.CorruptColumnException.create(dis, min);
            }
            int b = dis.readUnsignedByte();
            assert ((b & 0x10) != 0);
            return this.deserializeBody(dis, min, version);
        }

        public RangeTombstone deserializeBody(DataInput dis, ByteBuffer min, Descriptor.Version version) throws IOException {
            ByteBuffer max = ByteBufferUtil.readWithShortLength(dis);
            if (max.remaining() <= 0) {
                throw ColumnSerializer.CorruptColumnException.create(dis, max);
            }
            DeletionTime dt = DeletionTime.serializer.deserialize(dis);
            return new RangeTombstone(min, max, dt);
        }
    }

    public static class Tracker {
        private final Comparator<ByteBuffer> comparator;
        private final Deque<RangeTombstone> ranges = new ArrayDeque<RangeTombstone>();
        private final SortedSet<RangeTombstone> maxOrderingSet = new TreeSet<RangeTombstone>(new Comparator<RangeTombstone>(){

            @Override
            public int compare(RangeTombstone t1, RangeTombstone t2) {
                return Tracker.this.comparator.compare(t1.max, t2.max);
            }
        });
        private int atomCount;

        public Tracker(Comparator<ByteBuffer> comparator) {
            this.comparator = comparator;
        }

        public long writeOpenedMarker(OnDiskAtom firstColumn, DataOutput out, OnDiskAtom.Serializer atomSerializer) throws IOException {
            long size = 0L;
            if (this.ranges.isEmpty()) {
                return size;
            }
            LinkedList<RangeTombstone> toWrite = new LinkedList<RangeTombstone>();
            block0: for (RangeTombstone tombstone : this.ranges) {
                if (this.comparator.compare(firstColumn.name(), (ByteBuffer)tombstone.max) > 0) continue;
                RangeTombstone updated = new RangeTombstone(firstColumn.name(), (ByteBuffer)tombstone.max, (DeletionTime)tombstone.data);
                Iterator iter = toWrite.iterator();
                while (iter.hasNext()) {
                    RangeTombstone other = (RangeTombstone)iter.next();
                    if (other.supersedes(updated, this.comparator)) break block0;
                    if (!updated.supersedes(other, this.comparator)) continue;
                    iter.remove();
                }
                toWrite.add(tombstone);
            }
            for (RangeTombstone tombstone : toWrite) {
                size += tombstone.serializedSizeForSSTable();
                ++this.atomCount;
                if (out == null) continue;
                atomSerializer.serializeForSSTable(tombstone, out);
            }
            return size;
        }

        public int writtenAtom() {
            return this.atomCount;
        }

        public void update(OnDiskAtom atom) {
            if (atom instanceof RangeTombstone) {
                RangeTombstone t = (RangeTombstone)atom;
                for (RangeTombstone tombstone : this.maxOrderingSet.tailSet(t)) {
                    if (this.comparator.compare((ByteBuffer)t.max, (ByteBuffer)tombstone.max) > 0) break;
                    if (!((DeletionTime)tombstone.data).equals(t.data)) continue;
                    return;
                }
                this.ranges.addLast(t);
                this.maxOrderingSet.add(t);
            } else {
                assert (atom instanceof IColumn);
                Iterator iter = this.maxOrderingSet.iterator();
                while (iter.hasNext()) {
                    RangeTombstone tombstone = (RangeTombstone)iter.next();
                    if (this.comparator.compare(atom.name(), (ByteBuffer)tombstone.max) > 0) {
                        iter.remove();
                        this.ranges.remove(tombstone);
                        continue;
                    }
                    return;
                }
            }
        }

        public boolean isDeleted(IColumn column) {
            for (RangeTombstone tombstone : this.ranges) {
                if (this.comparator.compare(column.name(), (ByteBuffer)tombstone.max) > 0 || !((DeletionTime)tombstone.data).isDeleted(column)) continue;
                return true;
            }
            return false;
        }
    }
}

