/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.CounterColumn;
import org.apache.cassandra.db.CounterUpdateColumn;
import org.apache.cassandra.db.DeletedColumn;
import org.apache.cassandra.db.ExpiringColumn;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.IColumnSerializer;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.utils.ByteBufferUtil;

public class ColumnSerializer
implements IColumnSerializer {
    public static final int DELETION_MASK = 1;
    public static final int EXPIRATION_MASK = 2;
    public static final int COUNTER_MASK = 4;
    public static final int COUNTER_UPDATE_MASK = 8;
    public static final int RANGE_TOMBSTONE_MASK = 16;

    @Override
    public void serialize(IColumn column, DataOutput dos) throws IOException {
        assert (column.name().remaining() > 0);
        ByteBufferUtil.writeWithShortLength(column.name(), dos);
        try {
            dos.writeByte(column.serializationFlags());
            if (column instanceof CounterColumn) {
                dos.writeLong(((CounterColumn)column).timestampOfLastDelete());
            } else if (column instanceof ExpiringColumn) {
                dos.writeInt(((ExpiringColumn)column).getTimeToLive());
                dos.writeInt(column.getLocalDeletionTime());
            }
            dos.writeLong(column.timestamp());
            ByteBufferUtil.writeWithLength(column.value(), dos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Column deserialize(DataInput dis) throws IOException {
        return this.deserialize(dis, IColumnSerializer.Flag.LOCAL);
    }

    public Column deserialize(DataInput dis, IColumnSerializer.Flag flag) throws IOException {
        return this.deserialize(dis, flag, (int)(System.currentTimeMillis() / 1000L));
    }

    @Override
    public Column deserialize(DataInput dis, IColumnSerializer.Flag flag, int expireBefore) throws IOException {
        ByteBuffer name = ByteBufferUtil.readWithShortLength(dis);
        if (name.remaining() <= 0) {
            throw CorruptColumnException.create(dis, name);
        }
        int b = dis.readUnsignedByte();
        return this.deserializeColumnBody(dis, name, b, flag, expireBefore);
    }

    Column deserializeColumnBody(DataInput dis, ByteBuffer name, int mask, IColumnSerializer.Flag flag, int expireBefore) throws IOException {
        if ((mask & 4) != 0) {
            long timestampOfLastDelete = dis.readLong();
            long ts = dis.readLong();
            ByteBuffer value = ByteBufferUtil.readWithLength(dis);
            return CounterColumn.create(name, value, ts, timestampOfLastDelete, flag);
        }
        if ((mask & 2) != 0) {
            int ttl = dis.readInt();
            int expiration = dis.readInt();
            long ts = dis.readLong();
            ByteBuffer value = ByteBufferUtil.readWithLength(dis);
            return ExpiringColumn.create(name, value, ts, ttl, expiration, expireBefore, flag);
        }
        long ts = dis.readLong();
        ByteBuffer value = ByteBufferUtil.readWithLength(dis);
        return (mask & 8) != 0 ? new CounterUpdateColumn(name, value, ts) : ((mask & 1) == 0 ? new Column(name, value, ts) : new DeletedColumn(name, value, ts));
    }

    @Override
    public long serializedSize(IColumn column, TypeSizes type) {
        return column.serializedSize(type);
    }

    public static class CorruptColumnException
    extends IOException {
        public CorruptColumnException(String s) {
            super(s);
        }

        public static CorruptColumnException create(DataInput dis, ByteBuffer name) {
            assert (name.remaining() <= 0);
            String format = "invalid column name length %d%s";
            String details = "";
            if (dis instanceof FileDataInput) {
                long remaining;
                FileDataInput fdis = (FileDataInput)dis;
                try {
                    remaining = fdis.bytesRemaining();
                }
                catch (IOException e) {
                    throw new FSReadError((Throwable)e, fdis.getPath());
                }
                details = String.format(" (%s, %d bytes remaining)", fdis.getPath(), remaining);
            }
            return new CorruptColumnException(String.format(format, name.remaining(), details));
        }
    }
}

