/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.auth.Resources;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.thrift.AuthenticationException;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.SemanticVersion;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientState {
    private static final Logger logger = LoggerFactory.getLogger(ClientState.class);
    public static final SemanticVersion DEFAULT_CQL_VERSION = QueryProcessor.CQL_VERSION;
    private AuthenticatedUser user;
    private String keyspace;
    private final List<Object> resource = new ArrayList<Object>();
    private SemanticVersion cqlVersion = DEFAULT_CQL_VERSION;
    private final boolean internalCall;

    public ClientState() {
        this(false);
    }

    public ClientState(boolean internalCall) {
        this.internalCall = internalCall;
        this.user = DatabaseDescriptor.getAuthenticator().defaultUser();
    }

    public String getRawKeyspace() {
        return this.keyspace;
    }

    public String getKeyspace() throws InvalidRequestException {
        if (this.keyspace == null) {
            throw new InvalidRequestException("no keyspace has been specified");
        }
        return this.keyspace;
    }

    public void setKeyspace(String ks) throws InvalidRequestException {
        if (Schema.instance.getKSMetaData(ks) == null) {
            throw new InvalidRequestException("Keyspace '" + ks + "' does not exist");
        }
        this.keyspace = ks;
    }

    public void login(Map<? extends CharSequence, ? extends CharSequence> credentials) throws AuthenticationException {
        this.user = DatabaseDescriptor.getAuthenticator().authenticate(credentials);
    }

    private void resourceClear() {
        this.resource.clear();
        this.resource.add("cassandra");
        this.resource.add("keyspaces");
    }

    public void hasKeyspaceAccess(String keyspace, Permission perm) throws UnauthorizedException, InvalidRequestException {
        this.hasColumnFamilySchemaAccess(keyspace, perm);
    }

    public void hasColumnFamilySchemaAccess(String keyspace, Permission perm) throws UnauthorizedException, InvalidRequestException {
        this.validateLogin();
        ClientState.validateKeyspace(keyspace);
        this.preventSystemKSSchemaModification(keyspace, perm);
        this.resourceClear();
        this.resource.add(keyspace);
        EnumSet<Permission> perms = DatabaseDescriptor.getAuthority().authorize(this.user, this.resource);
        ClientState.hasAccess(this.user, perms, perm, this.resource);
    }

    private void preventSystemKSSchemaModification(String keyspace, Permission perm) throws InvalidRequestException {
        if (keyspace.equalsIgnoreCase("system") && !Permission.ALLOWED_SYSTEM_ACTIONS.contains((Object)perm)) {
            throw new InvalidRequestException("system keyspace is not user-modifiable.");
        }
    }

    public void hasColumnFamilyAccess(String columnFamily, Permission perm) throws UnauthorizedException, InvalidRequestException {
        this.hasColumnFamilyAccess(this.keyspace, columnFamily, perm);
    }

    public void hasColumnFamilyAccess(String keyspace, String columnFamily, Permission perm) throws UnauthorizedException, InvalidRequestException {
        this.validateLogin();
        ClientState.validateKeyspace(keyspace);
        this.resourceClear();
        this.resource.add(keyspace);
        if (!this.internalCall) {
            this.preventSystemKSSchemaModification(keyspace, perm);
        }
        if (DatabaseDescriptor.getAuthority().authorize(this.user, this.resource).contains((Object)Permission.FULL_ACCESS)) {
            return;
        }
        this.resource.add(columnFamily);
        EnumSet<Permission> perms = DatabaseDescriptor.getAuthority().authorize(this.user, this.resource);
        ClientState.hasAccess(this.user, perms, perm, this.resource);
    }

    public boolean isLogged() {
        return this.user != null;
    }

    private void validateLogin() throws InvalidRequestException {
        if (this.user == null) {
            throw new InvalidRequestException("You have not logged in");
        }
    }

    private static void validateKeyspace(String keyspace) throws InvalidRequestException {
        if (keyspace == null) {
            throw new InvalidRequestException("You have not set a keyspace for this session");
        }
    }

    private static void hasAccess(AuthenticatedUser user, Set<Permission> perms, Permission perm, List<Object> resource) throws UnauthorizedException {
        if (perms.contains((Object)Permission.FULL_ACCESS)) {
            return;
        }
        if (perms.contains((Object)Permission.NO_ACCESS)) {
            throw new UnauthorizedException(String.format("%s does not have permission %s for %s", new Object[]{user, perm, Resources.toString(resource)}));
        }
        boolean granular = false;
        for (Permission p : perms) {
            if (!Permission.GRANULAR_PERMISSIONS.contains((Object)p)) continue;
            granular = true;
            break;
        }
        if (granular) {
            if (perms.contains((Object)perm)) {
                return;
            }
        } else {
            for (Permission p : perms) {
                if (!Permission.oldToNew.get((Object)p).contains((Object)perm)) continue;
                return;
            }
        }
        throw new UnauthorizedException(String.format("%s does not have permission %s for %s", new Object[]{user, perm, Resources.toString(resource)}));
    }

    public void setCQLVersion(String str) throws InvalidRequestException {
        SemanticVersion version;
        try {
            version = new SemanticVersion(str);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidRequestException(e.getMessage());
        }
        SemanticVersion cql = org.apache.cassandra.cql.QueryProcessor.CQL_VERSION;
        SemanticVersion cql3 = QueryProcessor.CQL_VERSION;
        SemanticVersion cql3Beta = new SemanticVersion("3.0.0-beta1");
        if (version.equals(cql3Beta)) {
            throw new InvalidRequestException(String.format("There has been a few syntax breaking changes between 3.0.0-beta1 and 3.0.0 (mainly the syntax for options of CREATE KEYSPACE and CREATE TABLE). 3.0.0-beta1  is not supported; please upgrade to 3.0.0", new Object[0]));
        }
        if (version.isSupportedBy(cql)) {
            this.cqlVersion = cql;
        } else if (version.isSupportedBy(cql3)) {
            this.cqlVersion = cql3;
        } else {
            throw new InvalidRequestException(String.format("Provided version %s is not supported by this server (supported: %s)", version, StringUtils.join((Object[])ClientState.getCQLSupportedVersion(), (String)", ")));
        }
    }

    public SemanticVersion getCQLVersion() {
        return this.cqlVersion;
    }

    public static SemanticVersion[] getCQLSupportedVersion() {
        SemanticVersion cql = org.apache.cassandra.cql.QueryProcessor.CQL_VERSION;
        SemanticVersion cql3 = QueryProcessor.CQL_VERSION;
        return new SemanticVersion[]{cql, cql3};
    }

    public void grantPermission(Permission permission, String to, CFName on, boolean grantOption) throws UnauthorizedException, InvalidRequestException {
        DatabaseDescriptor.getAuthorityContainer().grant(this.user, permission, to, on, grantOption);
    }

    public void revokePermission(Permission permission, String from, CFName resource) throws UnauthorizedException, InvalidRequestException {
        DatabaseDescriptor.getAuthorityContainer().revoke(this.user, permission, from, resource);
    }

    public ResultMessage listPermissions(String username) throws UnauthorizedException, InvalidRequestException {
        return DatabaseDescriptor.getAuthorityContainer().listPermissions(username);
    }
}

