/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.util.Collection;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.db.DefsTable;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.utils.WrappedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefinitionsUpdateVerbHandler
implements IVerbHandler<Collection<RowMutation>> {
    private static final Logger logger = LoggerFactory.getLogger(DefinitionsUpdateVerbHandler.class);

    @Override
    public void doVerb(final MessageIn<Collection<RowMutation>> message, String id) {
        logger.debug("Received schema mutation push from " + message.from);
        StageManager.getStage(Stage.MIGRATION).submit(new WrappedRunnable(){

            @Override
            public void runMayThrow() throws Exception {
                if (message.version < 4) {
                    logger.error("Can't accept schema migrations from Cassandra versions previous to 1.1, please upgrade first");
                    return;
                }
                DefsTable.mergeSchema((Collection)message.payload);
            }
        });
    }
}

