/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.DateType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.SyntaxException;

public interface ParsedType {
    public boolean isCollection();

    public AbstractType<?> getType();

    public static class Collection
    implements ParsedType {
        CollectionType type;

        private Collection(CollectionType type) {
            this.type = type;
        }

        public static Collection map(ParsedType t1, ParsedType t2) throws InvalidRequestException {
            if (t1.isCollection() || t2.isCollection()) {
                throw new InvalidRequestException("map type cannot contain another collection");
            }
            return new Collection(MapType.getInstance(t1.getType(), t2.getType()));
        }

        public static Collection list(ParsedType t) throws InvalidRequestException {
            if (t.isCollection()) {
                throw new InvalidRequestException("list type cannot contain another collection");
            }
            return new Collection(ListType.getInstance(t.getType()));
        }

        public static Collection set(ParsedType t) throws InvalidRequestException {
            if (t.isCollection()) {
                throw new InvalidRequestException("set type cannot contain another collection");
            }
            return new Collection(SetType.getInstance(t.getType()));
        }

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public AbstractType<?> getType() {
            return this.type;
        }
    }

    public static class Custom
    implements ParsedType {
        private final AbstractType<?> type;

        public Custom(String className) throws SyntaxException, ConfigurationException {
            this.type = TypeParser.parse(className);
        }

        @Override
        public boolean isCollection() {
            return false;
        }

        @Override
        public AbstractType<?> getType() {
            return this.type;
        }
    }

    public static enum Native implements ParsedType
    {
        ASCII(AsciiType.instance),
        BIGINT(LongType.instance),
        BLOB(BytesType.instance),
        BOOLEAN(BooleanType.instance),
        COUNTER(CounterColumnType.instance),
        DECIMAL(DecimalType.instance),
        DOUBLE(DoubleType.instance),
        FLOAT(FloatType.instance),
        INET(InetAddressType.instance),
        INT(Int32Type.instance),
        TEXT(UTF8Type.instance),
        TIMESTAMP(DateType.instance),
        UUID(UUIDType.instance),
        VARCHAR(UTF8Type.instance),
        VARINT(IntegerType.instance),
        TIMEUUID(TimeUUIDType.instance);

        private final AbstractType<?> type;

        private Native(AbstractType<?> type) {
            this.type = type;
        }

        @Override
        public boolean isCollection() {
            return false;
        }

        @Override
        public AbstractType<?> getType() {
            return this.type;
        }
    }
}

