/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql;

import java.io.IOException;
import java.util.Iterator;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.ColumnDef;

public class DropIndexStatement {
    public final String index;

    public DropIndexStatement(String indexName) {
        this.index = indexName;
    }

    public CFMetaData generateCFMetadataUpdate(String keyspace) throws InvalidRequestException, ConfigurationException, IOException {
        CFMetaData cfm;
        CfDef cfDef = null;
        KSMetaData ksm = Schema.instance.getTableDefinition(keyspace);
        Iterator<CFMetaData> i$ = ksm.cfMetaData().values().iterator();
        while (i$.hasNext() && (cfDef = this.getUpdatedCFDef((cfm = i$.next()).toThrift())) == null) {
        }
        if (cfDef == null) {
            throw new InvalidRequestException("Index '" + this.index + "' could not be found in any of the ColumnFamilies of keyspace '" + keyspace + "'");
        }
        return CFMetaData.fromThrift(cfDef);
    }

    private CfDef getUpdatedCFDef(CfDef cfDef) throws InvalidRequestException {
        for (ColumnDef column : cfDef.column_metadata) {
            if (!column.isSetIndex_type() || !column.isSetIndex_name() || !column.index_name.equals(this.index)) continue;
            column.unsetIndex_name();
            column.unsetIndex_type();
            return cfDef;
        }
        return null;
    }
}

