/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.utils.Allocator;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlabAllocator
extends Allocator {
    private static final Logger logger = LoggerFactory.getLogger(SlabAllocator.class);
    private static final int REGION_SIZE = 0x100000;
    private static final int MAX_CLONED_SIZE = 131072;
    private final AtomicReference<Region> currentRegion = new AtomicReference();
    private volatile int regionCount;

    @Override
    public ByteBuffer allocate(int size) {
        assert (size >= 0);
        if (size == 0) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        if (size > 131072) {
            return ByteBuffer.allocate(size);
        }
        Region region;
        ByteBuffer cloned;
        while ((cloned = (region = this.getRegion()).allocate(size)) == null) {
            this.currentRegion.compareAndSet(region, null);
        }
        return cloned;
    }

    private Region getRegion() {
        Region region;
        do {
            if ((region = this.currentRegion.get()) == null) continue;
            return region;
        } while (!this.currentRegion.compareAndSet(null, region = new Region(0x100000)));
        region.init();
        ++this.regionCount;
        logger.debug("{} regions now allocated in {}", (Object)this.regionCount, (Object)this);
        return region;
    }

    private static class Region {
        private ByteBuffer data;
        private static final int UNINITIALIZED = -1;
        private AtomicInteger nextFreeOffset = new AtomicInteger(-1);
        private AtomicInteger allocCount = new AtomicInteger();
        private final int size;

        private Region(int size) {
            this.size = size;
        }

        public void init() {
            assert (this.nextFreeOffset.get() == -1);
            this.data = ByteBuffer.allocate(this.size);
            assert (this.data.remaining() == this.data.capacity());
            boolean initted = this.nextFreeOffset.compareAndSet(-1, 0);
            Preconditions.checkState((boolean)initted, (Object)"Multiple threads tried to init same region");
        }

        public ByteBuffer allocate(int size) {
            int oldOffset;
            while (true) {
                if ((oldOffset = this.nextFreeOffset.get()) == -1) {
                    Thread.yield();
                    continue;
                }
                if (oldOffset + size > this.data.capacity()) {
                    return null;
                }
                if (this.nextFreeOffset.compareAndSet(oldOffset, oldOffset + size)) break;
            }
            this.allocCount.incrementAndGet();
            return (ByteBuffer)this.data.duplicate().position(oldOffset).limit(oldOffset + size);
        }

        public String toString() {
            return "Region@" + System.identityHashCode(this) + " allocs=" + this.allocCount.get() + "waste=" + (this.data.capacity() - this.nextFreeOffset.get());
        }
    }
}

