/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.nio.ByteBuffer;
import org.apache.cassandra.utils.Filter;
import org.apache.cassandra.utils.obs.OpenBitSet;

public abstract class BloomFilter
extends Filter {
    private static final int EXCESS = 20;
    public final OpenBitSet bitset;

    BloomFilter(int hashes, long numElements, int bucketsPer) {
        this.hashCount = hashes;
        this.bitset = new OpenBitSet(numElements * (long)bucketsPer + 20L);
    }

    BloomFilter(int hashes, OpenBitSet bitset) {
        this.hashCount = hashes;
        this.bitset = bitset;
    }

    private long[] getHashBuckets(ByteBuffer key) {
        return this.getHashBuckets(key, this.hashCount, this.bitset.size());
    }

    protected abstract long[] hash(ByteBuffer var1, int var2, int var3, long var4);

    long[] getHashBuckets(ByteBuffer b, int hashCount, long max) {
        long[] result = new long[hashCount];
        long[] hash = this.hash(b, b.position(), b.remaining(), 0L);
        for (int i = 0; i < hashCount; ++i) {
            result[i] = Math.abs((hash[0] + (long)i * hash[1]) % max);
        }
        return result;
    }

    @Override
    public void add(ByteBuffer key) {
        for (long bucketIndex : this.getHashBuckets(key)) {
            this.bitset.set(bucketIndex);
        }
    }

    @Override
    public boolean isPresent(ByteBuffer key) {
        for (long bucketIndex : this.getHashBuckets(key)) {
            if (this.bitset.get(bucketIndex)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        this.bitset.clear(0L, this.bitset.size());
    }
}

