/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport.messages;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.ServerConnection;
import org.apache.cassandra.transport.messages.ErrorMessage;
import org.jboss.netty.buffer.ChannelBuffer;

public class ExecuteMessage
extends Message.Request {
    public static final Message.Codec<ExecuteMessage> codec = new Message.Codec<ExecuteMessage>(){

        @Override
        public ExecuteMessage decode(ChannelBuffer body) {
            int id = body.readInt();
            int count = body.readUnsignedShort();
            ArrayList<ByteBuffer> values = new ArrayList<ByteBuffer>(count);
            for (int i = 0; i < count; ++i) {
                values.add(CBUtil.readValue(body));
            }
            return new ExecuteMessage(id, values);
        }

        @Override
        public ChannelBuffer encode(ExecuteMessage msg) {
            int vs = msg.values.size();
            CBUtil.BufferBuilder builder = new CBUtil.BufferBuilder(2, 0, vs);
            builder.add(CBUtil.intToCB(msg.statementId));
            builder.add(CBUtil.shortToCB(vs));
            for (ByteBuffer value : msg.values) {
                builder.addValue(value);
            }
            return builder.build();
        }
    };
    public final int statementId;
    public final List<ByteBuffer> values;

    public ExecuteMessage(int statementId, List<ByteBuffer> values) {
        super(Message.Type.EXECUTE);
        this.statementId = statementId;
        this.values = values;
    }

    @Override
    public ChannelBuffer encode() {
        return codec.encode(this);
    }

    @Override
    public Message.Response execute() {
        try {
            ServerConnection c = (ServerConnection)this.connection;
            CQLStatement statement = c.clientState().getCQL3Prepared().get(this.statementId);
            if (statement == null) {
                throw new InvalidRequestException(String.format("Prepared query with ID %d not found", this.statementId));
            }
            return QueryProcessor.processPrepared(statement, c.clientState(), this.values);
        }
        catch (Exception e) {
            return ErrorMessage.fromException(e);
        }
    }

    public String toString() {
        return "EXECUTE " + this.statementId + " with " + this.values.size() + " values";
    }
}

