/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.EnumMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.IEndpointStateChangeSubscriber;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.service.CassandraDaemon;
import org.apache.cassandra.transport.Connection;
import org.apache.cassandra.transport.Event;
import org.apache.cassandra.transport.Frame;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.RequestThreadPoolExecutor;
import org.apache.cassandra.transport.ServerConnection;
import org.apache.cassandra.transport.messages.EventMessage;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.logging.Slf4JLoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server
implements CassandraDaemon.Server {
    private static final Logger logger;
    private final ConnectionTracker connectionTracker = new ConnectionTracker();
    public final InetSocketAddress socket;
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private ChannelFactory factory;
    private ExecutionHandler executionHandler;

    public Server(InetSocketAddress socket) {
        this.socket = socket;
        Gossiper.instance.register(new EventNotifier(this));
    }

    public Server(String hostname, int port) {
        this(new InetSocketAddress(hostname, port));
    }

    public Server(InetAddress host, int port) {
        this(new InetSocketAddress(host, port));
    }

    public Server(int port) {
        this(new InetSocketAddress(port));
    }

    @Override
    public void start() {
        if (this.isRunning.compareAndSet(false, true)) {
            this.run();
        }
    }

    @Override
    public void stop() {
        if (this.isRunning.compareAndSet(true, false)) {
            this.close();
        }
    }

    @Override
    public boolean isRunning() {
        return this.isRunning.get();
    }

    public void run() {
        this.executionHandler = new ExecutionHandler((Executor)((Object)new RequestThreadPoolExecutor()));
        this.factory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
        ServerBootstrap bootstrap = new ServerBootstrap(this.factory);
        bootstrap.setPipelineFactory((ChannelPipelineFactory)new PipelineFactory(this));
        logger.info("Starting listening for CQL clients on " + this.socket + "...");
        Channel channel = bootstrap.bind((SocketAddress)this.socket);
        this.connectionTracker.allChannels.add((Object)channel);
    }

    public void close() {
        this.connectionTracker.closeAll();
        this.factory.releaseExternalResources();
        this.factory = null;
        this.executionHandler.releaseExternalResources();
        this.executionHandler = null;
    }

    static {
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new Slf4JLoggerFactory());
        logger = LoggerFactory.getLogger(Server.class);
    }

    private static class EventNotifier
    implements IEndpointStateChangeSubscriber {
        private final Server server;

        private EventNotifier(Server server) {
            this.server = server;
        }

        @Override
        public void onJoin(InetAddress endpoint, EndpointState epState) {
            this.server.connectionTracker.send(Event.TopologyChange.newNode(endpoint, this.server.socket.getPort()));
        }

        @Override
        public void onChange(InetAddress endpoint, ApplicationState state, VersionedValue value) {
        }

        @Override
        public void onAlive(InetAddress endpoint, EndpointState state) {
            this.server.connectionTracker.send(Event.StatusChange.nodeUp(endpoint, this.server.socket.getPort()));
        }

        @Override
        public void onDead(InetAddress endpoint, EndpointState state) {
            this.server.connectionTracker.send(Event.StatusChange.nodeDown(endpoint, this.server.socket.getPort()));
        }

        @Override
        public void onRemove(InetAddress endpoint) {
            this.server.connectionTracker.send(Event.TopologyChange.removedNode(endpoint, this.server.socket.getPort()));
        }

        @Override
        public void onRestart(InetAddress endpoint, EndpointState state) {
            this.server.connectionTracker.send(Event.StatusChange.nodeUp(endpoint, this.server.socket.getPort()));
        }
    }

    private static class PipelineFactory
    implements ChannelPipelineFactory {
        private static final Message.ProtocolDecoder messageDecoder = new Message.ProtocolDecoder();
        private static final Message.ProtocolEncoder messageEncoder = new Message.ProtocolEncoder();
        private static final Frame.Decompressor frameDecompressor = new Frame.Decompressor();
        private static final Frame.Compressor frameCompressor = new Frame.Compressor();
        private static final Frame.Encoder frameEncoder = new Frame.Encoder();
        private static final Message.Dispatcher dispatcher = new Message.Dispatcher();
        private final Server server;

        public PipelineFactory(Server server) {
            this.server = server;
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = Channels.pipeline();
            pipeline.addLast("frameDecoder", (ChannelHandler)new Frame.Decoder(this.server.connectionTracker, ServerConnection.FACTORY));
            pipeline.addLast("frameEncoder", (ChannelHandler)frameEncoder);
            pipeline.addLast("frameDecompressor", (ChannelHandler)frameDecompressor);
            pipeline.addLast("frameCompressor", (ChannelHandler)frameCompressor);
            pipeline.addLast("messageDecoder", (ChannelHandler)messageDecoder);
            pipeline.addLast("messageEncoder", (ChannelHandler)messageEncoder);
            pipeline.addLast("executor", (ChannelHandler)this.server.executionHandler);
            pipeline.addLast("dispatcher", (ChannelHandler)dispatcher);
            return pipeline;
        }
    }

    public static class ConnectionTracker
    implements Connection.Tracker {
        public final ChannelGroup allChannels = new DefaultChannelGroup();
        private final EnumMap<Event.Type, ChannelGroup> groups = new EnumMap(Event.Type.class);

        public ConnectionTracker() {
            for (Event.Type type : Event.Type.values()) {
                this.groups.put(type, (ChannelGroup)new DefaultChannelGroup(type.toString()));
            }
        }

        @Override
        public void addConnection(Channel ch, Connection connection) {
            this.allChannels.add((Object)ch);
        }

        public void register(Event.Type type, Channel ch) {
            this.groups.get((Object)type).add((Object)ch);
        }

        public void unregister(Channel ch) {
            for (ChannelGroup group : this.groups.values()) {
                group.remove((Object)ch);
            }
        }

        public void send(Event event) {
            this.groups.get((Object)event.type).write((Object)new EventMessage(event));
        }

        @Override
        public void closeAll() {
            this.allChannels.close().awaitUninterruptibly();
        }
    }
}

