/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.transport.ProtocolException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.util.CharsetUtil;

public abstract class CBUtil {
    private CBUtil() {
    }

    public static String readString(ChannelBuffer cb) {
        try {
            int length = cb.readUnsignedShort();
            return CBUtil.readString(cb, length);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ProtocolException("Not enough bytes to read an UTF8 serialized string preceded by it's 2 bytes length");
        }
    }

    public static String readLongString(ChannelBuffer cb) {
        try {
            int length = cb.readInt();
            return CBUtil.readString(cb, length);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ProtocolException("Not enough bytes to read an UTF8 serialized string preceded by it's 4 bytes length");
        }
    }

    private static String readString(ChannelBuffer cb, int length) {
        try {
            String str = cb.toString(cb.readerIndex(), length, CharsetUtil.UTF_8);
            cb.readerIndex(cb.readerIndex() + length);
            return str;
        }
        catch (IllegalStateException e) {
            if (e.getCause() instanceof CharacterCodingException) {
                throw new ProtocolException("Cannot decode string as UTF8");
            }
            throw e;
        }
    }

    private static ChannelBuffer bytes(String str) {
        return ChannelBuffers.wrappedBuffer((byte[])str.getBytes(CharsetUtil.UTF_8));
    }

    public static ChannelBuffer shortToCB(int s) {
        ChannelBuffer cb = ChannelBuffers.buffer((int)2);
        cb.writeShort(s);
        return cb;
    }

    public static ChannelBuffer intToCB(int i) {
        ChannelBuffer cb = ChannelBuffers.buffer((int)4);
        cb.writeInt(i);
        return cb;
    }

    public static ChannelBuffer stringToCB(String str) {
        ChannelBuffer bytes = CBUtil.bytes(str);
        return ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{CBUtil.shortToCB(bytes.readableBytes()), bytes});
    }

    public static ChannelBuffer longStringToCB(String str) {
        ChannelBuffer bytes = CBUtil.bytes(str);
        return ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{CBUtil.intToCB(bytes.readableBytes()), bytes});
    }

    public static List<String> readStringList(ChannelBuffer cb) {
        int length = cb.readUnsignedShort();
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < length; ++i) {
            l.add(CBUtil.readString(cb));
        }
        return l;
    }

    public static void writeStringList(ChannelBuffer cb, List<String> l) {
        cb.writeShort(l.size());
        for (String str : l) {
            cb.writeBytes(CBUtil.stringToCB(str));
        }
    }

    public static Map<String, String> readStringMap(ChannelBuffer cb) {
        int length = cb.readUnsignedShort();
        HashMap<String, String> m = new HashMap<String, String>(length);
        for (int i = 0; i < length; ++i) {
            String k = CBUtil.readString(cb).toUpperCase();
            String v = CBUtil.readString(cb);
            m.put(k, v);
        }
        return m;
    }

    public static void writeStringMap(ChannelBuffer cb, Map<String, String> m) {
        cb.writeShort(m.size());
        for (Map.Entry<String, String> entry : m.entrySet()) {
            cb.writeBytes(CBUtil.stringToCB(entry.getKey()));
            cb.writeBytes(CBUtil.stringToCB(entry.getValue()));
        }
    }

    public static Map<String, List<String>> readStringToStringListMap(ChannelBuffer cb) {
        int length = cb.readUnsignedShort();
        HashMap<String, List<String>> m = new HashMap<String, List<String>>(length);
        for (int i = 0; i < length; ++i) {
            String k = CBUtil.readString(cb).toUpperCase();
            List<String> v = CBUtil.readStringList(cb);
            m.put(k, v);
        }
        return m;
    }

    public static void writeStringToStringListMap(ChannelBuffer cb, Map<String, List<String>> m) {
        cb.writeShort(m.size());
        for (Map.Entry<String, List<String>> entry : m.entrySet()) {
            cb.writeBytes(CBUtil.stringToCB(entry.getKey()));
            CBUtil.writeStringList(cb, entry.getValue());
        }
    }

    public static ByteBuffer readValue(ChannelBuffer cb) {
        int length = cb.readInt();
        return length < 0 ? null : cb.readSlice(length).toByteBuffer();
    }

    public static InetSocketAddress readInet(ChannelBuffer cb) {
        byte addrSize = cb.readByte();
        byte[] address = new byte[addrSize];
        cb.readBytes(address);
        int port = cb.readInt();
        try {
            return new InetSocketAddress(InetAddress.getByAddress(address), port);
        }
        catch (UnknownHostException e) {
            throw new ProtocolException(String.format("Invalid IP address (%d.%d.%d.%d) while deserializing inet address", address[0], address[1], address[2], address[3]));
        }
    }

    public static ChannelBuffer inetToCB(InetSocketAddress inet) {
        byte[] address = inet.getAddress().getAddress();
        ChannelBuffer cb = ChannelBuffers.buffer((int)(1 + address.length + 4));
        cb.writeByte(address.length);
        cb.writeBytes(address);
        cb.writeInt(inet.getPort());
        return cb;
    }

    public static class BufferBuilder {
        private final int size;
        private final ChannelBuffer[] buffers;
        private int i;

        public BufferBuilder(int simpleBuffers, int stringBuffers, int valueBuffers) {
            this.size = simpleBuffers + 2 * stringBuffers + 2 * valueBuffers;
            this.buffers = new ChannelBuffer[this.size];
        }

        public BufferBuilder add(ChannelBuffer cb) {
            this.buffers[this.i++] = cb;
            return this;
        }

        public BufferBuilder addString(String str) {
            ChannelBuffer bytes = CBUtil.bytes(str);
            this.add(CBUtil.shortToCB(bytes.readableBytes()));
            return this.add(bytes);
        }

        public BufferBuilder addValue(ByteBuffer bb) {
            this.add(CBUtil.intToCB(bb == null ? -1 : bb.remaining()));
            return this.add(bb == null ? ChannelBuffers.EMPTY_BUFFER : ChannelBuffers.wrappedBuffer((ByteBuffer)bb));
        }

        public ChannelBuffer build() {
            return ChannelBuffers.wrappedBuffer((ChannelBuffer[])this.buffers);
        }
    }
}

