/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.thrift;

import java.net.SocketTimeoutException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomTThreadPoolServer
extends TServer {
    private static final Logger logger = LoggerFactory.getLogger((String)CustomTThreadPoolServer.class.getName());
    private final ExecutorService executorService;
    private volatile boolean stopped;
    private final TThreadPoolServer.Args args;
    private final AtomicInteger activeClients = new AtomicInteger(0);

    public CustomTThreadPoolServer(TThreadPoolServer.Args args, ExecutorService executorService) {
        super((TServer.AbstractServerArgs)args);
        this.executorService = executorService;
        this.args = args;
    }

    public void serve() {
        try {
            this.serverTransport_.listen();
        }
        catch (TTransportException ttx) {
            logger.error("Error occurred during listening.", (Throwable)ttx);
            return;
        }
        this.stopped = false;
        while (!this.stopped) {
            block8: {
                while (this.activeClients.get() >= this.args.maxWorkerThreads) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        throw new AssertionError((Object)e);
                    }
                }
                try {
                    TTransport client = this.serverTransport_.accept();
                    this.activeClients.incrementAndGet();
                    WorkerProcess wp = new WorkerProcess(client);
                    this.executorService.execute(wp);
                }
                catch (TTransportException ttx) {
                    if (ttx.getCause() instanceof SocketTimeoutException) continue;
                    if (this.stopped) break block8;
                    logger.warn("Transport error occurred during acceptance of message.", (Throwable)ttx);
                }
            }
            if (this.activeClients.get() < this.args.maxWorkerThreads) continue;
            logger.warn("Maximum number of clients " + this.args.maxWorkerThreads + " reached");
        }
        this.executorService.shutdown();
    }

    public void stop() {
        this.stopped = true;
        this.serverTransport_.interrupt();
    }

    private class WorkerProcess
    implements Runnable {
        private TTransport client_;

        private WorkerProcess(TTransport client) {
            this.client_ = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TProcessor processor = null;
            TTransport inputTransport = null;
            TTransport outputTransport = null;
            TProtocol inputProtocol = null;
            TProtocol outputProtocol = null;
            try {
                processor = CustomTThreadPoolServer.this.processorFactory_.getProcessor(this.client_);
                inputTransport = CustomTThreadPoolServer.this.inputTransportFactory_.getTransport(this.client_);
                outputTransport = CustomTThreadPoolServer.this.outputTransportFactory_.getTransport(this.client_);
                inputProtocol = CustomTThreadPoolServer.this.inputProtocolFactory_.getProtocol(inputTransport);
                outputProtocol = CustomTThreadPoolServer.this.outputProtocolFactory_.getProtocol(outputTransport);
                while (!CustomTThreadPoolServer.this.stopped && processor.process(inputProtocol, outputProtocol)) {
                    inputProtocol = CustomTThreadPoolServer.this.inputProtocolFactory_.getProtocol(inputTransport);
                    outputProtocol = CustomTThreadPoolServer.this.outputProtocolFactory_.getProtocol(outputTransport);
                }
            }
            catch (TTransportException ttx) {
                logger.debug("Thrift transport error occurred during processing of message.", (Throwable)ttx);
            }
            catch (TException tx) {
                logger.error("Thrift error occurred during processing of message.", (Throwable)tx);
            }
            catch (Exception x) {
                logger.error("Error occurred during processing of message.", (Throwable)x);
            }
            finally {
                CustomTThreadPoolServer.this.activeClients.decrementAndGet();
            }
            if (inputTransport != null) {
                inputTransport.close();
            }
            if (outputTransport != null) {
                outputTransport.close();
            }
        }
    }
}

