/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.auth.Resources;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql.CQLStatement;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.AuthenticationException;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.SemanticVersion;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientState {
    private static final int MAX_CACHE_PREPARED = 10000;
    private static final Logger logger = LoggerFactory.getLogger(ClientState.class);
    public static final SemanticVersion DEFAULT_CQL_VERSION = QueryProcessor.CQL_VERSION;
    private AuthenticatedUser user;
    private String keyspace;
    private UUID preparedTracingSession;
    private final List<Object> resource = new ArrayList<Object>();
    private SemanticVersion cqlVersion = DEFAULT_CQL_VERSION;
    private final Map<Integer, CQLStatement> prepared = new LinkedHashMap<Integer, CQLStatement>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, CQLStatement> eldest) {
            return this.size() > 10000;
        }
    };
    private final Map<Integer, org.apache.cassandra.cql3.CQLStatement> cql3Prepared = new LinkedHashMap<Integer, org.apache.cassandra.cql3.CQLStatement>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, org.apache.cassandra.cql3.CQLStatement> eldest) {
            return this.size() > 10000;
        }
    };
    private long clock;

    public ClientState() {
        this.reset();
    }

    public Map<Integer, CQLStatement> getPrepared() {
        return this.prepared;
    }

    public Map<Integer, org.apache.cassandra.cql3.CQLStatement> getCQL3Prepared() {
        return this.cql3Prepared;
    }

    public String getRawKeyspace() {
        return this.keyspace;
    }

    public String getKeyspace() throws InvalidRequestException {
        if (this.keyspace == null) {
            throw new InvalidRequestException("no keyspace has been specified");
        }
        return this.keyspace;
    }

    public void setKeyspace(String ks) throws InvalidRequestException {
        if (Schema.instance.getKSMetaData(ks) == null) {
            throw new InvalidRequestException("Keyspace '" + ks + "' does not exist");
        }
        this.keyspace = ks;
    }

    public boolean traceNextQuery() {
        if (this.preparedTracingSession != null) {
            return true;
        }
        double tracingProbability = StorageService.instance.getTracingProbability();
        return tracingProbability != 0.0 && FBUtilities.threadLocalRandom().nextDouble() < tracingProbability;
    }

    public void prepareTracingSession(UUID sessionId) {
        this.preparedTracingSession = sessionId;
    }

    public void createSession() {
        if (this.preparedTracingSession == null) {
            Tracing.instance().newSession();
        } else {
            UUID session = this.preparedTracingSession;
            this.preparedTracingSession = null;
            Tracing.instance().newSession(session);
        }
    }

    public String getSchedulingValue() {
        switch (DatabaseDescriptor.getRequestSchedulerId()) {
            case keyspace: {
                return this.keyspace;
            }
        }
        return "default";
    }

    public void login(Map<? extends CharSequence, ? extends CharSequence> credentials) throws AuthenticationException {
        AuthenticatedUser user = DatabaseDescriptor.getAuthenticator().authenticate(credentials);
        if (logger.isDebugEnabled()) {
            logger.debug("logged in: {}", (Object)user);
        }
        this.user = user;
    }

    public void logout() {
        if (logger.isDebugEnabled()) {
            logger.debug("logged out: {}", (Object)this.user);
        }
        this.reset();
    }

    private void resourceClear() {
        this.resource.clear();
        this.resource.add("cassandra");
        this.resource.add("keyspaces");
    }

    public void reset() {
        this.user = DatabaseDescriptor.getAuthenticator().defaultUser();
        this.keyspace = null;
        this.preparedTracingSession = null;
        this.resourceClear();
        this.prepared.clear();
        this.cql3Prepared.clear();
    }

    public void hasKeyspaceAccess(String keyspace, Permission perm) throws UnauthorizedException, InvalidRequestException {
        this.hasColumnFamilySchemaAccess(keyspace, perm);
    }

    public void hasColumnFamilySchemaAccess(String keyspace, Permission perm) throws UnauthorizedException, InvalidRequestException {
        this.validateLogin();
        ClientState.validateKeyspace(keyspace);
        if (keyspace.equalsIgnoreCase("system") && perm != Permission.USE) {
            throw new InvalidRequestException("system keyspace is not user-modifiable");
        }
        this.resourceClear();
        this.resource.add(keyspace);
        EnumSet<Permission> perms = DatabaseDescriptor.getAuthority().authorize(this.user, this.resource);
        ClientState.hasAccess(this.user, perms, perm, this.resource);
    }

    public void hasColumnFamilyAccess(String columnFamily, Permission perm) throws UnauthorizedException, InvalidRequestException {
        this.hasColumnFamilyAccess(this.keyspace, columnFamily, perm);
    }

    public void hasColumnFamilyAccess(String keyspace, String columnFamily, Permission perm) throws UnauthorizedException, InvalidRequestException {
        this.validateLogin();
        ClientState.validateKeyspace(keyspace);
        this.resourceClear();
        this.resource.add(keyspace);
        if (DatabaseDescriptor.getAuthority().authorize(this.user, this.resource).contains((Object)Permission.FULL_ACCESS)) {
            return;
        }
        this.resource.add(columnFamily);
        EnumSet<Permission> perms = DatabaseDescriptor.getAuthority().authorize(this.user, this.resource);
        ClientState.hasAccess(this.user, perms, perm, this.resource);
    }

    public boolean isLogged() {
        return this.user != null;
    }

    private void validateLogin() throws InvalidRequestException {
        if (this.user == null) {
            throw new InvalidRequestException("You have not logged in");
        }
    }

    private static void validateKeyspace(String keyspace) throws InvalidRequestException {
        if (keyspace == null) {
            throw new InvalidRequestException("You have not set a keyspace for this session");
        }
    }

    private static void hasAccess(AuthenticatedUser user, Set<Permission> perms, Permission perm, List<Object> resource) throws UnauthorizedException {
        if (perms.contains((Object)Permission.FULL_ACCESS)) {
            return;
        }
        if (perms.contains((Object)Permission.NO_ACCESS)) {
            throw new UnauthorizedException(String.format("%s does not have permission %s for %s", new Object[]{user, perm, Resources.toString(resource)}));
        }
        boolean granular = false;
        for (Permission p : perms) {
            if (!Permission.GRANULAR_PERMISSIONS.contains((Object)p)) continue;
            granular = true;
            break;
        }
        if (granular) {
            if (perms.contains((Object)perm)) {
                return;
            }
        } else {
            for (Permission p : perms) {
                if (!Permission.oldToNew.get((Object)p).contains((Object)perm)) continue;
                return;
            }
        }
        throw new UnauthorizedException(String.format("%s does not have permission %s for %s", new Object[]{user, perm, Resources.toString(resource)}));
    }

    public long getTimestamp() {
        long current = System.currentTimeMillis() * 1000L;
        this.clock = this.clock >= current ? this.clock + 1L : current;
        return this.clock;
    }

    public void setCQLVersion(String str) throws InvalidRequestException {
        SemanticVersion version;
        try {
            version = new SemanticVersion(str);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidRequestException(e.getMessage());
        }
        SemanticVersion cql = org.apache.cassandra.cql.QueryProcessor.CQL_VERSION;
        SemanticVersion cql3 = QueryProcessor.CQL_VERSION;
        if (version.isSupportedBy(cql)) {
            this.cqlVersion = cql;
        } else if (version.isSupportedBy(cql3)) {
            this.cqlVersion = cql3;
        } else {
            throw new InvalidRequestException(String.format("Provided version %s is not supported by this server (supported: %s)", version, StringUtils.join((Object[])ClientState.getCQLSupportedVersion(), (String)", ")));
        }
    }

    public SemanticVersion getCQLVersion() {
        return this.cqlVersion;
    }

    public static SemanticVersion[] getCQLSupportedVersion() {
        SemanticVersion cql = org.apache.cassandra.cql.QueryProcessor.CQL_VERSION;
        SemanticVersion cql3 = QueryProcessor.CQL_VERSION;
        return new SemanticVersion[]{cql, cql3};
    }

    public void grantPermission(Permission permission, String to, CFName on, boolean grantOption) throws UnauthorizedException, InvalidRequestException {
        DatabaseDescriptor.getAuthorityContainer().grant(this.user, permission, to, on, grantOption);
    }

    public void revokePermission(Permission permission, String from, CFName resource) throws UnauthorizedException, InvalidRequestException {
        DatabaseDescriptor.getAuthorityContainer().revoke(this.user, permission, from, resource);
    }

    public ResultMessage listPermissions(String username) throws UnauthorizedException, InvalidRequestException {
        return DatabaseDescriptor.getAuthorityContainer().listPermissions(username);
    }
}

