/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.BlacklistedDirectories;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.SystemTable;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.FSError;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.service.GCInspector;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.ThriftServer;
import org.apache.cassandra.utils.CLibrary;
import org.apache.cassandra.utils.Mx4jTool;
import org.apache.log4j.PropertyConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraDaemon {
    private static final Logger logger;
    private static final CassandraDaemon instance;
    static final AtomicInteger exceptions;
    public Server thriftServer;
    public Server nativeServer;

    public static void initLog4j() {
        if (System.getProperty("log4j.defaultInitOverride", "false").equalsIgnoreCase("true")) {
            String config = System.getProperty("log4j.configuration", "log4j-server.properties");
            URL configLocation = null;
            try {
                configLocation = new URL(config);
            }
            catch (MalformedURLException ex) {
                configLocation = CassandraDaemon.class.getClassLoader().getResource(config);
            }
            if (configLocation == null) {
                throw new RuntimeException("Couldn't figure out log4j configuration: " + config);
            }
            String configFileName = null;
            try {
                configFileName = configLocation.getFile();
                File configFile = new File(configFileName);
                if (!configFile.exists()) {
                    configFileName = new File(configLocation.toURI()).getCanonicalPath();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't convert log4j configuration location to a valid file", e);
            }
            PropertyConfigurator.configureAndWatch((String)configFileName, (long)10000L);
            org.apache.log4j.Logger.getLogger(CassandraDaemon.class).info((Object)"Logging initialized");
        }
    }

    protected void setup() throws IOException {
        logger.info("JVM vendor/version: {}/{}", (Object)System.getProperty("java.vm.name"), (Object)System.getProperty("java.version"));
        logger.info("Heap size: {}/{}", (Object)Runtime.getRuntime().totalMemory(), (Object)Runtime.getRuntime().maxMemory());
        logger.info("Classpath: {}", (Object)System.getProperty("java.class.path"));
        CLibrary.tryMlockall();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                exceptions.incrementAndGet();
                logger.error("Exception in thread " + t, e);
                for (Throwable e2 = e; e2 != null; e2 = e2.getCause()) {
                    if (e2 instanceof OutOfMemoryError) {
                        System.exit(100);
                    }
                    if (!(e2 instanceof FSError)) continue;
                    if (e2 != e) {
                        logger.error("Exception in thread " + t, e2);
                    }
                    this.handleFSError((FSError)e2);
                }
            }

            private void handleFSError(FSError e) {
                switch (DatabaseDescriptor.getDiskFailurePolicy()) {
                    case stop: {
                        logger.error("Stopping the gossiper and the RPC server");
                        StorageService.instance.stopGossiping();
                        StorageService.instance.stopRPCServer();
                        break;
                    }
                    case best_effort: {
                        File directory;
                        BlacklistedDirectories.maybeMarkUnwritable(e.path);
                        if (!(e instanceof FSReadError) || (directory = BlacklistedDirectories.maybeMarkUnreadable(e.path)) == null) break;
                        Table.removeUnreadableSSTables(directory);
                        break;
                    }
                    case ignore: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        });
        Iterable dirs = Iterables.concat(Arrays.asList(DatabaseDescriptor.getAllDataFileLocations()), Arrays.asList(DatabaseDescriptor.getCommitLogLocation(), DatabaseDescriptor.getSavedCachesLocation()));
        for (String string : dirs) {
            logger.debug("Checking directory {}", (Object)string);
            File dir = new File(string);
            if (dir.exists()) assert (dir.isDirectory() && dir.canRead() && dir.canWrite() && dir.canExecute()) : String.format("Directory %s is not accessible.", string);
        }
        if (Directories.sstablesNeedsMigration()) {
            Directories.migrateSSTables();
        }
        if (CacheService.instance == null) {
            throw new RuntimeException("Failed to initialize Cache Service.");
        }
        for (CFMetaData cFMetaData : Schema.instance.getTableMetaData("system").values()) {
            ColumnFamilyStore.scrubDataDirectories("system", cFMetaData.cfName);
        }
        try {
            SystemTable.checkHealth();
        }
        catch (ConfigurationException e) {
            logger.error("Fatal exception during initialization", (Throwable)e);
            System.exit(100);
        }
        try {
            DatabaseDescriptor.loadSchemas();
        }
        catch (IOException e) {
            logger.error("Fatal exception during initialization", (Throwable)e);
            System.exit(100);
        }
        for (String string : Schema.instance.getTables()) {
            for (CFMetaData cfm : Schema.instance.getTableMetaData(string).values()) {
                ColumnFamilyStore.scrubDataDirectories(string, cfm.cfName);
            }
        }
        for (String string : Schema.instance.getTables()) {
            if (logger.isDebugEnabled()) {
                logger.debug("opening keyspace " + string);
            }
            for (ColumnFamilyStore cfs : Table.open(string).getColumnFamilyStores()) {
                for (ColumnFamilyStore store : cfs.concatWithIndexes()) {
                    store.disableAutoCompaction();
                }
            }
        }
        if (CacheService.instance.keyCache.size() > 0) {
            logger.info("completed pre-loading ({} keys) key cache.", (Object)CacheService.instance.keyCache.size());
        }
        if (CacheService.instance.rowCache.size() > 0) {
            logger.info("completed pre-loading ({} keys) row cache.", (Object)CacheService.instance.rowCache.size());
        }
        try {
            GCInspector.instance.start();
        }
        catch (Throwable t) {
            logger.warn("Unable to start GCInspector (currently only supported on the Sun JVM)");
        }
        CommitLog.instance.recover();
        for (Table table : Table.all()) {
            for (ColumnFamilyStore cfs : table.getColumnFamilyStores()) {
                for (ColumnFamilyStore store : cfs.concatWithIndexes()) {
                    store.enableAutoCompaction();
                }
            }
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (Table table : Table.all()) {
                    for (ColumnFamilyStore cf : table.getColumnFamilyStores()) {
                        for (ColumnFamilyStore store : cf.concatWithIndexes()) {
                            CompactionManager.instance.submitBackground(store);
                        }
                    }
                }
            }
        };
        StorageService.optionalTasks.schedule(runnable, 300L, TimeUnit.SECONDS);
        SystemTable.finishStartup();
        StorageService.instance.registerDaemon(this);
        try {
            StorageService.instance.initServer();
        }
        catch (ConfigurationException configurationException) {
            logger.error("Fatal configuration error", (Throwable)configurationException);
            System.err.println(configurationException.getMessage() + "\nFatal configuration error; unable to start server.  See log for stacktrace.");
            System.exit(1);
        }
        Mx4jTool.maybeLoad();
        InetAddress inetAddress = DatabaseDescriptor.getRpcAddress();
        int rpcPort = DatabaseDescriptor.getRpcPort();
        this.thriftServer = new ThriftServer(inetAddress, rpcPort);
        InetAddress nativeAddr = DatabaseDescriptor.getNativeTransportAddress();
        int nativePort = DatabaseDescriptor.getNativeTransportPort();
        this.nativeServer = new org.apache.cassandra.transport.Server(nativeAddr, nativePort);
    }

    public void init(String[] arguments) throws IOException {
        this.setup();
    }

    public void start() {
        String rpcFlag = System.getProperty("cassandra.start_rpc");
        if (rpcFlag != null && Boolean.parseBoolean(rpcFlag) || rpcFlag == null && DatabaseDescriptor.startRpc()) {
            this.thriftServer.start();
        } else {
            logger.info("Not starting RPC server as requested. Use JMX (StorageService->startRPCServer()) to start it");
        }
        String nativeFlag = System.getProperty("cassandra.start_native_transport");
        if (nativeFlag != null && Boolean.parseBoolean(nativeFlag) || nativeFlag == null && DatabaseDescriptor.startNativeTransport()) {
            this.nativeServer.start();
        } else {
            logger.info("Not starting native transport as requested. Use JMX (StorageService->startNativeTransport()) to start it");
        }
    }

    public void stop() {
        logger.info("Cassandra shutting down...");
        this.thriftServer.stop();
        this.nativeServer.stop();
    }

    public void destroy() {
    }

    public void activate() {
        String pidFile = System.getProperty("cassandra-pidfile");
        try {
            this.setup();
            if (pidFile != null) {
                new File(pidFile).deleteOnExit();
            }
            if (System.getProperty("cassandra-foreground") == null) {
                System.out.close();
                System.err.close();
            }
            this.start();
        }
        catch (Throwable e) {
            logger.error("Exception encountered during startup", e);
            e.printStackTrace();
            System.out.println("Exception encountered during startup: " + e.getMessage());
            System.exit(3);
        }
    }

    public void deactivate() {
        this.stop();
        this.destroy();
    }

    public static void stop(String[] args) {
        instance.deactivate();
    }

    public static void main(String[] args) {
        instance.activate();
    }

    static {
        CassandraDaemon.initLog4j();
        logger = LoggerFactory.getLogger(CassandraDaemon.class);
        instance = new CassandraDaemon();
        exceptions = new AtomicInteger();
    }

    public static interface Server {
        public void start();

        public void stop();

        public boolean isRunning();
    }
}

