/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.metrics.ConnectionMetrics;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.OutboundTcpConnection;
import org.apache.cassandra.security.SSLFactory;
import org.apache.cassandra.utils.FBUtilities;

public class OutboundTcpConnectionPool {
    private final IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
    private final InetAddress id;
    public final OutboundTcpConnection cmdCon;
    public final OutboundTcpConnection ackCon;
    private InetAddress resetedEndpoint;
    private ConnectionMetrics metrics;

    OutboundTcpConnectionPool(InetAddress remoteEp) {
        this.id = remoteEp;
        this.cmdCon = new OutboundTcpConnection(this);
        this.cmdCon.start();
        this.ackCon = new OutboundTcpConnection(this);
        this.ackCon.start();
        this.metrics = new ConnectionMetrics(this.id, this);
    }

    OutboundTcpConnection getConnection(MessageOut msg) {
        Stage stage = msg.getStage();
        return stage == Stage.REQUEST_RESPONSE || stage == Stage.INTERNAL_RESPONSE || stage == Stage.GOSSIP ? this.ackCon : this.cmdCon;
    }

    void reset() {
        for (OutboundTcpConnection conn : new OutboundTcpConnection[]{this.cmdCon, this.ackCon}) {
            conn.closeSocket();
        }
    }

    public void resetToNewerVersion(int version) {
        for (OutboundTcpConnection conn : new OutboundTcpConnection[]{this.cmdCon, this.ackCon}) {
            if (version <= conn.getTargetVersion()) continue;
            conn.softCloseSocket();
        }
    }

    public void reset(InetAddress remoteEP) {
        this.resetedEndpoint = remoteEP;
        for (OutboundTcpConnection conn : new OutboundTcpConnection[]{this.cmdCon, this.ackCon}) {
            conn.softCloseSocket();
        }
        this.metrics.release();
        this.metrics = new ConnectionMetrics(this.resetedEndpoint, this);
    }

    public long getTimeouts() {
        return this.metrics.timeouts.count();
    }

    public long getRecentTimeouts() {
        return this.metrics.getRecentTimeout();
    }

    public void incrementTimeout() {
        this.metrics.timeouts.mark();
    }

    public Socket newSocket() throws IOException {
        if (this.isEncryptedChannel()) {
            if (Config.getOutboundBindAny()) {
                return SSLFactory.getSocket(DatabaseDescriptor.getEncryptionOptions(), this.endPoint(), DatabaseDescriptor.getSSLStoragePort());
            }
            return SSLFactory.getSocket(DatabaseDescriptor.getEncryptionOptions(), this.endPoint(), DatabaseDescriptor.getSSLStoragePort(), FBUtilities.getLocalAddress(), 0);
        }
        Socket socket = SocketChannel.open(new InetSocketAddress(this.endPoint(), DatabaseDescriptor.getStoragePort())).socket();
        if (Config.getOutboundBindAny()) {
            socket.bind(new InetSocketAddress(FBUtilities.getLocalAddress(), 0));
        }
        return socket;
    }

    InetAddress endPoint() {
        return this.resetedEndpoint == null ? this.id : this.resetedEndpoint;
    }

    boolean isEncryptedChannel() {
        switch (DatabaseDescriptor.getEncryptionOptions().internode_encryption) {
            case none: {
                return false;
            }
            case all: {
                break;
            }
            case dc: {
                if (!this.snitch.getDatacenter(this.id).equals(this.snitch.getDatacenter(FBUtilities.getBroadcastAddress()))) break;
                return false;
            }
            case rack: {
                if (!this.snitch.getRack(this.id).equals(this.snitch.getRack(FBUtilities.getBroadcastAddress())) || !this.snitch.getDatacenter(this.id).equals(this.snitch.getDatacenter(FBUtilities.getBroadcastAddress()))) break;
                return false;
            }
        }
        return true;
    }
}

